/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.numbers.gamma.Gamma;
import org.apache.commons.numbers.gamma.RegularizedGamma;

public class NakagamiDistribution
extends AbstractContinuousDistribution {
    private final double mu;
    private final double omega;

    public NakagamiDistribution(double d, double d2) {
        if (d < 0.5) {
            throw new DistributionException("{0} < {1}", d, 0.5);
        }
        if (d2 <= 0.0) {
            throw new DistributionException("Number {0} is negative", d2);
        }
        this.mu = d;
        this.omega = d2;
    }

    public double getShape() {
        return this.mu;
    }

    public double getScale() {
        return this.omega;
    }

    @Override
    public double density(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        return 2.0 * Math.pow(this.mu, this.mu) / (Gamma.value(this.mu) * Math.pow(this.omega, this.mu)) * Math.pow(d, 2.0 * this.mu - 1.0) * Math.exp(-this.mu * d * d / this.omega);
    }

    @Override
    public double cumulativeProbability(double d) {
        return RegularizedGamma.P.value(this.mu, this.mu * d * d / this.omega);
    }

    @Override
    public double getMean() {
        return Gamma.value(this.mu + 0.5) / Gamma.value(this.mu) * Math.sqrt(this.omega / this.mu);
    }

    @Override
    public double getVariance() {
        double d = Gamma.value(this.mu + 0.5) / Gamma.value(this.mu);
        return this.omega * (1.0 - 1.0 / this.mu * d * d);
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

