/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.inference;

import io.virtdata.shaded.oac.statistics.distribution.NormalDistribution;
import io.virtdata.shaded.oac.statistics.ranking.NaNStrategy;
import io.virtdata.shaded.oac.statistics.ranking.NaturalRanking;
import io.virtdata.shaded.oac.statistics.ranking.TiesStrategy;
import org.apache.commons.math4.exception.ConvergenceException;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MaxCountExceededException;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.util.FastMath;

public class WilcoxonSignedRankTest {
    private NaturalRanking naturalRanking;

    public WilcoxonSignedRankTest() {
        this.naturalRanking = new NaturalRanking(NaNStrategy.FIXED, TiesStrategy.AVERAGE);
    }

    public WilcoxonSignedRankTest(NaNStrategy naNStrategy, TiesStrategy tiesStrategy) {
        this.naturalRanking = new NaturalRanking(naNStrategy, tiesStrategy);
    }

    private void ensureDataConformance(double[] dArray, double[] dArray2) throws NullArgumentException, NoDataException, DimensionMismatchException {
        if (dArray == null || dArray2 == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0 || dArray2.length == 0) {
            throw new NoDataException();
        }
        if (dArray2.length != dArray.length) {
            throw new DimensionMismatchException(dArray2.length, dArray.length);
        }
    }

    private double[] calculateDifferences(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = dArray2[i] - dArray[i];
        }
        return dArray3;
    }

    private double[] calculateAbsoluteDifferences(double[] dArray) throws NullArgumentException, NoDataException {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0) {
            throw new NoDataException();
        }
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = FastMath.abs(dArray[i]);
        }
        return dArray2;
    }

    public double wilcoxonSignedRank(double[] dArray, double[] dArray2) throws NullArgumentException, NoDataException, DimensionMismatchException {
        int n;
        this.ensureDataConformance(dArray, dArray2);
        double[] dArray3 = this.calculateDifferences(dArray, dArray2);
        double[] dArray4 = this.calculateAbsoluteDifferences(dArray3);
        double[] dArray5 = this.naturalRanking.rank(dArray4);
        double d = 0.0;
        for (n = 0; n < dArray3.length; ++n) {
            if (!(dArray3[n] > 0.0)) continue;
            d += dArray5[n];
        }
        n = dArray.length;
        double d2 = (double)(n * (n + 1)) / 2.0 - d;
        return FastMath.max(d, d2);
    }

    private double calculateExactPValue(double d, int n) {
        int n2 = 1 << n;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            for (int j = 0; j < n; ++j) {
                if ((i >> j & 1) != 1) continue;
                n4 += j + 1;
            }
            if (!((double)n4 >= d)) continue;
            ++n3;
        }
        return 2.0 * (double)n3 / (double)n2;
    }

    private double calculateAsymptoticPValue(double d, int n) {
        double d2 = (double)(n * (n + 1)) / 4.0;
        double d3 = d2 * ((double)(2 * n + 1) / 6.0);
        double d4 = (d - d2 - 0.5) / FastMath.sqrt(d3);
        NormalDistribution normalDistribution = new NormalDistribution(0.0, 1.0);
        return 2.0 * normalDistribution.cumulativeProbability(d4);
    }

    public double wilcoxonSignedRankTest(double[] dArray, double[] dArray2, boolean bl) throws NullArgumentException, NoDataException, DimensionMismatchException, NumberIsTooLargeException, ConvergenceException, MaxCountExceededException {
        this.ensureDataConformance(dArray, dArray2);
        int n = dArray.length;
        double d = this.wilcoxonSignedRank(dArray, dArray2);
        if (bl && n > 30) {
            throw new NumberIsTooLargeException(n, (Number)30, true);
        }
        if (bl) {
            return this.calculateExactPValue(d, n);
        }
        double d2 = (double)(n * (n + 1)) / 2.0 - d;
        return this.calculateAsymptoticPValue(d2, n);
    }
}

