/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.integration.gauss;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.Pair;

public abstract class BaseRuleFactory<T extends Number> {
    private final Map<Integer, Pair<T[], T[]>> pointsAndWeights = new TreeMap<Integer, Pair<T[], T[]>>();
    private final Map<Integer, Pair<double[], double[]>> pointsAndWeightsDouble = new TreeMap<Integer, Pair<double[], double[]>>();

    public Pair<double[], double[]> getRule(int n) throws NotStrictlyPositiveException, DimensionMismatchException {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, n);
        }
        Pair<double[], double[]> pair = this.pointsAndWeightsDouble.get(n);
        if (pair == null) {
            Pair<T[], T[]> pair2 = this.getRuleInternal(n);
            pair = BaseRuleFactory.convertToDouble(pair2);
            this.pointsAndWeightsDouble.put(n, pair);
        }
        return new Pair<double[], double[]>((double[])pair.getFirst().clone(), (double[])pair.getSecond().clone());
    }

    protected synchronized Pair<T[], T[]> getRuleInternal(int n) throws DimensionMismatchException {
        Pair<T[], T[]> pair = this.pointsAndWeights.get(n);
        if (pair == null) {
            this.addRule(this.computeRule(n));
            return this.getRuleInternal(n);
        }
        return pair;
    }

    protected void addRule(Pair<T[], T[]> pair) throws DimensionMismatchException {
        if (((Number[])pair.getFirst()).length != ((Number[])pair.getSecond()).length) {
            throw new DimensionMismatchException(((Number[])pair.getFirst()).length, ((Number[])pair.getSecond()).length);
        }
        this.pointsAndWeights.put(((Number[])pair.getFirst()).length, pair);
    }

    protected abstract Pair<T[], T[]> computeRule(int var1) throws DimensionMismatchException;

    private static <T extends Number> Pair<double[], double[]> convertToDouble(Pair<T[], T[]> pair) {
        Number[] numberArray = (Number[])pair.getFirst();
        Number[] numberArray2 = (Number[])pair.getSecond();
        int n = numberArray.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = numberArray[i].doubleValue();
            dArray2[i] = numberArray2[i].doubleValue();
        }
        return new Pair<double[], double[]>(dArray, dArray2);
    }
}

