/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.integration.gauss;

import java.math.BigDecimal;
import java.math.MathContext;
import org.apache.commons.math4.analysis.integration.gauss.BaseRuleFactory;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.util.Pair;

public class LegendreHighPrecisionRuleFactory
extends BaseRuleFactory<BigDecimal> {
    private final MathContext mContext;
    private final BigDecimal two;
    private final BigDecimal minusOne;
    private final BigDecimal oneHalf;

    public LegendreHighPrecisionRuleFactory() {
        this(MathContext.DECIMAL128);
    }

    public LegendreHighPrecisionRuleFactory(MathContext mathContext) {
        this.mContext = mathContext;
        this.two = new BigDecimal("2", mathContext);
        this.minusOne = new BigDecimal("-1", mathContext);
        this.oneHalf = new BigDecimal("0.5", mathContext);
    }

    @Override
    protected Pair<BigDecimal[], BigDecimal[]> computeRule(int n) throws DimensionMismatchException {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        if (n == 1) {
            return new Pair<BigDecimal[], BigDecimal[]>(new BigDecimal[]{BigDecimal.ZERO}, new BigDecimal[]{this.two});
        }
        BigDecimal[] bigDecimalArray = (BigDecimal[])this.getRuleInternal(n - 1).getFirst();
        BigDecimal[] bigDecimalArray2 = new BigDecimal[n];
        BigDecimal[] bigDecimalArray3 = new BigDecimal[n];
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            BigDecimal bigDecimal3;
            BigDecimal bigDecimal4;
            BigDecimal bigDecimal5;
            BigDecimal bigDecimal6;
            BigDecimal bigDecimal7;
            BigDecimal bigDecimal8;
            BigDecimal bigDecimal9 = i == 0 ? this.minusOne : bigDecimalArray[i - 1];
            bigDecimal2 = n2 == 1 ? BigDecimal.ONE : bigDecimalArray[i];
            bigDecimal = BigDecimal.ONE;
            BigDecimal bigDecimal10 = bigDecimal9;
            BigDecimal bigDecimal11 = BigDecimal.ONE;
            BigDecimal bigDecimal12 = bigDecimal2;
            for (int j = 1; j < n; ++j) {
                bigDecimal8 = new BigDecimal(2 * j + 1, this.mContext);
                bigDecimal7 = new BigDecimal(j, this.mContext);
                BigDecimal bigDecimal13 = new BigDecimal(j + 1, this.mContext);
                bigDecimal6 = bigDecimal9.multiply(bigDecimal8, this.mContext);
                bigDecimal6 = bigDecimal10.multiply(bigDecimal6, this.mContext);
                bigDecimal5 = bigDecimal.multiply(bigDecimal7, this.mContext);
                bigDecimal4 = bigDecimal6.subtract(bigDecimal5, this.mContext);
                bigDecimal4 = bigDecimal4.divide(bigDecimal13, this.mContext);
                bigDecimal6 = bigDecimal2.multiply(bigDecimal8, this.mContext);
                bigDecimal6 = bigDecimal12.multiply(bigDecimal6, this.mContext);
                bigDecimal5 = bigDecimal11.multiply(bigDecimal7, this.mContext);
                bigDecimal3 = bigDecimal6.subtract(bigDecimal5, this.mContext);
                bigDecimal3 = bigDecimal3.divide(bigDecimal13, this.mContext);
                bigDecimal = bigDecimal10;
                bigDecimal10 = bigDecimal4;
                bigDecimal11 = bigDecimal12;
                bigDecimal12 = bigDecimal3;
            }
            BigDecimal bigDecimal14 = bigDecimal9.add(bigDecimal2, this.mContext).multiply(this.oneHalf, this.mContext);
            bigDecimal8 = BigDecimal.ONE;
            bigDecimal7 = bigDecimal14;
            boolean bl = false;
            while (!bl) {
                bigDecimal6 = bigDecimal2.subtract(bigDecimal9, this.mContext);
                bl = bigDecimal6.compareTo(bigDecimal5 = bigDecimal14.ulp().multiply(BigDecimal.TEN, this.mContext)) <= 0;
                bigDecimal8 = BigDecimal.ONE;
                bigDecimal7 = bigDecimal14;
                for (int j = 1; j < n; ++j) {
                    bigDecimal3 = new BigDecimal(2 * j + 1, this.mContext);
                    BigDecimal bigDecimal15 = new BigDecimal(j, this.mContext);
                    BigDecimal bigDecimal16 = new BigDecimal(j + 1, this.mContext);
                    bigDecimal6 = bigDecimal14.multiply(bigDecimal3, this.mContext);
                    bigDecimal6 = bigDecimal7.multiply(bigDecimal6, this.mContext);
                    bigDecimal5 = bigDecimal8.multiply(bigDecimal15, this.mContext);
                    BigDecimal bigDecimal17 = bigDecimal6.subtract(bigDecimal5, this.mContext);
                    bigDecimal17 = bigDecimal17.divide(bigDecimal16, this.mContext);
                    bigDecimal8 = bigDecimal7;
                    bigDecimal7 = bigDecimal17;
                }
                if (bl) continue;
                if (bigDecimal10.signum() * bigDecimal7.signum() <= 0) {
                    bigDecimal2 = bigDecimal14;
                    bigDecimal11 = bigDecimal8;
                    bigDecimal12 = bigDecimal7;
                } else {
                    bigDecimal9 = bigDecimal14;
                    bigDecimal = bigDecimal8;
                    bigDecimal10 = bigDecimal7;
                }
                bigDecimal14 = bigDecimal9.add(bigDecimal2, this.mContext).multiply(this.oneHalf, this.mContext);
            }
            bigDecimal6 = new BigDecimal(n, this.mContext);
            bigDecimal5 = bigDecimal8.subtract(bigDecimal14.multiply(bigDecimal7, this.mContext), this.mContext);
            bigDecimal5 = bigDecimal5.multiply(bigDecimal6);
            bigDecimal5 = bigDecimal5.pow(2, this.mContext);
            bigDecimal4 = bigDecimal14.pow(2, this.mContext);
            bigDecimal4 = BigDecimal.ONE.subtract(bigDecimal4, this.mContext);
            bigDecimal4 = bigDecimal4.multiply(this.two, this.mContext);
            bigDecimal4 = bigDecimal4.divide(bigDecimal5, this.mContext);
            bigDecimalArray2[i] = bigDecimal14;
            bigDecimalArray3[i] = bigDecimal4;
            int n3 = n - i - 1;
            bigDecimalArray2[n3] = bigDecimal14.negate(this.mContext);
            bigDecimalArray3[n3] = bigDecimal4;
        }
        if (n % 2 != 0) {
            BigDecimal bigDecimal18 = BigDecimal.ONE;
            for (int i = 1; i < n; i += 2) {
                bigDecimal2 = new BigDecimal(i, this.mContext);
                bigDecimal = new BigDecimal(i + 1, this.mContext);
                bigDecimal18 = bigDecimal18.multiply(bigDecimal2, this.mContext);
                bigDecimal18 = bigDecimal18.divide(bigDecimal, this.mContext);
                bigDecimal18 = bigDecimal18.negate(this.mContext);
            }
            BigDecimal bigDecimal19 = new BigDecimal(n, this.mContext);
            bigDecimal2 = bigDecimal18.multiply(bigDecimal19, this.mContext);
            bigDecimal2 = bigDecimal2.pow(2, this.mContext);
            bigDecimal = this.two.divide(bigDecimal2, this.mContext);
            bigDecimalArray2[n2] = BigDecimal.ZERO;
            bigDecimalArray3[n2] = bigDecimal;
        }
        return new Pair<BigDecimal[], BigDecimal[]>(bigDecimalArray2, bigDecimalArray3);
    }
}

