/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.integration.gauss;

import org.apache.commons.math4.analysis.UnivariateFunction;
import org.apache.commons.math4.analysis.integration.gauss.GaussIntegrator;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NonMonotonicSequenceException;
import org.apache.commons.math4.util.Pair;

public class SymmetricGaussIntegrator
extends GaussIntegrator {
    public SymmetricGaussIntegrator(double[] dArray, double[] dArray2) throws NonMonotonicSequenceException, DimensionMismatchException {
        super(dArray, dArray2);
    }

    public SymmetricGaussIntegrator(Pair<double[], double[]> pair) throws NonMonotonicSequenceException {
        this(pair.getFirst(), pair.getSecond());
    }

    @Override
    public double integrate(UnivariateFunction univariateFunction) {
        int n = this.getNumberOfPoints();
        if (n == 1) {
            return this.getWeight(0) * univariateFunction.value(0.0);
        }
        int n2 = n / 2;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d3 = this.getPoint(i);
            double d4 = this.getWeight(i);
            double d5 = univariateFunction.value(d3);
            double d6 = univariateFunction.value(-d3);
            double d7 = d4 * (d5 + d6) - d2;
            double d8 = d + d7;
            d2 = d8 - d - d7;
            d = d8;
        }
        if (n % 2 != 0) {
            double d9;
            double d10 = this.getWeight(n2);
            double d11 = d10 * univariateFunction.value(0.0) - d2;
            d = d9 = d + d11;
        }
        return d;
    }
}

