/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.interpolation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math4.FieldElement;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.ZeroException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;

public class FieldHermiteInterpolator<T extends FieldElement<T>> {
    private final List<T> abscissae = new ArrayList<T>();
    private final List<T[]> topDiagonal = new ArrayList<T[]>();
    private final List<T[]> bottomDiagonal = new ArrayList<T[]>();

    @SafeVarargs
    public final void addSamplePoint(T fieldElement, T[] ... TArray) throws ZeroException, MathArithmeticException, DimensionMismatchException, NullArgumentException {
        MathUtils.checkNotNull(fieldElement);
        FieldElement fieldElement2 = (FieldElement)fieldElement.getField().getOne();
        for (int i = 0; i < TArray.length; ++i) {
            FieldElement[] fieldElementArray = (FieldElement[])TArray[i].clone();
            if (i > 1) {
                fieldElement2 = (FieldElement)fieldElement2.multiply(i);
                FieldElement fieldElement3 = (FieldElement)fieldElement2.reciprocal();
                for (int j = 0; j < fieldElementArray.length; ++j) {
                    fieldElementArray[j] = fieldElementArray[j].multiply(fieldElement3);
                }
            }
            int n = this.abscissae.size();
            this.bottomDiagonal.add(n - i, fieldElementArray);
            FieldElement[] fieldElementArray2 = fieldElementArray;
            for (int j = i; j < n; ++j) {
                FieldElement[] fieldElementArray3 = (FieldElement[])this.bottomDiagonal.get(n - (j + 1));
                if (fieldElement.equals(this.abscissae.get(n - (j + 1)))) {
                    throw new ZeroException((Localizable)LocalizedFormats.DUPLICATED_ABSCISSA_DIVISION_BY_ZERO, fieldElement);
                }
                FieldElement fieldElement4 = (FieldElement)fieldElement.subtract((FieldElement)((FieldElement)this.abscissae.get(n - (j + 1)))).reciprocal();
                for (int k = 0; k < fieldElementArray.length; ++k) {
                    fieldElementArray3[k] = fieldElement4.multiply(fieldElementArray2[k].subtract(fieldElementArray3[k]));
                }
                fieldElementArray2 = fieldElementArray3;
            }
            this.topDiagonal.add((FieldElement[])fieldElementArray2.clone());
            this.abscissae.add(fieldElement);
        }
    }

    public T[] value(T fieldElement) throws NoDataException, NullArgumentException {
        MathUtils.checkNotNull(fieldElement);
        if (this.abscissae.isEmpty()) {
            throw new NoDataException(LocalizedFormats.EMPTY_INTERPOLATION_SAMPLE);
        }
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(fieldElement.getField(), ((FieldElement[])this.topDiagonal.get(0)).length);
        FieldElement fieldElement2 = (FieldElement)fieldElement.getField().getOne();
        for (int i = 0; i < this.topDiagonal.size(); ++i) {
            FieldElement[] fieldElementArray2 = (FieldElement[])this.topDiagonal.get(i);
            for (int j = 0; j < fieldElementArray.length; ++j) {
                fieldElementArray[j] = fieldElementArray[j].add(fieldElementArray2[j].multiply(fieldElement2));
            }
            FieldElement fieldElement3 = fieldElement.subtract((FieldElement)((FieldElement)this.abscissae.get(i)));
            fieldElement2 = fieldElement2.multiply(fieldElement3);
        }
        return fieldElementArray;
    }

    public T[][] derivatives(T fieldElement, int n) throws NoDataException, NullArgumentException {
        MathUtils.checkNotNull(fieldElement);
        if (this.abscissae.isEmpty()) {
            throw new NoDataException(LocalizedFormats.EMPTY_INTERPOLATION_SAMPLE);
        }
        FieldElement fieldElement2 = (FieldElement)fieldElement.getField().getZero();
        FieldElement fieldElement3 = (FieldElement)fieldElement.getField().getOne();
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(fieldElement.getField(), n + 1);
        fieldElementArray[0] = fieldElement2;
        for (int i = 0; i < n; ++i) {
            fieldElementArray[i + 1] = fieldElementArray[i].add(fieldElement3);
        }
        FieldElement[][] fieldElementArray2 = (FieldElement[][])MathArrays.buildArray(fieldElement.getField(), n + 1, ((FieldElement[])this.topDiagonal.get(0)).length);
        FieldElement[] fieldElementArray3 = (FieldElement[])MathArrays.buildArray(fieldElement.getField(), n + 1);
        fieldElementArray3[0] = (FieldElement)fieldElement.getField().getOne();
        for (int i = 0; i < this.topDiagonal.size(); ++i) {
            FieldElement[] fieldElementArray4 = (FieldElement[])this.topDiagonal.get(i);
            FieldElement fieldElement4 = fieldElement.subtract((FieldElement)((FieldElement)this.abscissae.get(i)));
            for (int j = n; j >= 0; --j) {
                for (int k = 0; k < fieldElementArray2[j].length; ++k) {
                    fieldElementArray2[j][k] = fieldElementArray2[j][k].add(fieldElementArray4[k].multiply(fieldElementArray3[j]));
                }
                fieldElementArray3[j] = fieldElementArray3[j].multiply(fieldElement4);
                if (j <= 0) continue;
                fieldElementArray3[j] = fieldElementArray3[j].add(fieldElementArray[j].multiply(fieldElementArray3[j - 1]));
            }
        }
        return fieldElementArray2;
    }
}

