/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.solvers;

import org.apache.commons.math4.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math4.exception.NoBracketingException;
import org.apache.commons.math4.exception.TooManyEvaluationsException;
import org.apache.commons.math4.util.FastMath;

public class RiddersSolver
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public RiddersSolver() {
        this(1.0E-6);
    }

    public RiddersSolver(double d) {
        super(d);
    }

    public RiddersSolver(double d, double d2) {
        super(d, d2);
    }

    @Override
    protected double doSolve() throws TooManyEvaluationsException, NoBracketingException {
        double d = this.getMin();
        double d2 = this.getMax();
        double d3 = d;
        double d4 = this.computeObjectiveValue(d3);
        double d5 = d2;
        double d6 = this.computeObjectiveValue(d5);
        if (d4 == 0.0) {
            return d;
        }
        if (d6 == 0.0) {
            return d2;
        }
        this.verifyBracketing(d, d2);
        double d7 = this.getAbsoluteAccuracy();
        double d8 = this.getFunctionValueAccuracy();
        double d9 = this.getRelativeAccuracy();
        double d10 = Double.POSITIVE_INFINITY;
        double d11;
        double d12;
        while (!(FastMath.abs(d12 = this.computeObjectiveValue(d11 = 0.5 * (d3 + d5))) <= d8)) {
            double d13 = 1.0 - d4 * d6 / (d12 * d12);
            double d14 = FastMath.signum(d6) * FastMath.signum(d12) * (d11 - d3) / FastMath.sqrt(d13);
            double d15 = d11 - d14;
            double d16 = this.computeObjectiveValue(d15);
            double d17 = FastMath.max(d9 * FastMath.abs(d15), d7);
            if (FastMath.abs(d15 - d10) <= d17) {
                return d15;
            }
            if (FastMath.abs(d16) <= d8) {
                return d15;
            }
            if (d14 > 0.0) {
                if (FastMath.signum(d4) + FastMath.signum(d16) == 0.0) {
                    d5 = d15;
                    d6 = d16;
                } else {
                    d3 = d15;
                    d5 = d11;
                    d4 = d16;
                    d6 = d12;
                }
            } else if (FastMath.signum(d6) + FastMath.signum(d16) == 0.0) {
                d3 = d15;
                d4 = d16;
            } else {
                d3 = d11;
                d5 = d15;
                d4 = d12;
                d6 = d16;
            }
            d10 = d15;
        }
        return d11;
    }
}

