/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.fraction;

import java.io.Serializable;
import java.math.BigInteger;
import org.apache.commons.math4.FieldElement;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.fraction.FractionConversionException;
import org.apache.commons.math4.fraction.FractionField;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.numbers.core.ArithmeticUtils;

public class Fraction
extends Number
implements FieldElement<Fraction>,
Comparable<Fraction>,
Serializable {
    public static final Fraction TWO = new Fraction(2, 1);
    public static final Fraction ONE = new Fraction(1, 1);
    public static final Fraction ZERO = new Fraction(0, 1);
    public static final Fraction FOUR_FIFTHS = new Fraction(4, 5);
    public static final Fraction ONE_FIFTH = new Fraction(1, 5);
    public static final Fraction ONE_HALF = new Fraction(1, 2);
    public static final Fraction ONE_QUARTER = new Fraction(1, 4);
    public static final Fraction ONE_THIRD = new Fraction(1, 3);
    public static final Fraction THREE_FIFTHS = new Fraction(3, 5);
    public static final Fraction THREE_QUARTERS = new Fraction(3, 4);
    public static final Fraction TWO_FIFTHS = new Fraction(2, 5);
    public static final Fraction TWO_QUARTERS = new Fraction(2, 4);
    public static final Fraction TWO_THIRDS = new Fraction(2, 3);
    public static final Fraction MINUS_ONE = new Fraction(-1, 1);
    private static final long serialVersionUID = 3698073679419233275L;
    private static final double DEFAULT_EPSILON = 1.0E-5;
    private final int denominator;
    private final int numerator;

    public Fraction(double d) throws FractionConversionException {
        this(d, 1.0E-5, 100);
    }

    public Fraction(double d, double d2, int n) throws FractionConversionException {
        this(d, d2, Integer.MAX_VALUE, n);
    }

    public Fraction(double d, int n) throws FractionConversionException {
        this(d, 0.0, n, 100);
    }

    private Fraction(double d, double d2, int n, int n2) throws FractionConversionException {
        long l = Integer.MAX_VALUE;
        double d3 = d;
        long l2 = (long)FastMath.floor(d3);
        if (FastMath.abs(l2) > l) {
            throw new FractionConversionException(d, l2, 1L);
        }
        if (FastMath.abs((double)l2 - d) < d2) {
            this.numerator = (int)l2;
            this.denominator = 1;
            return;
        }
        long l3 = 1L;
        long l4 = 0L;
        long l5 = l2;
        long l6 = 1L;
        long l7 = 0L;
        long l8 = 1L;
        int n3 = 0;
        boolean bl = false;
        do {
            ++n3;
            double d4 = 1.0 / (d3 - (double)l2);
            long l9 = (long)FastMath.floor(d4);
            l7 = l9 * l5 + l3;
            l8 = l9 * l6 + l4;
            if (FastMath.abs(l7) > l || FastMath.abs(l8) > l) {
                if (d2 == 0.0 && FastMath.abs(l6) < (long)n) break;
                throw new FractionConversionException(d, l7, l8);
            }
            double d5 = (double)l7 / (double)l8;
            if (n3 < n2 && FastMath.abs(d5 - d) > d2 && l8 < (long)n) {
                l3 = l5;
                l5 = l7;
                l4 = l6;
                l6 = l8;
                l2 = l9;
                d3 = d4;
                continue;
            }
            bl = true;
        } while (!bl);
        if (n3 >= n2) {
            throw new FractionConversionException(d, n2);
        }
        if (l8 < (long)n) {
            this.numerator = (int)l7;
            this.denominator = (int)l8;
        } else {
            this.numerator = (int)l5;
            this.denominator = (int)l6;
        }
    }

    public Fraction(int n) {
        this(n, 1);
    }

    public Fraction(int n, int n2) {
        int n3;
        if (n2 == 0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR_IN_FRACTION, n, n2);
        }
        if (n2 < 0) {
            if (n == Integer.MIN_VALUE || n2 == Integer.MIN_VALUE) {
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_FRACTION, n, n2);
            }
            n = -n;
            n2 = -n2;
        }
        if ((n3 = ArithmeticUtils.gcd(n, n2)) > 1) {
            n /= n3;
            n2 /= n3;
        }
        if (n2 < 0) {
            n = -n;
            n2 = -n2;
        }
        this.numerator = n;
        this.denominator = n2;
    }

    public Fraction abs() {
        Fraction fraction = this.numerator >= 0 ? this : this.negate();
        return fraction;
    }

    @Override
    public int compareTo(Fraction fraction) {
        long l = (long)this.numerator * (long)fraction.denominator;
        long l2 = (long)this.denominator * (long)fraction.numerator;
        return l < l2 ? -1 : (l > l2 ? 1 : 0);
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Fraction) {
            Fraction fraction = (Fraction)object;
            return this.numerator == fraction.numerator && this.denominator == fraction.denominator;
        }
        return false;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int hashCode() {
        return 37 * (629 + this.numerator) + this.denominator;
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public Fraction negate() {
        if (this.numerator == Integer.MIN_VALUE) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_FRACTION, this.numerator, this.denominator);
        }
        return new Fraction(-this.numerator, this.denominator);
    }

    @Override
    public Fraction reciprocal() {
        return new Fraction(this.denominator, this.numerator);
    }

    @Override
    public Fraction add(Fraction fraction) {
        return this.addSub(fraction, true);
    }

    @Override
    public Fraction add(int n) {
        return new Fraction(this.numerator + n * this.denominator, this.denominator);
    }

    @Override
    public Fraction subtract(Fraction fraction) {
        return this.addSub(fraction, false);
    }

    @Override
    public Fraction subtract(int n) {
        return new Fraction(this.numerator - n * this.denominator, this.denominator);
    }

    private Fraction addSub(Fraction fraction, boolean bl) {
        int n;
        int n2;
        if (fraction == null) {
            throw new NullArgumentException(LocalizedFormats.FRACTION, new Object[0]);
        }
        if (this.numerator == 0) {
            return bl ? fraction : fraction.negate();
        }
        if (fraction.numerator == 0) {
            return this;
        }
        int n3 = ArithmeticUtils.gcd(this.denominator, fraction.denominator);
        if (n3 == 1) {
            int n4 = ArithmeticUtils.mulAndCheck(this.numerator, fraction.denominator);
            int n5 = ArithmeticUtils.mulAndCheck(fraction.numerator, this.denominator);
            return new Fraction(bl ? ArithmeticUtils.addAndCheck(n4, n5) : ArithmeticUtils.subAndCheck(n4, n5), ArithmeticUtils.mulAndCheck(this.denominator, fraction.denominator));
        }
        BigInteger bigInteger = BigInteger.valueOf(this.numerator).multiply(BigInteger.valueOf(fraction.denominator / n3));
        BigInteger bigInteger2 = BigInteger.valueOf(fraction.numerator).multiply(BigInteger.valueOf(this.denominator / n3));
        BigInteger bigInteger3 = bl ? bigInteger.add(bigInteger2) : bigInteger.subtract(bigInteger2);
        BigInteger bigInteger4 = bigInteger3.divide(BigInteger.valueOf(n2 = (n = bigInteger3.mod(BigInteger.valueOf(n3)).intValue()) == 0 ? n3 : ArithmeticUtils.gcd(n, n3)));
        if (bigInteger4.bitLength() > 31) {
            throw new MathArithmeticException(LocalizedFormats.NUMERATOR_OVERFLOW_AFTER_MULTIPLY, bigInteger4);
        }
        return new Fraction(bigInteger4.intValue(), ArithmeticUtils.mulAndCheck(this.denominator / n3, fraction.denominator / n2));
    }

    @Override
    public Fraction multiply(Fraction fraction) {
        if (fraction == null) {
            throw new NullArgumentException(LocalizedFormats.FRACTION, new Object[0]);
        }
        if (this.numerator == 0 || fraction.numerator == 0) {
            return ZERO;
        }
        int n = ArithmeticUtils.gcd(this.numerator, fraction.denominator);
        int n2 = ArithmeticUtils.gcd(fraction.numerator, this.denominator);
        return Fraction.getReducedFraction(ArithmeticUtils.mulAndCheck(this.numerator / n, fraction.numerator / n2), ArithmeticUtils.mulAndCheck(this.denominator / n2, fraction.denominator / n));
    }

    @Override
    public Fraction multiply(int n) {
        return this.multiply(new Fraction(n));
    }

    @Override
    public Fraction divide(Fraction fraction) {
        if (fraction == null) {
            throw new NullArgumentException(LocalizedFormats.FRACTION, new Object[0]);
        }
        if (fraction.numerator == 0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_FRACTION_TO_DIVIDE_BY, fraction.numerator, fraction.denominator);
        }
        return this.multiply(fraction.reciprocal());
    }

    @Override
    public Fraction divide(int n) {
        return this.divide(new Fraction(n));
    }

    public double percentageValue() {
        return 100.0 * this.doubleValue();
    }

    public static Fraction getReducedFraction(int n, int n2) {
        if (n2 == 0) {
            throw new MathArithmeticException(LocalizedFormats.ZERO_DENOMINATOR_IN_FRACTION, n, n2);
        }
        if (n == 0) {
            return ZERO;
        }
        if (n2 == Integer.MIN_VALUE && (n & 1) == 0) {
            n /= 2;
            n2 /= 2;
        }
        if (n2 < 0) {
            if (n == Integer.MIN_VALUE || n2 == Integer.MIN_VALUE) {
                throw new MathArithmeticException(LocalizedFormats.OVERFLOW_IN_FRACTION, n, n2);
            }
            n = -n;
            n2 = -n2;
        }
        int n3 = ArithmeticUtils.gcd(n, n2);
        return new Fraction(n /= n3, n2 /= n3);
    }

    public String toString() {
        Object object = null;
        object = this.denominator == 1 ? Integer.toString(this.numerator) : (this.numerator == 0 ? "0" : this.numerator + " / " + this.denominator);
        return object;
    }

    public FractionField getField() {
        return FractionField.getInstance();
    }
}

