/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import java.io.Serializable;
import org.apache.commons.math4.Field;
import org.apache.commons.math4.FieldElement;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.linear.FieldMatrix;
import org.apache.commons.math4.linear.FieldVector;
import org.apache.commons.math4.linear.FieldVectorChangingVisitor;
import org.apache.commons.math4.linear.FieldVectorPreservingVisitor;
import org.apache.commons.math4.linear.SparseFieldMatrix;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;
import org.apache.commons.math4.util.OpenIntToFieldHashMap;

public class SparseFieldVector<T extends FieldElement<T>>
implements FieldVector<T>,
Serializable {
    private static final long serialVersionUID = 7841233292190413362L;
    private final Field<T> field;
    private final OpenIntToFieldHashMap<T> entries;
    private final int virtualSize;

    public SparseFieldVector(Field<T> field) {
        this(field, 0);
    }

    public SparseFieldVector(Field<T> field, int n) {
        this.field = field;
        this.virtualSize = n;
        this.entries = new OpenIntToFieldHashMap<T>(field);
    }

    protected SparseFieldVector(SparseFieldVector<T> sparseFieldVector, int n) {
        this.field = sparseFieldVector.field;
        this.virtualSize = sparseFieldVector.getDimension() + n;
        this.entries = new OpenIntToFieldHashMap<T>(sparseFieldVector.entries);
    }

    public SparseFieldVector(Field<T> field, int n, int n2) {
        this.field = field;
        this.virtualSize = n;
        this.entries = new OpenIntToFieldHashMap<T>(field, n2);
    }

    public SparseFieldVector(Field<T> field, T[] TArray) throws NullArgumentException {
        MathUtils.checkNotNull(TArray);
        this.field = field;
        this.virtualSize = TArray.length;
        this.entries = new OpenIntToFieldHashMap<T>(field);
        for (int i = 0; i < TArray.length; ++i) {
            T t = TArray[i];
            this.entries.put(i, t);
        }
    }

    public SparseFieldVector(SparseFieldVector<T> sparseFieldVector) {
        this.field = sparseFieldVector.field;
        this.virtualSize = sparseFieldVector.getDimension();
        this.entries = new OpenIntToFieldHashMap<T>(sparseFieldVector.getEntries());
    }

    private OpenIntToFieldHashMap<T> getEntries() {
        return this.entries;
    }

    @Override
    public FieldVector<T> add(SparseFieldVector<T> sparseFieldVector) throws DimensionMismatchException {
        this.checkVectorDimensions(sparseFieldVector.getDimension());
        SparseFieldVector sparseFieldVector2 = (SparseFieldVector)this.copy();
        OpenIntToFieldHashMap.Iterator iterator = sparseFieldVector.getEntries().iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int n = iterator.key();
            Object t = iterator.value();
            if (this.entries.containsKey(n)) {
                sparseFieldVector2.setEntry(n, (FieldElement)this.entries.get(n).add(t));
                continue;
            }
            sparseFieldVector2.setEntry(n, t);
        }
        return sparseFieldVector2;
    }

    @Override
    public FieldVector<T> append(SparseFieldVector<T> sparseFieldVector) {
        SparseFieldVector sparseFieldVector2 = new SparseFieldVector(this, sparseFieldVector.getDimension());
        OpenIntToFieldHashMap.Iterator iterator = sparseFieldVector.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            sparseFieldVector2.setEntry(iterator.key() + this.virtualSize, iterator.value());
        }
        return sparseFieldVector2;
    }

    @Override
    public FieldVector<T> append(FieldVector<T> fieldVector) {
        if (fieldVector instanceof SparseFieldVector) {
            return this.append((T)((SparseFieldVector)fieldVector));
        }
        int n = fieldVector.getDimension();
        SparseFieldVector<T> sparseFieldVector = new SparseFieldVector<T>(this, n);
        for (int i = 0; i < n; ++i) {
            sparseFieldVector.setEntry(i + this.virtualSize, fieldVector.getEntry(i));
        }
        return sparseFieldVector;
    }

    @Override
    public FieldVector<T> append(T t) throws NullArgumentException {
        MathUtils.checkNotNull(t);
        SparseFieldVector<T> sparseFieldVector = new SparseFieldVector<T>(this, 1);
        sparseFieldVector.setEntry(this.virtualSize, t);
        return sparseFieldVector;
    }

    @Override
    public FieldVector<T> copy() {
        return new SparseFieldVector<T>(this);
    }

    @Override
    public T dotProduct(FieldVector<T> fieldVector) throws DimensionMismatchException {
        this.checkVectorDimensions(fieldVector.getDimension());
        FieldElement fieldElement = (FieldElement)this.field.getZero();
        OpenIntToFieldHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            fieldElement = fieldElement.add((FieldElement)fieldVector.getEntry(iterator.key()).multiply(iterator.value()));
        }
        return (T)fieldElement;
    }

    @Override
    public FieldVector<T> ebeDivide(FieldVector<T> fieldVector) throws DimensionMismatchException, MathArithmeticException {
        this.checkVectorDimensions(fieldVector.getDimension());
        SparseFieldVector<FieldElement> sparseFieldVector = new SparseFieldVector<FieldElement>(this);
        OpenIntToFieldHashMap.Iterator iterator = sparseFieldVector.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            sparseFieldVector.setEntry(iterator.key(), (FieldElement)iterator.value().divide(fieldVector.getEntry(iterator.key())));
        }
        return sparseFieldVector;
    }

    @Override
    public FieldVector<T> ebeMultiply(FieldVector<T> fieldVector) throws DimensionMismatchException {
        this.checkVectorDimensions(fieldVector.getDimension());
        SparseFieldVector<FieldElement> sparseFieldVector = new SparseFieldVector<FieldElement>(this);
        OpenIntToFieldHashMap.Iterator iterator = sparseFieldVector.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            sparseFieldVector.setEntry(iterator.key(), (FieldElement)iterator.value().multiply(fieldVector.getEntry(iterator.key())));
        }
        return sparseFieldVector;
    }

    @Override
    public int getDimension() {
        return this.virtualSize;
    }

    @Override
    public T getEntry(int n) throws OutOfRangeException {
        this.checkIndex(n);
        return this.entries.get(n);
    }

    @Override
    public Field<T> getField() {
        return this.field;
    }

    @Override
    public FieldVector<T> getSubVector(int n, int n2) throws OutOfRangeException, NotPositiveException {
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.NUMBER_OF_ELEMENTS_SHOULD_BE_POSITIVE, n2);
        }
        this.checkIndex(n);
        this.checkIndex(n + n2 - 1);
        SparseFieldVector sparseFieldVector = new SparseFieldVector(this.field, n2);
        int n3 = n + n2;
        OpenIntToFieldHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int n4 = iterator.key();
            if (n4 < n || n4 >= n3) continue;
            sparseFieldVector.setEntry(n4 - n, iterator.value());
        }
        return sparseFieldVector;
    }

    @Override
    public FieldVector<T> mapAdd(T t) throws NullArgumentException {
        return this.copy().mapAddToSelf(t);
    }

    @Override
    public FieldVector<T> mapAddToSelf(T t) throws NullArgumentException {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, (FieldElement)this.getEntry(i).add(t));
        }
        return this;
    }

    @Override
    public FieldVector<T> mapDivide(T t) throws NullArgumentException, MathArithmeticException {
        return this.copy().mapDivideToSelf(t);
    }

    @Override
    public FieldVector<T> mapDivideToSelf(T t) throws NullArgumentException, MathArithmeticException {
        OpenIntToFieldHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            this.entries.put(iterator.key(), (FieldElement)iterator.value().divide(t));
        }
        return this;
    }

    @Override
    public FieldVector<T> mapInv() throws MathArithmeticException {
        return this.copy().mapInvToSelf();
    }

    @Override
    public FieldVector<T> mapInvToSelf() throws MathArithmeticException {
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, (FieldElement)((FieldElement)this.field.getOne()).divide(this.getEntry(i)));
        }
        return this;
    }

    @Override
    public FieldVector<T> mapMultiply(T t) throws NullArgumentException {
        return this.copy().mapMultiplyToSelf(t);
    }

    @Override
    public FieldVector<T> mapMultiplyToSelf(T t) throws NullArgumentException {
        OpenIntToFieldHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            this.entries.put(iterator.key(), (FieldElement)iterator.value().multiply(t));
        }
        return this;
    }

    @Override
    public FieldVector<T> mapSubtract(T t) throws NullArgumentException {
        return this.copy().mapSubtractToSelf(t);
    }

    @Override
    public FieldVector<T> mapSubtractToSelf(T t) throws NullArgumentException {
        return this.mapAddToSelf((FieldElement)((FieldElement)this.field.getZero()).subtract(t));
    }

    @Override
    public FieldMatrix<T> outerProduct(SparseFieldVector<T> sparseFieldVector) {
        int n = sparseFieldVector.getDimension();
        SparseFieldMatrix<FieldElement> sparseFieldMatrix = new SparseFieldMatrix<FieldElement>(this.field, this.virtualSize, n);
        OpenIntToFieldHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            OpenIntToFieldHashMap.Iterator iterator2 = sparseFieldVector.entries.iterator();
            while (iterator2.hasNext()) {
                iterator2.advance();
                sparseFieldMatrix.setEntry(iterator.key(), iterator2.key(), (FieldElement)iterator.value().multiply(iterator2.value()));
            }
        }
        return sparseFieldMatrix;
    }

    @Override
    public FieldMatrix<T> outerProduct(FieldVector<T> fieldVector) {
        if (fieldVector instanceof SparseFieldVector) {
            return this.outerProduct((SparseFieldVector)fieldVector);
        }
        int n = fieldVector.getDimension();
        SparseFieldMatrix<FieldElement> sparseFieldMatrix = new SparseFieldMatrix<FieldElement>(this.field, this.virtualSize, n);
        OpenIntToFieldHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int n2 = iterator.key();
            T t = iterator.value();
            for (int i = 0; i < n; ++i) {
                sparseFieldMatrix.setEntry(n2, i, (FieldElement)t.multiply(fieldVector.getEntry(i)));
            }
        }
        return sparseFieldMatrix;
    }

    @Override
    public FieldVector<T> projection(FieldVector<T> fieldVector) throws DimensionMismatchException, MathArithmeticException {
        this.checkVectorDimensions(fieldVector.getDimension());
        return fieldVector.mapMultiply((FieldElement)this.dotProduct(fieldVector).divide(fieldVector.dotProduct(fieldVector)));
    }

    @Override
    public void set(T t) {
        MathUtils.checkNotNull(t);
        for (int i = 0; i < this.virtualSize; ++i) {
            this.setEntry(i, t);
        }
    }

    @Override
    public void setEntry(int n, T t) throws NullArgumentException, OutOfRangeException {
        MathUtils.checkNotNull(t);
        this.checkIndex(n);
        this.entries.put(n, t);
    }

    @Override
    public void setSubVector(int n, FieldVector<T> fieldVector) throws OutOfRangeException {
        this.checkIndex(n);
        this.checkIndex(n + fieldVector.getDimension() - 1);
        int n2 = fieldVector.getDimension();
        for (int i = 0; i < n2; ++i) {
            this.setEntry(i + n, fieldVector.getEntry(i));
        }
    }

    @Override
    public SparseFieldVector<T> subtract(SparseFieldVector<T> sparseFieldVector) throws DimensionMismatchException {
        this.checkVectorDimensions(sparseFieldVector.getDimension());
        SparseFieldVector sparseFieldVector2 = (SparseFieldVector)this.copy();
        OpenIntToFieldHashMap.Iterator iterator = sparseFieldVector.getEntries().iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int n = iterator.key();
            if (this.entries.containsKey(n)) {
                sparseFieldVector2.setEntry(n, (FieldElement)this.entries.get(n).subtract(iterator.value()));
                continue;
            }
            sparseFieldVector2.setEntry(n, (FieldElement)((FieldElement)this.field.getZero()).subtract(iterator.value()));
        }
        return sparseFieldVector2;
    }

    @Override
    public FieldVector<T> subtract(FieldVector<T> fieldVector) throws DimensionMismatchException {
        if (fieldVector instanceof SparseFieldVector) {
            return this.subtract((SparseFieldVector)fieldVector);
        }
        int n = fieldVector.getDimension();
        this.checkVectorDimensions(n);
        SparseFieldVector<FieldElement> sparseFieldVector = new SparseFieldVector<FieldElement>(this);
        for (int i = 0; i < n; ++i) {
            if (this.entries.containsKey(i)) {
                sparseFieldVector.setEntry(i, (FieldElement)this.entries.get(i).subtract(fieldVector.getEntry(i)));
                continue;
            }
            sparseFieldVector.setEntry(i, (FieldElement)((FieldElement)this.field.getZero()).subtract(fieldVector.getEntry(i)));
        }
        return sparseFieldVector;
    }

    @Override
    public T[] toArray() {
        FieldElement[] fieldElementArray = (FieldElement[])MathArrays.buildArray(this.field, this.virtualSize);
        OpenIntToFieldHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            fieldElementArray[iterator.key()] = iterator.value();
        }
        return fieldElementArray;
    }

    private void checkIndex(int n) throws OutOfRangeException {
        if (n < 0 || n >= this.getDimension()) {
            throw new OutOfRangeException(n, (Number)0, this.getDimension() - 1);
        }
    }

    private void checkIndices(int n, int n2) throws NumberIsTooSmallException, OutOfRangeException {
        int n3 = this.getDimension();
        if (n < 0 || n >= n3) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n, 0, n3 - 1);
        }
        if (n2 < 0 || n2 >= n3) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.INDEX, (Number)n2, 0, n3 - 1);
        }
        if (n2 < n) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, (Number)n2, n, false);
        }
    }

    protected void checkVectorDimensions(int n) throws DimensionMismatchException {
        if (this.getDimension() != n) {
            throw new DimensionMismatchException(this.getDimension(), n);
        }
    }

    @Override
    public FieldVector<T> add(FieldVector<T> fieldVector) throws DimensionMismatchException {
        if (fieldVector instanceof SparseFieldVector) {
            return this.add((SparseFieldVector)fieldVector);
        }
        int n = fieldVector.getDimension();
        this.checkVectorDimensions(n);
        SparseFieldVector<FieldElement> sparseFieldVector = new SparseFieldVector<FieldElement>(this.field, this.getDimension());
        for (int i = 0; i < n; ++i) {
            sparseFieldVector.setEntry(i, (FieldElement)fieldVector.getEntry(i).add(this.getEntry(i)));
        }
        return sparseFieldVector;
    }

    public T walkInDefaultOrder(FieldVectorPreservingVisitor<T> fieldVectorPreservingVisitor) {
        int n = this.getDimension();
        fieldVectorPreservingVisitor.start(n, 0, n - 1);
        for (int i = 0; i < n; ++i) {
            fieldVectorPreservingVisitor.visit(i, this.getEntry(i));
        }
        return fieldVectorPreservingVisitor.end();
    }

    public T walkInDefaultOrder(FieldVectorPreservingVisitor<T> fieldVectorPreservingVisitor, int n, int n2) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkIndices(n, n2);
        fieldVectorPreservingVisitor.start(this.getDimension(), n, n2);
        for (int i = n; i <= n2; ++i) {
            fieldVectorPreservingVisitor.visit(i, this.getEntry(i));
        }
        return fieldVectorPreservingVisitor.end();
    }

    public T walkInOptimizedOrder(FieldVectorPreservingVisitor<T> fieldVectorPreservingVisitor) {
        return this.walkInDefaultOrder(fieldVectorPreservingVisitor);
    }

    public T walkInOptimizedOrder(FieldVectorPreservingVisitor<T> fieldVectorPreservingVisitor, int n, int n2) throws NumberIsTooSmallException, OutOfRangeException {
        return this.walkInDefaultOrder(fieldVectorPreservingVisitor, n, n2);
    }

    public T walkInDefaultOrder(FieldVectorChangingVisitor<T> fieldVectorChangingVisitor) {
        int n = this.getDimension();
        fieldVectorChangingVisitor.start(n, 0, n - 1);
        for (int i = 0; i < n; ++i) {
            this.setEntry(i, fieldVectorChangingVisitor.visit(i, this.getEntry(i)));
        }
        return fieldVectorChangingVisitor.end();
    }

    public T walkInDefaultOrder(FieldVectorChangingVisitor<T> fieldVectorChangingVisitor, int n, int n2) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkIndices(n, n2);
        fieldVectorChangingVisitor.start(this.getDimension(), n, n2);
        for (int i = n; i <= n2; ++i) {
            this.setEntry(i, fieldVectorChangingVisitor.visit(i, this.getEntry(i)));
        }
        return fieldVectorChangingVisitor.end();
    }

    public T walkInOptimizedOrder(FieldVectorChangingVisitor<T> fieldVectorChangingVisitor) {
        return this.walkInDefaultOrder(fieldVectorChangingVisitor);
    }

    public T walkInOptimizedOrder(FieldVectorChangingVisitor<T> fieldVectorChangingVisitor, int n, int n2) throws NumberIsTooSmallException, OutOfRangeException {
        return this.walkInDefaultOrder(fieldVectorChangingVisitor, n, n2);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.field == null ? 0 : this.field.hashCode());
        n = 31 * n + this.virtualSize;
        OpenIntToFieldHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int n2 = iterator.value().hashCode();
            n = 31 * n + n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        T t;
        if (this == object) {
            return true;
        }
        if (!(object instanceof SparseFieldVector)) {
            return false;
        }
        SparseFieldVector sparseFieldVector = (SparseFieldVector)object;
        if (this.field == null ? sparseFieldVector.field != null : !this.field.equals(sparseFieldVector.field)) {
            return false;
        }
        if (this.virtualSize != sparseFieldVector.virtualSize) {
            return false;
        }
        OpenIntToFieldHashMap.Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            t = sparseFieldVector.getEntry(iterator.key());
            if (t.equals(iterator.value())) continue;
            return false;
        }
        iterator = sparseFieldVector.getEntries().iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            t = iterator.value();
            if (t.equals(this.getEntry(iterator.key()))) continue;
            return false;
        }
        return true;
    }
}

