/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.complex.streams;

import org.apache.commons.numbers.complex.Complex;

public class ComplexUtils {
    private ComplexUtils() {
    }

    public static Complex polar2Complex(double d, double d2) {
        if (d < 0.0) {
            throw new NegativeModulusException(d);
        }
        return Complex.ofCartesian(d * Math.cos(d2), d * Math.sin(d2));
    }

    public static Complex[] polar2Complex(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        Complex[] complexArray = new Complex[n];
        for (int i = 0; i < n; ++i) {
            if (dArray[i] < 0.0) {
                throw new NegativeModulusException(dArray[i]);
            }
            complexArray[i] = Complex.ofCartesian(dArray[i] * Math.cos(dArray2[i]), dArray[i] * Math.sin(dArray2[i]));
        }
        return complexArray;
    }

    public static Complex[][] polar2Complex(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        Complex[][] complexArray = new Complex[n][];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.polar2Complex(dArray[i], dArray2[i]);
        }
        return complexArray;
    }

    public static Complex[][][] polar2Complex(double[][][] dArray, double[][][] dArray2) {
        int n = dArray.length;
        Complex[][][] complexArray = new Complex[n][][];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.polar2Complex(dArray[i], dArray2[i]);
        }
        return complexArray;
    }

    public static Complex extractComplexFromRealArray(double[] dArray, int n) {
        return Complex.ofReal(dArray[n]);
    }

    public static Complex extractComplexFromRealArray(float[] fArray, int n) {
        return Complex.ofReal(fArray[n]);
    }

    public static Complex extractComplexFromImaginaryArray(double[] dArray, int n) {
        return Complex.ofCartesian(0.0, dArray[n]);
    }

    public static Complex extractComplexFromImaginaryArray(float[] fArray, int n) {
        return Complex.ofCartesian(0.0, fArray[n]);
    }

    public static double extractRealFromComplexArray(Complex[] complexArray, int n) {
        return complexArray[n].getReal();
    }

    public static float extractRealFloatFromComplexArray(Complex[] complexArray, int n) {
        return (float)complexArray[n].getReal();
    }

    public static double extractImaginaryFromComplexArray(Complex[] complexArray, int n) {
        return complexArray[n].getImaginary();
    }

    public static float extractImaginaryFloatFromComplexArray(Complex[] complexArray, int n) {
        return (float)complexArray[n].getImaginary();
    }

    public static Complex extractComplexFromInterleavedArray(double[] dArray, int n) {
        return Complex.ofCartesian(dArray[n * 2], dArray[n * 2 + 1]);
    }

    public static Complex extractComplexFromInterleavedArray(float[] fArray, int n) {
        return Complex.ofCartesian(fArray[n * 2], fArray[n * 2 + 1]);
    }

    public static double[] extractInterleavedFromComplexArray(Complex[] complexArray, int n) {
        return new double[]{complexArray[n].getReal(), complexArray[n].getImaginary()};
    }

    public static float[] extractInterleavedFloatFromComplexArray(Complex[] complexArray, int n) {
        return new float[]{(float)complexArray[n].getReal(), (float)complexArray[n].getImaginary()};
    }

    public static Complex[] real2Complex(double[] dArray) {
        int n = 0;
        Complex[] complexArray = new Complex[dArray.length];
        for (double d : dArray) {
            complexArray[n] = Complex.ofReal(d);
            ++n;
        }
        return complexArray;
    }

    public static Complex[] real2Complex(float[] fArray) {
        int n = 0;
        Complex[] complexArray = new Complex[fArray.length];
        for (float f : fArray) {
            complexArray[n] = Complex.ofReal(f);
            ++n;
        }
        return complexArray;
    }

    public static Complex[][] real2Complex(double[][] dArray) {
        int n = dArray.length;
        Complex[][] complexArray = new Complex[n][];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.real2Complex(dArray[i]);
        }
        return complexArray;
    }

    public static Complex[][] real2Complex(float[][] fArray) {
        int n = fArray.length;
        Complex[][] complexArray = new Complex[n][];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.real2Complex(fArray[i]);
        }
        return complexArray;
    }

    public static Complex[][][] real2Complex(double[][][] dArray) {
        int n = dArray.length;
        Complex[][][] complexArray = new Complex[n][][];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.real2Complex(dArray[i]);
        }
        return complexArray;
    }

    public static Complex[][][] real2Complex(float[][][] fArray) {
        int n = fArray.length;
        Complex[][][] complexArray = new Complex[n][][];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.real2Complex(fArray[i]);
        }
        return complexArray;
    }

    public static Complex[][][][] real2Complex(double[][][][] dArray) {
        int n = dArray.length;
        Complex[][][][] complexArray = new Complex[n][][][];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.real2Complex(dArray[i]);
        }
        return complexArray;
    }

    public static double[] complex2Real(Complex[] complexArray) {
        int n = 0;
        double[] dArray = new double[complexArray.length];
        for (Complex complex : complexArray) {
            dArray[n] = complex.getReal();
            ++n;
        }
        return dArray;
    }

    public static float[] complex2RealFloat(Complex[] complexArray) {
        int n = 0;
        float[] fArray = new float[complexArray.length];
        for (Complex complex : complexArray) {
            fArray[n] = (float)complex.getReal();
            ++n;
        }
        return fArray;
    }

    public static double[][] complex2Real(Complex[][] complexArray) {
        int n = complexArray.length;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = ComplexUtils.complex2Real(complexArray[i]);
        }
        return dArrayArray;
    }

    public static float[][] complex2RealFloat(Complex[][] complexArray) {
        int n = complexArray.length;
        float[][] fArrayArray = new float[n][];
        for (int i = 0; i < n; ++i) {
            fArrayArray[i] = ComplexUtils.complex2RealFloat(complexArray[i]);
        }
        return fArrayArray;
    }

    public static double[][][] complex2Real(Complex[][][] complexArray) {
        int n = complexArray.length;
        double[][][] dArrayArray = new double[n][][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = ComplexUtils.complex2Real(complexArray[i]);
        }
        return dArrayArray;
    }

    public static float[][][] complex2RealFloat(Complex[][][] complexArray) {
        int n = complexArray.length;
        float[][][] fArrayArray = new float[n][][];
        for (int i = 0; i < n; ++i) {
            fArrayArray[i] = ComplexUtils.complex2RealFloat(complexArray[i]);
        }
        return fArrayArray;
    }

    public static double[][][][] complex2Real(Complex[][][][] complexArray) {
        int n = complexArray.length;
        double[][][][] dArrayArray = new double[n][][][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = ComplexUtils.complex2Real(complexArray[i]);
        }
        return dArrayArray;
    }

    public static float[][][][] complex2RealFloat(Complex[][][][] complexArray) {
        int n = complexArray.length;
        float[][][][] fArrayArray = new float[n][][][];
        for (int i = 0; i < n; ++i) {
            fArrayArray[i] = ComplexUtils.complex2RealFloat(complexArray[i]);
        }
        return fArrayArray;
    }

    public static Complex[] imaginary2Complex(double[] dArray) {
        int n = 0;
        Complex[] complexArray = new Complex[dArray.length];
        for (double d : dArray) {
            complexArray[n] = Complex.ofCartesian(0.0, d);
            ++n;
        }
        return complexArray;
    }

    public static Complex[] imaginary2Complex(float[] fArray) {
        int n = 0;
        Complex[] complexArray = new Complex[fArray.length];
        for (float f : fArray) {
            complexArray[n] = Complex.ofCartesian(0.0, f);
            ++n;
        }
        return complexArray;
    }

    public static Complex[][] imaginary2Complex(double[][] dArray) {
        int n = dArray.length;
        Complex[][] complexArray = new Complex[n][];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.imaginary2Complex(dArray[i]);
        }
        return complexArray;
    }

    public static Complex[][][] imaginary2Complex(double[][][] dArray) {
        int n = dArray.length;
        Complex[][][] complexArray = new Complex[n][][];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.imaginary2Complex(dArray[i]);
        }
        return complexArray;
    }

    public static Complex[][][][] imaginary2Complex(double[][][][] dArray) {
        int n = dArray.length;
        Complex[][][][] complexArray = new Complex[n][][][];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.imaginary2Complex(dArray[i]);
        }
        return complexArray;
    }

    public static double[] complex2Imaginary(Complex[] complexArray) {
        int n = 0;
        double[] dArray = new double[complexArray.length];
        for (Complex complex : complexArray) {
            dArray[n] = complex.getImaginary();
            ++n;
        }
        return dArray;
    }

    public static float[] complex2ImaginaryFloat(Complex[] complexArray) {
        int n = 0;
        float[] fArray = new float[complexArray.length];
        for (Complex complex : complexArray) {
            fArray[n] = (float)complex.getImaginary();
            ++n;
        }
        return fArray;
    }

    public static double[][] complex2Imaginary(Complex[][] complexArray) {
        int n = complexArray.length;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = ComplexUtils.complex2Imaginary(complexArray[i]);
        }
        return dArrayArray;
    }

    public static float[][] complex2ImaginaryFloat(Complex[][] complexArray) {
        int n = complexArray.length;
        float[][] fArrayArray = new float[n][];
        for (int i = 0; i < n; ++i) {
            fArrayArray[i] = ComplexUtils.complex2ImaginaryFloat(complexArray[i]);
        }
        return fArrayArray;
    }

    public static double[][][] complex2Imaginary(Complex[][][] complexArray) {
        int n = complexArray.length;
        double[][][] dArrayArray = new double[n][][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = ComplexUtils.complex2Imaginary(complexArray[i]);
        }
        return dArrayArray;
    }

    public static float[][][] complex2ImaginaryFloat(Complex[][][] complexArray) {
        int n = complexArray.length;
        float[][][] fArrayArray = new float[n][][];
        for (int i = 0; i < n; ++i) {
            fArrayArray[i] = ComplexUtils.complex2ImaginaryFloat(complexArray[i]);
        }
        return fArrayArray;
    }

    public static double[][][][] complex2Imaginary(Complex[][][][] complexArray) {
        int n = complexArray.length;
        double[][][][] dArrayArray = new double[n][][][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = ComplexUtils.complex2Imaginary(complexArray[i]);
        }
        return dArrayArray;
    }

    public static float[][][][] complex2ImaginaryFloat(Complex[][][][] complexArray) {
        int n = complexArray.length;
        float[][][][] fArrayArray = new float[n][][][];
        for (int i = 0; i < n; ++i) {
            fArrayArray[i] = ComplexUtils.complex2ImaginaryFloat(complexArray[i]);
        }
        return fArrayArray;
    }

    public static Complex[] interleaved2Complex(double[] dArray) {
        int n = dArray.length / 2;
        Complex[] complexArray = new Complex[n];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = Complex.ofCartesian(dArray[i * 2], dArray[i * 2 + 1]);
        }
        return complexArray;
    }

    public static Complex[] interleaved2Complex(float[] fArray) {
        int n = fArray.length / 2;
        Complex[] complexArray = new Complex[n];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = Complex.ofCartesian(fArray[i * 2], fArray[i * 2 + 1]);
        }
        return complexArray;
    }

    public static double[] complex2Interleaved(Complex[] complexArray) {
        int n = 0;
        double[] dArray = new double[complexArray.length * 2];
        for (Complex complex : complexArray) {
            int n2 = n * 2;
            int n3 = n * 2 + 1;
            dArray[n2] = complex.getReal();
            dArray[n3] = complex.getImaginary();
            ++n;
        }
        return dArray;
    }

    public static float[] complex2InterleavedFloat(Complex[] complexArray) {
        int n = 0;
        float[] fArray = new float[complexArray.length * 2];
        for (Complex complex : complexArray) {
            int n2 = n * 2;
            int n3 = n * 2 + 1;
            fArray[n2] = (float)complex.getReal();
            fArray[n3] = (float)complex.getImaginary();
            ++n;
        }
        return fArray;
    }

    public static double[][] complex2Interleaved(Complex[][] complexArray, int n) {
        double[][] dArray;
        if (n > 1 || n < 0) {
            throw new IndexOutOfRangeException(n);
        }
        int n2 = complexArray.length;
        int n3 = complexArray[0].length;
        if (n == 0) {
            dArray = new double[2 * n2][n3];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    dArray[i * 2][j] = complexArray[i][j].getReal();
                    dArray[i * 2 + 1][j] = complexArray[i][j].getImaginary();
                }
            }
        } else {
            dArray = new double[n2][2 * n3];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    dArray[i][j * 2] = complexArray[i][j].getReal();
                    dArray[i][j * 2 + 1] = complexArray[i][j].getImaginary();
                }
            }
        }
        return dArray;
    }

    public static double[][] complex2Interleaved(Complex[][] complexArray) {
        return ComplexUtils.complex2Interleaved(complexArray, 1);
    }

    public static double[][][] complex2Interleaved(Complex[][][] complexArray, int n) {
        double[][][] dArray;
        if (n > 2 || n < 0) {
            throw new IndexOutOfRangeException(n);
        }
        int n2 = complexArray.length;
        int n3 = complexArray[0].length;
        int n4 = complexArray[0][0].length;
        if (n == 0) {
            dArray = new double[2 * n2][n3][n4];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        dArray[i * 2][j][k] = complexArray[i][j][k].getReal();
                        dArray[i * 2 + 1][j][k] = complexArray[i][j][k].getImaginary();
                    }
                }
            }
        } else if (n == 1) {
            dArray = new double[n2][2 * n3][n4];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        dArray[i][j * 2][k] = complexArray[i][j][k].getReal();
                        dArray[i][j * 2 + 1][k] = complexArray[i][j][k].getImaginary();
                    }
                }
            }
        } else {
            dArray = new double[n2][n3][2 * n4];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        dArray[i][j][k * 2] = complexArray[i][j][k].getReal();
                        dArray[i][j][k * 2 + 1] = complexArray[i][j][k].getImaginary();
                    }
                }
            }
        }
        return dArray;
    }

    public static double[][][][] complex2Interleaved(Complex[][][][] complexArray, int n) {
        double[][][][] dArray;
        if (n > 3 || n < 0) {
            throw new IndexOutOfRangeException(n);
        }
        int n2 = complexArray.length;
        int n3 = complexArray[0].length;
        int n4 = complexArray[0][0].length;
        int n5 = complexArray[0][0][0].length;
        if (n == 0) {
            dArray = new double[2 * n2][n3][n4][n5];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        for (int i2 = 0; i2 < n5; ++i2) {
                            dArray[i * 2][j][k][i2] = complexArray[i][j][k][i2].getReal();
                            dArray[i * 2 + 1][j][k][i2] = complexArray[i][j][k][i2].getImaginary();
                        }
                    }
                }
            }
        } else if (n == 1) {
            dArray = new double[n2][2 * n3][n4][n5];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        for (int i3 = 0; i3 < n5; ++i3) {
                            dArray[i][j * 2][k][i3] = complexArray[i][j][k][i3].getReal();
                            dArray[i][j * 2 + 1][k][i3] = complexArray[i][j][k][i3].getImaginary();
                        }
                    }
                }
            }
        } else if (n == 2) {
            dArray = new double[n2][n3][2 * n4][n5];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        for (int i4 = 0; i4 < n5; ++i4) {
                            dArray[i][j][k * 2][i4] = complexArray[i][j][k][i4].getReal();
                            dArray[i][j][k * 2 + 1][i4] = complexArray[i][j][k][i4].getImaginary();
                        }
                    }
                }
            }
        } else {
            dArray = new double[n2][n3][n4][2 * n5];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        for (int i5 = 0; i5 < n5; ++i5) {
                            dArray[i][j][k][i5 * 2] = complexArray[i][j][k][i5].getReal();
                            dArray[i][j][k][i5 * 2 + 1] = complexArray[i][j][k][i5].getImaginary();
                        }
                    }
                }
            }
        }
        return dArray;
    }

    public static double[][][] complex2Interleaved(Complex[][][] complexArray) {
        return ComplexUtils.complex2Interleaved(complexArray, 2);
    }

    public static double[][][][] complex2Interleaved(Complex[][][][] complexArray) {
        return ComplexUtils.complex2Interleaved(complexArray, 3);
    }

    public static float[][] complex2InterleavedFloat(Complex[][] complexArray, int n) {
        float[][] fArray;
        if (n > 1 || n < 0) {
            throw new IndexOutOfRangeException(n);
        }
        int n2 = complexArray.length;
        int n3 = complexArray[0].length;
        if (n == 0) {
            fArray = new float[2 * n2][n3];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    fArray[i * 2][j] = (float)complexArray[i][j].getReal();
                    fArray[i * 2 + 1][j] = (float)complexArray[i][j].getImaginary();
                }
            }
        } else {
            fArray = new float[n2][2 * n3];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    fArray[i][j * 2] = (float)complexArray[i][j].getReal();
                    fArray[i][j * 2 + 1] = (float)complexArray[i][j].getImaginary();
                }
            }
        }
        return fArray;
    }

    public static float[][] complex2InterleavedFloat(Complex[][] complexArray) {
        return ComplexUtils.complex2InterleavedFloat(complexArray, 1);
    }

    public static float[][][] complex2InterleavedFloat(Complex[][][] complexArray, int n) {
        float[][][] fArray;
        if (n > 2 || n < 0) {
            throw new IndexOutOfRangeException(n);
        }
        int n2 = complexArray.length;
        int n3 = complexArray[0].length;
        int n4 = complexArray[0][0].length;
        if (n == 0) {
            fArray = new float[2 * n2][n3][n4];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        fArray[i * 2][j][k] = (float)complexArray[i][j][k].getReal();
                        fArray[i * 2 + 1][j][k] = (float)complexArray[i][j][k].getImaginary();
                    }
                }
            }
        } else if (n == 1) {
            fArray = new float[n2][2 * n3][n4];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        fArray[i][j * 2][k] = (float)complexArray[i][j][k].getReal();
                        fArray[i][j * 2 + 1][k] = (float)complexArray[i][j][k].getImaginary();
                    }
                }
            }
        } else {
            fArray = new float[n2][n3][2 * n4];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        fArray[i][j][k * 2] = (float)complexArray[i][j][k].getReal();
                        fArray[i][j][k * 2 + 1] = (float)complexArray[i][j][k].getImaginary();
                    }
                }
            }
        }
        return fArray;
    }

    public static float[][][] complex2InterleavedFloat(Complex[][][] complexArray) {
        return ComplexUtils.complex2InterleavedFloat(complexArray, 2);
    }

    public static Complex[][] interleaved2Complex(double[][] dArray, int n) {
        Complex[][] complexArray;
        if (n > 1 || n < 0) {
            throw new IndexOutOfRangeException(n);
        }
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        if (n == 0) {
            complexArray = new Complex[n2 / 2][n3];
            for (int i = 0; i < n2 / 2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    complexArray[i][j] = Complex.ofCartesian(dArray[i * 2][j], dArray[i * 2 + 1][j]);
                }
            }
        } else {
            complexArray = new Complex[n2][n3 / 2];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3 / 2; ++j) {
                    complexArray[i][j] = Complex.ofCartesian(dArray[i][j * 2], dArray[i][j * 2 + 1]);
                }
            }
        }
        return complexArray;
    }

    public static Complex[][] interleaved2Complex(double[][] dArray) {
        return ComplexUtils.interleaved2Complex(dArray, 1);
    }

    public static Complex[][][] interleaved2Complex(double[][][] dArray, int n) {
        Complex[][][] complexArray;
        if (n > 2 || n < 0) {
            throw new IndexOutOfRangeException(n);
        }
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        int n4 = dArray[0][0].length;
        if (n == 0) {
            complexArray = new Complex[n2 / 2][n3][n4];
            for (int i = 0; i < n2 / 2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        complexArray[i][j][k] = Complex.ofCartesian(dArray[i * 2][j][k], dArray[i * 2 + 1][j][k]);
                    }
                }
            }
        } else if (n == 1) {
            complexArray = new Complex[n2][n3 / 2][n4];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3 / 2; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        complexArray[i][j][k] = Complex.ofCartesian(dArray[i][j * 2][k], dArray[i][j * 2 + 1][k]);
                    }
                }
            }
        } else {
            complexArray = new Complex[n2][n3][n4 / 2];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4 / 2; ++k) {
                        complexArray[i][j][k] = Complex.ofCartesian(dArray[i][j][k * 2], dArray[i][j][k * 2 + 1]);
                    }
                }
            }
        }
        return complexArray;
    }

    public static Complex[][][][] interleaved2Complex(double[][][][] dArray, int n) {
        Complex[][][][] complexArray;
        if (n > 3 || n < 0) {
            throw new IndexOutOfRangeException(n);
        }
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        int n4 = dArray[0][0].length;
        int n5 = dArray[0][0][0].length;
        if (n == 0) {
            complexArray = new Complex[n2 / 2][n3][n4][n5];
            for (int i = 0; i < n2 / 2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        for (int i2 = 0; i2 < n5; ++i2) {
                            complexArray[i][j][k][i2] = Complex.ofCartesian(dArray[i * 2][j][k][i2], dArray[i * 2 + 1][j][k][i2]);
                        }
                    }
                }
            }
        } else if (n == 1) {
            complexArray = new Complex[n2][n3 / 2][n4][n5];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3 / 2; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        for (int i3 = 0; i3 < n5; ++i3) {
                            complexArray[i][j][k][i3] = Complex.ofCartesian(dArray[i][j * 2][k][i3], dArray[i][j * 2 + 1][k][i3]);
                        }
                    }
                }
            }
        } else if (n == 2) {
            complexArray = new Complex[n2][n3][n4 / 2][n5];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4 / 2; ++k) {
                        for (int i4 = 0; i4 < n5; ++i4) {
                            complexArray[i][j][k][i4] = Complex.ofCartesian(dArray[i][j][k * 2][i4], dArray[i][j][k * 2 + 1][i4]);
                        }
                    }
                }
            }
        } else {
            complexArray = new Complex[n2][n3][n4][n5 / 2];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        for (int i5 = 0; i5 < n5 / 2; ++i5) {
                            complexArray[i][j][k][i5] = Complex.ofCartesian(dArray[i][j][k][i5 * 2], dArray[i][j][k][i5 * 2 + 1]);
                        }
                    }
                }
            }
        }
        return complexArray;
    }

    public static Complex[][][] interleaved2Complex(double[][][] dArray) {
        return ComplexUtils.interleaved2Complex(dArray, 2);
    }

    public static Complex[][] interleaved2Complex(float[][] fArray, int n) {
        Complex[][] complexArray;
        if (n > 1 || n < 0) {
            throw new IndexOutOfRangeException(n);
        }
        int n2 = fArray.length;
        int n3 = fArray[0].length;
        if (n == 0) {
            complexArray = new Complex[n2 / 2][n3];
            for (int i = 0; i < n2 / 2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    complexArray[i][j] = Complex.ofCartesian(fArray[i * 2][j], fArray[i * 2 + 1][j]);
                }
            }
        } else {
            complexArray = new Complex[n2][n3 / 2];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3 / 2; ++j) {
                    complexArray[i][j] = Complex.ofCartesian(fArray[i][j * 2], fArray[i][j * 2 + 1]);
                }
            }
        }
        return complexArray;
    }

    public static Complex[][] interleaved2Complex(float[][] fArray) {
        return ComplexUtils.interleaved2Complex(fArray, 1);
    }

    public static Complex[][][] interleaved2Complex(float[][][] fArray, int n) {
        Complex[][][] complexArray;
        if (n > 2 || n < 0) {
            throw new IndexOutOfRangeException(n);
        }
        int n2 = fArray.length;
        int n3 = fArray[0].length;
        int n4 = fArray[0][0].length;
        if (n == 0) {
            complexArray = new Complex[n2 / 2][n3][n4];
            for (int i = 0; i < n2 / 2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        complexArray[i][j][k] = Complex.ofCartesian(fArray[i * 2][j][k], fArray[i * 2 + 1][j][k]);
                    }
                }
            }
        } else if (n == 1) {
            complexArray = new Complex[n2][n3 / 2][n4];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3 / 2; ++j) {
                    for (int k = 0; k < n4; ++k) {
                        complexArray[i][j][k] = Complex.ofCartesian(fArray[i][j * 2][k], fArray[i][j * 2 + 1][k]);
                    }
                }
            }
        } else {
            complexArray = new Complex[n2][n3][n4 / 2];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n4 / 2; ++k) {
                        complexArray[i][j][k] = Complex.ofCartesian(fArray[i][j][k * 2], fArray[i][j][k * 2 + 1]);
                    }
                }
            }
        }
        return complexArray;
    }

    public static Complex[][][] interleaved2Complex(float[][][] fArray) {
        return ComplexUtils.interleaved2Complex(fArray, 2);
    }

    public static Complex[] split2Complex(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        Complex[] complexArray = new Complex[n];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = Complex.ofCartesian(dArray[i], dArray2[i]);
        }
        return complexArray;
    }

    public static Complex[][] split2Complex(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        Complex[][] complexArray = new Complex[n][];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.split2Complex(dArray[i], dArray2[i]);
        }
        return complexArray;
    }

    public static Complex[][][] split2Complex(double[][][] dArray, double[][][] dArray2) {
        int n = dArray.length;
        Complex[][][] complexArray = new Complex[n][][];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.split2Complex(dArray[i], dArray2[i]);
        }
        return complexArray;
    }

    public static Complex[][][][] split2Complex(double[][][][] dArray, double[][][][] dArray2) {
        int n = dArray.length;
        Complex[][][][] complexArray = new Complex[n][][][];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.split2Complex(dArray[i], dArray2[i]);
        }
        return complexArray;
    }

    public static Complex[] split2Complex(float[] fArray, float[] fArray2) {
        int n = fArray.length;
        Complex[] complexArray = new Complex[n];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = Complex.ofCartesian(fArray[i], fArray2[i]);
        }
        return complexArray;
    }

    public static Complex[][] split2Complex(float[][] fArray, float[][] fArray2) {
        int n = fArray.length;
        Complex[][] complexArray = new Complex[n][];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.split2Complex(fArray[i], fArray2[i]);
        }
        return complexArray;
    }

    public static Complex[][][] split2Complex(float[][][] fArray, float[][][] fArray2) {
        int n = fArray.length;
        Complex[][][] complexArray = new Complex[n][][];
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.split2Complex(fArray[i], fArray2[i]);
        }
        return complexArray;
    }

    public static Complex[] initialize(Complex[] complexArray) {
        int n = complexArray.length;
        for (int i = 0; i < n; ++i) {
            complexArray[i] = Complex.ZERO;
        }
        return complexArray;
    }

    public static Complex[][] initialize(Complex[][] complexArray) {
        int n = complexArray.length;
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.initialize(complexArray[i]);
        }
        return complexArray;
    }

    public static Complex[][][] initialize(Complex[][][] complexArray) {
        int n = complexArray.length;
        for (int i = 0; i < n; ++i) {
            complexArray[i] = ComplexUtils.initialize(complexArray[i]);
        }
        return complexArray;
    }

    public static double[] abs(Complex[] complexArray) {
        int n = complexArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = complexArray[i].abs();
        }
        return dArray;
    }

    public static double[] arg(Complex[] complexArray) {
        int n = complexArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = complexArray[i].getArgument();
        }
        return dArray;
    }

    private static class IndexOutOfRangeException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 20181205L;

        IndexOutOfRangeException(int n) {
            super("Out of range: " + n);
        }
    }

    private static class NegativeModulusException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 20181205L;

        NegativeModulusException(double d) {
            super("Modulus is negative: " + d);
        }
    }
}

