/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source32;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import org.apache.commons.rng.core.source32.IntProvider;

public class JDKRandom
extends IntProvider {
    private Random delegate;
    private int stateSize;

    public JDKRandom(Long l) {
        this.delegate = new Random(l);
    }

    @Override
    public int next() {
        return this.delegate.nextInt();
    }

    @Override
    protected byte[] getStateInternal() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this.delegate);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.stateSize = byArray.length;
            return this.composeStateInternal(byArray, super.getStateInternal());
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    protected void setStateInternal(byte[] byArray) {
        byte[][] byArray2 = this.splitStateInternal(byArray, this.stateSize);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2[0]);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            this.delegate = (Random)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        super.setStateInternal(byArray2[1]);
    }
}

