/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.api.composers;

import io.virtdata.api.FunctionType;
import io.virtdata.api.ValueType;
import io.virtdata.api.composers.ComposerForDoubleToIntFunction;
import io.virtdata.api.composers.ComposerForDoubleToLongFunction;
import io.virtdata.api.composers.ComposerForDoubleUnaryOperator;
import io.virtdata.api.composers.FunctionComposer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;

public class ComposerForDoubleFunction
implements FunctionComposer<DoubleFunction<?>> {
    private final DoubleFunction<?> inner;

    public ComposerForDoubleFunction(DoubleFunction<?> doubleFunction) {
        this.inner = doubleFunction;
    }

    @Override
    public Object getFunctionObject() {
        return this.inner;
    }

    @Override
    public FunctionComposer andThen(Object object) {
        FunctionType functionType = FunctionType.valueOf(object);
        Object obj = this.inner.apply(1.0);
        ValueType valueType = ValueType.valueOfAssignableClass(obj.getClass());
        switch (functionType) {
            case long_long: {
                switch (valueType) {
                    case LONG: {
                        DoubleToLongFunction doubleToLongFunction = d -> ((LongUnaryOperator)object).applyAsLong(((DoubleToLongFunction)((Object)this.inner)).applyAsLong(d));
                        return new ComposerForDoubleToLongFunction(doubleToLongFunction);
                    }
                    case DOUBLE: {
                        DoubleToLongFunction doubleToLongFunction = d -> ((LongUnaryOperator)object).applyAsLong((long)((DoubleUnaryOperator)((Object)this.inner)).applyAsDouble(d));
                        return new ComposerForDoubleToLongFunction(doubleToLongFunction);
                    }
                    case INT: {
                        DoubleToLongFunction doubleToLongFunction = d -> ((LongUnaryOperator)object).applyAsLong(((DoubleToIntFunction)((Object)this.inner)).applyAsInt(d));
                        return new ComposerForDoubleToLongFunction(doubleToLongFunction);
                    }
                }
                DoubleToLongFunction doubleToLongFunction = d -> ((LongUnaryOperator)object).applyAsLong(Long.valueOf(this.inner.apply(d).toString()));
                return new ComposerForDoubleToLongFunction(doubleToLongFunction);
            }
            case long_T: {
                DoubleFunction<Object> doubleFunction = d -> ((LongFunction)object).apply((Long)this.inner.apply(d));
                return new ComposerForDoubleFunction(doubleFunction);
            }
            case long_int: {
                DoubleToIntFunction doubleToIntFunction = d -> ((LongToIntFunction)object).applyAsInt((Long)this.inner.apply(d));
                return new ComposerForDoubleToIntFunction(doubleToIntFunction);
            }
            case long_double: {
                DoubleUnaryOperator doubleUnaryOperator = d -> ((LongToDoubleFunction)object).applyAsDouble((Long)this.inner.apply(d));
                return new ComposerForDoubleUnaryOperator(doubleUnaryOperator);
            }
            case int_int: {
                switch (valueType) {
                    case LONG: {
                        DoubleToIntFunction doubleToIntFunction = d -> ((IntUnaryOperator)object).applyAsInt(((Long)this.inner.apply(d)).intValue());
                        return new ComposerForDoubleToIntFunction(doubleToIntFunction);
                    }
                    case DOUBLE: {
                        DoubleToIntFunction doubleToIntFunction = d -> ((IntUnaryOperator)object).applyAsInt(((Double)this.inner.apply(d)).intValue());
                        return new ComposerForDoubleToIntFunction(doubleToIntFunction);
                    }
                    case INT: {
                        DoubleToIntFunction doubleToIntFunction = d -> ((IntUnaryOperator)object).applyAsInt((Integer)this.inner.apply(d));
                        return new ComposerForDoubleToIntFunction(doubleToIntFunction);
                    }
                }
                DoubleToIntFunction doubleToIntFunction = d -> ((IntUnaryOperator)object).applyAsInt(Integer.valueOf(this.inner.apply(d).toString()));
                return new ComposerForDoubleToIntFunction(doubleToIntFunction);
            }
            case int_long: {
                switch (valueType) {
                    case LONG: {
                        DoubleToLongFunction doubleToLongFunction = d -> ((IntToLongFunction)object).applyAsLong(((Long)this.inner.apply(d)).intValue());
                        return new ComposerForDoubleToLongFunction(doubleToLongFunction);
                    }
                    case DOUBLE: {
                        DoubleToLongFunction doubleToLongFunction = d -> ((IntToLongFunction)object).applyAsLong(((Double)this.inner.apply(d)).intValue());
                        return new ComposerForDoubleToLongFunction(doubleToLongFunction);
                    }
                    case INT: {
                        DoubleToLongFunction doubleToLongFunction = d -> ((IntToLongFunction)object).applyAsLong((Integer)this.inner.apply(d));
                        return new ComposerForDoubleToLongFunction(doubleToLongFunction);
                    }
                }
                DoubleToLongFunction doubleToLongFunction = d -> ((IntToLongFunction)object).applyAsLong(Integer.valueOf(this.inner.apply(d).toString()));
                return new ComposerForDoubleToLongFunction(doubleToLongFunction);
            }
            case int_double: {
                switch (valueType) {
                    case LONG: {
                        DoubleUnaryOperator doubleUnaryOperator = d -> ((IntToDoubleFunction)object).applyAsDouble(((Long)this.inner.apply(d)).intValue());
                        return new ComposerForDoubleUnaryOperator(doubleUnaryOperator);
                    }
                    case DOUBLE: {
                        DoubleUnaryOperator doubleUnaryOperator = d -> ((IntToDoubleFunction)object).applyAsDouble(((Double)this.inner.apply(d)).intValue());
                        return new ComposerForDoubleUnaryOperator(doubleUnaryOperator);
                    }
                    case INT: {
                        DoubleUnaryOperator doubleUnaryOperator = d -> ((IntToDoubleFunction)object).applyAsDouble((Integer)this.inner.apply(d));
                        return new ComposerForDoubleUnaryOperator(doubleUnaryOperator);
                    }
                }
                DoubleUnaryOperator doubleUnaryOperator = d -> ((IntToDoubleFunction)object).applyAsDouble(Integer.valueOf(this.inner.apply(d).toString()));
                return new ComposerForDoubleUnaryOperator(doubleUnaryOperator);
            }
            case int_T: {
                switch (valueType) {
                    case LONG: {
                        DoubleFunction<Object> doubleFunction = d -> ((IntFunction)object).apply(((Long)this.inner.apply(d)).intValue());
                        return new ComposerForDoubleFunction(doubleFunction);
                    }
                    case DOUBLE: {
                        DoubleFunction<Object> doubleFunction = d -> ((IntFunction)object).apply(((Double)this.inner.apply(d)).intValue());
                        return new ComposerForDoubleFunction(doubleFunction);
                    }
                    case INT: {
                        DoubleFunction<Object> doubleFunction = d -> ((IntFunction)object).apply((Integer)this.inner.apply(d));
                        return new ComposerForDoubleFunction(doubleFunction);
                    }
                }
                DoubleFunction<Object> doubleFunction = d -> ((IntFunction)object).apply(Integer.valueOf(this.inner.apply(d).toString()));
                return new ComposerForDoubleFunction(doubleFunction);
            }
            case double_double: {
                switch (valueType) {
                    case LONG: {
                        DoubleUnaryOperator doubleUnaryOperator = d -> ((DoubleUnaryOperator)object).applyAsDouble(((Long)this.inner.apply(d)).longValue());
                        return new ComposerForDoubleUnaryOperator(doubleUnaryOperator);
                    }
                    case DOUBLE: {
                        DoubleUnaryOperator doubleUnaryOperator = d -> ((DoubleUnaryOperator)object).applyAsDouble((Double)this.inner.apply(d));
                        return new ComposerForDoubleUnaryOperator(doubleUnaryOperator);
                    }
                    case INT: {
                        DoubleUnaryOperator doubleUnaryOperator = d -> ((DoubleUnaryOperator)object).applyAsDouble(((Integer)this.inner.apply(d)).intValue());
                        return new ComposerForDoubleUnaryOperator(doubleUnaryOperator);
                    }
                }
                DoubleUnaryOperator doubleUnaryOperator = d -> ((DoubleUnaryOperator)object).applyAsDouble(Double.valueOf(this.inner.apply(d).toString()));
                return new ComposerForDoubleUnaryOperator(doubleUnaryOperator);
            }
            case double_long: {
                DoubleToLongFunction doubleToLongFunction = d -> ((DoubleToLongFunction)object).applyAsLong(((Long)this.inner.apply(d)).longValue());
                return new ComposerForDoubleToLongFunction(doubleToLongFunction);
            }
            case double_int: {
                switch (valueType) {
                    case LONG: {
                        DoubleToIntFunction doubleToIntFunction = d -> ((DoubleToIntFunction)object).applyAsInt(((Long)this.inner.apply(d)).longValue());
                        return new ComposerForDoubleToIntFunction(doubleToIntFunction);
                    }
                    case DOUBLE: {
                        DoubleToIntFunction doubleToIntFunction = d -> ((DoubleToIntFunction)object).applyAsInt((Double)this.inner.apply(d));
                        return new ComposerForDoubleToIntFunction(doubleToIntFunction);
                    }
                    case INT: {
                        DoubleToIntFunction doubleToIntFunction = d -> ((DoubleToIntFunction)object).applyAsInt(((Integer)this.inner.apply(d)).intValue());
                        return new ComposerForDoubleToIntFunction(doubleToIntFunction);
                    }
                }
                DoubleToIntFunction doubleToIntFunction = d -> ((DoubleToIntFunction)object).applyAsInt(Double.valueOf(this.inner.apply(d).toString()));
                return new ComposerForDoubleToIntFunction(doubleToIntFunction);
            }
            case double_T: {
                switch (valueType) {
                    case LONG: {
                        DoubleFunction<Object> doubleFunction = d -> ((DoubleFunction)object).apply(((Long)this.inner.apply(d)).longValue());
                        return new ComposerForDoubleFunction(doubleFunction);
                    }
                    case DOUBLE: {
                        DoubleFunction<Object> doubleFunction = d -> ((DoubleFunction)object).apply((Double)this.inner.apply(d));
                        return new ComposerForDoubleFunction(doubleFunction);
                    }
                    case INT: {
                        DoubleFunction<Object> doubleFunction = d -> ((DoubleFunction)object).apply(((Integer)this.inner.apply(d)).intValue());
                        return new ComposerForDoubleFunction(doubleFunction);
                    }
                }
                DoubleFunction<Object> doubleFunction = d -> ((DoubleFunction)object).apply(Double.valueOf(this.inner.apply(d).toString()));
                return new ComposerForDoubleFunction(doubleFunction);
            }
            case R_T: {
                switch (valueType) {
                    case LONG: {
                        DoubleFunction<Object> doubleFunction = d -> ((Function)object).apply(((DoubleToLongFunction)((Object)this.inner)).applyAsLong(d));
                        return new ComposerForDoubleFunction(doubleFunction);
                    }
                    case DOUBLE: {
                        DoubleFunction<Object> doubleFunction = d -> ((Function)object).apply(((DoubleUnaryOperator)((Object)this.inner)).applyAsDouble(d));
                        return new ComposerForDoubleFunction(doubleFunction);
                    }
                    case INT: {
                        DoubleFunction<Object> doubleFunction = d -> ((Function)object).apply(((DoubleToIntFunction)((Object)this.inner)).applyAsInt(d));
                        return new ComposerForDoubleFunction(doubleFunction);
                    }
                }
                DoubleFunction<Object> doubleFunction = d -> ((Function)object).apply(this.inner.apply(d));
                return new ComposerForDoubleFunction(doubleFunction);
            }
        }
        throw new RuntimeException(functionType + " is not recognized");
    }
}

