/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive.rank;

import io.virtdata.shaded.oac.statistics.descriptive.AbstractUnivariateStatistic;
import io.virtdata.shaded.oac.statistics.ranking.NaNStrategy;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.KthSelector;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;
import org.apache.commons.math4.util.MedianOf3PivotingStrategy;
import org.apache.commons.math4.util.PivotingStrategyInterface;
import org.apache.commons.numbers.core.Precision;

public class Percentile
extends AbstractUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    private static final int MAX_CACHED_LEVELS = 10;
    private static final int PIVOTS_HEAP_LENGTH = 512;
    private final KthSelector kthSelector;
    private final EstimationType estimationType;
    private final NaNStrategy nanStrategy;
    private double quantile;
    private int[] cachedPivots;

    public Percentile() {
        this(50.0);
    }

    public Percentile(double d) throws MathIllegalArgumentException {
        this(d, EstimationType.LEGACY, NaNStrategy.REMOVED, new KthSelector(new MedianOf3PivotingStrategy()));
    }

    public Percentile(Percentile percentile) throws NullArgumentException {
        MathUtils.checkNotNull(percentile);
        this.estimationType = percentile.getEstimationType();
        this.nanStrategy = percentile.getNaNStrategy();
        this.kthSelector = percentile.getKthSelector();
        this.setData(percentile.getDataRef());
        if (percentile.cachedPivots != null) {
            System.arraycopy(percentile.cachedPivots, 0, this.cachedPivots, 0, percentile.cachedPivots.length);
        }
        this.setQuantile(percentile.quantile);
    }

    protected Percentile(double d, EstimationType estimationType, NaNStrategy naNStrategy, KthSelector kthSelector) throws MathIllegalArgumentException {
        this.setQuantile(d);
        this.cachedPivots = null;
        MathUtils.checkNotNull((Object)estimationType);
        MathUtils.checkNotNull((Object)naNStrategy);
        MathUtils.checkNotNull(kthSelector);
        this.estimationType = estimationType;
        this.nanStrategy = naNStrategy;
        this.kthSelector = kthSelector;
    }

    @Override
    public void setData(double[] dArray) {
        if (dArray == null) {
            this.cachedPivots = null;
        } else {
            this.cachedPivots = new int[512];
            Arrays.fill(this.cachedPivots, -1);
        }
        super.setData(dArray);
    }

    @Override
    public void setData(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        if (dArray == null) {
            this.cachedPivots = null;
        } else {
            this.cachedPivots = new int[512];
            Arrays.fill(this.cachedPivots, -1);
        }
        super.setData(dArray, n, n2);
    }

    public double evaluate(double d) throws MathIllegalArgumentException {
        return this.evaluate(this.getDataRef(), d);
    }

    public double evaluate(double[] dArray, double d) throws MathIllegalArgumentException {
        MathArrays.verifyValues(dArray, 0, 0);
        return this.evaluate(dArray, 0, dArray.length, d);
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        return this.evaluate(dArray, n, n2, this.quantile);
    }

    public double evaluate(double[] dArray, int n, int n2, double d) throws MathIllegalArgumentException {
        MathArrays.verifyValues(dArray, n, n2);
        if (d > 100.0 || d <= 0.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUNDS_QUANTILE_VALUE, (Number)d, 0, 100);
        }
        if (n2 == 0) {
            return Double.NaN;
        }
        if (n2 == 1) {
            return dArray[n];
        }
        double[] dArray2 = this.getWorkArray(dArray, n, n2);
        int[] nArray = this.getPivots(dArray);
        return dArray2.length == 0 ? Double.NaN : this.estimationType.evaluate(dArray2, nArray, d, this.kthSelector);
    }

    public double getQuantile() {
        return this.quantile;
    }

    public void setQuantile(double d) throws MathIllegalArgumentException {
        if (d <= 0.0 || d > 100.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUNDS_QUANTILE_VALUE, (Number)d, 0, 100);
        }
        this.quantile = d;
    }

    @Override
    public Percentile copy() {
        return new Percentile(this);
    }

    protected double[] getWorkArray(double[] dArray, int n, int n2) {
        double[] dArray2;
        if (dArray == this.getDataRef()) {
            dArray2 = this.getDataRef();
        } else {
            switch (this.nanStrategy) {
                case MAXIMAL: {
                    dArray2 = Percentile.replaceAndSlice(dArray, n, n2, Double.NaN, Double.POSITIVE_INFINITY);
                    break;
                }
                case MINIMAL: {
                    dArray2 = Percentile.replaceAndSlice(dArray, n, n2, Double.NaN, Double.NEGATIVE_INFINITY);
                    break;
                }
                case REMOVED: {
                    dArray2 = Percentile.removeAndSlice(dArray, n, n2, Double.NaN);
                    break;
                }
                case FAILED: {
                    dArray2 = Percentile.copyOf(dArray, n, n2);
                    MathArrays.checkNotNaN(dArray2);
                    break;
                }
                default: {
                    dArray2 = Percentile.copyOf(dArray, n, n2);
                }
            }
        }
        return dArray2;
    }

    private static double[] copyOf(double[] dArray, int n, int n2) {
        MathArrays.verifyValues(dArray, n, n2);
        return MathArrays.copyOfRange(dArray, n, n + n2);
    }

    private static double[] replaceAndSlice(double[] dArray, int n, int n2, double d, double d2) {
        double[] dArray2 = Percentile.copyOf(dArray, n, n2);
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = Precision.equalsIncludingNaN(d, dArray2[i]) ? d2 : dArray2[i];
        }
        return dArray2;
    }

    private static double[] removeAndSlice(double[] dArray, int n, int n2, double d) {
        double[] dArray2;
        int n3;
        MathArrays.verifyValues(dArray, n, n2);
        BitSet bitSet = new BitSet(n2);
        for (n3 = n; n3 < n + n2; ++n3) {
            if (!Precision.equalsIncludingNaN(d, dArray[n3])) continue;
            bitSet.set(n3 - n);
        }
        if (bitSet.isEmpty()) {
            dArray2 = Percentile.copyOf(dArray, n, n2);
        } else if (bitSet.cardinality() == n2) {
            dArray2 = new double[]{};
        } else {
            dArray2 = new double[n2 - bitSet.cardinality()];
            n3 = n;
            int n4 = 0;
            int n5 = -1;
            int n6 = 0;
            while ((n5 = bitSet.nextSetBit(n6)) != -1) {
                int n7 = n5 - n6;
                System.arraycopy(dArray, n3, dArray2, n4, n7);
                n4 += n7;
                n6 = bitSet.nextClearBit(n5);
                n3 = n + n6;
            }
            if (n3 < n + n2) {
                System.arraycopy(dArray, n3, dArray2, n4, n + n2 - n3);
            }
        }
        return dArray2;
    }

    private int[] getPivots(double[] dArray) {
        int[] nArray;
        if (dArray == this.getDataRef()) {
            nArray = this.cachedPivots;
        } else {
            nArray = new int[512];
            Arrays.fill(nArray, -1);
        }
        return nArray;
    }

    public EstimationType getEstimationType() {
        return this.estimationType;
    }

    public Percentile withEstimationType(EstimationType estimationType) {
        return new Percentile(this.quantile, estimationType, this.nanStrategy, this.kthSelector);
    }

    public NaNStrategy getNaNStrategy() {
        return this.nanStrategy;
    }

    public Percentile withNaNStrategy(NaNStrategy naNStrategy) {
        return new Percentile(this.quantile, this.estimationType, naNStrategy, this.kthSelector);
    }

    public KthSelector getKthSelector() {
        return this.kthSelector;
    }

    public PivotingStrategyInterface getPivotingStrategy() {
        return this.kthSelector.getPivotingStrategy();
    }

    public Percentile withKthSelector(KthSelector kthSelector) {
        return new Percentile(this.quantile, this.estimationType, this.nanStrategy, kthSelector);
    }

    public static enum EstimationType {
        LEGACY("Legacy Apache Commons Math"){

            @Override
            protected double index(double d, int n) {
                return Double.compare(d, 0.0) == 0 ? 0.0 : (Double.compare(d, 1.0) == 0 ? (double)n : d * (double)(n + 1));
            }
        }
        ,
        R_1("R-1"){

            @Override
            protected double index(double d, int n) {
                return Double.compare(d, 0.0) == 0 ? 0.0 : (double)n * d + 0.5;
            }

            @Override
            protected double estimate(double[] dArray, int[] nArray, double d, int n, KthSelector kthSelector) {
                return super.estimate(dArray, nArray, FastMath.ceil(d - 0.5), n, kthSelector);
            }
        }
        ,
        R_2("R-2"){

            @Override
            protected double index(double d, int n) {
                return Double.compare(d, 1.0) == 0 ? (double)n : (Double.compare(d, 0.0) == 0 ? 0.0 : (double)n * d + 0.5);
            }

            @Override
            protected double estimate(double[] dArray, int[] nArray, double d, int n, KthSelector kthSelector) {
                double d2 = super.estimate(dArray, nArray, FastMath.ceil(d - 0.5), n, kthSelector);
                double d3 = super.estimate(dArray, nArray, FastMath.floor(d + 0.5), n, kthSelector);
                return (d2 + d3) / 2.0;
            }
        }
        ,
        R_3("R-3"){

            @Override
            protected double index(double d, int n) {
                double d2 = 0.5 / (double)n;
                return Double.compare(d, d2) <= 0 ? 0.0 : FastMath.rint((double)n * d);
            }
        }
        ,
        R_4("R-4"){

            @Override
            protected double index(double d, int n) {
                double d2 = 1.0 / (double)n;
                return Double.compare(d, d2) < 0 ? 0.0 : (Double.compare(d, 1.0) == 0 ? (double)n : (double)n * d);
            }
        }
        ,
        R_5("R-5"){

            @Override
            protected double index(double d, int n) {
                double d2 = 0.5 / (double)n;
                double d3 = ((double)n - 0.5) / (double)n;
                return Double.compare(d, d2) < 0 ? 0.0 : (Double.compare(d, d3) >= 0 ? (double)n : (double)n * d + 0.5);
            }
        }
        ,
        R_6("R-6"){

            @Override
            protected double index(double d, int n) {
                double d2 = 1.0 / (double)(n + 1);
                double d3 = 1.0 * (double)n / (double)(n + 1);
                return Double.compare(d, d2) < 0 ? 0.0 : (Double.compare(d, d3) >= 0 ? (double)n : (double)(n + 1) * d);
            }
        }
        ,
        R_7("R-7"){

            @Override
            protected double index(double d, int n) {
                return Double.compare(d, 0.0) == 0 ? 0.0 : (Double.compare(d, 1.0) == 0 ? (double)n : 1.0 + (double)(n - 1) * d);
            }
        }
        ,
        R_8("R-8"){

            @Override
            protected double index(double d, int n) {
                double d2 = 0.6666666666666666 / ((double)n + 0.3333333333333333);
                double d3 = ((double)n - 0.3333333333333333) / ((double)n + 0.3333333333333333);
                return Double.compare(d, d2) < 0 ? 0.0 : (Double.compare(d, d3) >= 0 ? (double)n : ((double)n + 0.3333333333333333) * d + 0.3333333333333333);
            }
        }
        ,
        R_9("R-9"){

            @Override
            protected double index(double d, int n) {
                double d2 = 0.625 / ((double)n + 0.25);
                double d3 = ((double)n - 0.375) / ((double)n + 0.25);
                return Double.compare(d, d2) < 0 ? 0.0 : (Double.compare(d, d3) >= 0 ? (double)n : ((double)n + 0.25) * d + 0.375);
            }
        };

        private final String name;

        private EstimationType(String string2) {
            this.name = string2;
        }

        protected abstract double index(double var1, int var3);

        protected double estimate(double[] dArray, int[] nArray, double d, int n, KthSelector kthSelector) {
            double d2 = FastMath.floor(d);
            int n2 = (int)d2;
            double d3 = d - d2;
            if (d < 1.0) {
                return kthSelector.select(dArray, nArray, 0);
            }
            if (d >= (double)n) {
                return kthSelector.select(dArray, nArray, n - 1);
            }
            double d4 = kthSelector.select(dArray, nArray, n2 - 1);
            double d5 = kthSelector.select(dArray, nArray, n2);
            return d4 + d3 * (d5 - d4);
        }

        protected double evaluate(double[] dArray, int[] nArray, double d, KthSelector kthSelector) {
            MathUtils.checkNotNull(dArray);
            if (d > 100.0 || d <= 0.0) {
                throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_BOUNDS_QUANTILE_VALUE, (Number)d, 0, 100);
            }
            return this.estimate(dArray, nArray, this.index(d / 100.0, dArray.length), dArray.length, kthSelector);
        }

        public double evaluate(double[] dArray, double d, KthSelector kthSelector) {
            return this.evaluate(dArray, null, d, kthSelector);
        }

        String getName() {
            return this.name;
        }
    }
}

