/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractDiscreteDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DiscreteDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import io.virtdata.shaded.oac.statistics.distribution.NormalDistribution;
import io.virtdata.shaded.oac.statistics.distribution.SaddlePointExpansion;
import org.apache.commons.numbers.gamma.RegularizedGamma;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.PoissonSampler;

public class PoissonDistribution
extends AbstractDiscreteDistribution {
    private static final double LOG_TWO_PI = Math.log(Math.PI * 2);
    private static final int DEFAULT_MAX_ITERATIONS = 10000000;
    private static final double DEFAULT_EPSILON = 1.0E-12;
    private final NormalDistribution normal;
    private final double mean;
    private final int maxIterations;
    private final double epsilon;

    public PoissonDistribution(double d) {
        this(d, 1.0E-12, 10000000);
    }

    private PoissonDistribution(double d, double d2, int n) {
        if (d <= 0.0) {
            throw new DistributionException("Number {0} is negative", d);
        }
        this.mean = d;
        this.epsilon = d2;
        this.maxIterations = n;
        this.normal = new NormalDistribution(d, Math.sqrt(d));
    }

    @Override
    public double probability(int n) {
        double d = this.logProbability(n);
        return d == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(d);
    }

    @Override
    public double logProbability(int n) {
        double d = n < 0 || n == Integer.MAX_VALUE ? Double.NEGATIVE_INFINITY : (n == 0 ? -this.mean : -SaddlePointExpansion.getStirlingError(n) - SaddlePointExpansion.getDeviancePart(n, this.mean) - 0.5 * LOG_TWO_PI - 0.5 * Math.log(n));
        return d;
    }

    @Override
    public double cumulativeProbability(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (n == Integer.MAX_VALUE) {
            return 1.0;
        }
        return RegularizedGamma.Q.value((double)n + 1.0, this.mean, this.epsilon, this.maxIterations);
    }

    public double normalApproximateProbability(int n) {
        return this.normal.cumulativeProbability((double)n + 0.5);
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        return this.mean;
    }

    @Override
    public int getSupportLowerBound() {
        return 0;
    }

    @Override
    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(final UniformRandomProvider uniformRandomProvider) {
        return new DiscreteDistribution.Sampler(){
            private final DiscreteSampler sampler;
            {
                this.sampler = new PoissonSampler(uniformRandomProvider, PoissonDistribution.this.mean);
            }

            @Override
            public int sample() {
                return this.sampler.sample();
            }
        };
    }
}

