/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math4.distribution.AbstractMultivariateRealDistribution;
import org.apache.commons.math4.distribution.MultivariateRealDistribution;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.Pair;
import org.apache.commons.rng.UniformRandomProvider;

public class MixtureMultivariateRealDistribution<T extends MultivariateRealDistribution>
extends AbstractMultivariateRealDistribution {
    private final double[] weight;
    private final List<T> distribution;

    public MixtureMultivariateRealDistribution(List<Pair<Double, T>> list) {
        super(((MultivariateRealDistribution)list.get(0).getSecond()).getDimension());
        Pair<Double, T> pair;
        int n;
        int n2 = list.size();
        int n3 = this.getDimension();
        double d = 0.0;
        for (n = 0; n < n2; ++n) {
            pair = list.get(n);
            if (((MultivariateRealDistribution)pair.getSecond()).getDimension() != n3) {
                throw new DimensionMismatchException(((MultivariateRealDistribution)pair.getSecond()).getDimension(), n3);
            }
            if (pair.getFirst() < 0.0) {
                throw new NotPositiveException(pair.getFirst());
            }
            d += pair.getFirst().doubleValue();
        }
        if (Double.isInfinite(d)) {
            throw new MathArithmeticException(LocalizedFormats.OVERFLOW, new Object[0]);
        }
        this.distribution = new ArrayList<T>();
        this.weight = new double[n2];
        for (n = 0; n < n2; ++n) {
            pair = list.get(n);
            this.weight[n] = pair.getFirst() / d;
            this.distribution.add((MultivariateRealDistribution)pair.getSecond());
        }
    }

    @Override
    public double density(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < this.weight.length; ++i) {
            d += this.weight[i] * ((MultivariateRealDistribution)this.distribution.get(i)).density(dArray);
        }
        return d;
    }

    public List<Pair<Double, T>> getComponents() {
        ArrayList<Pair<Double, T>> arrayList = new ArrayList<Pair<Double, T>>(this.weight.length);
        for (int i = 0; i < this.weight.length; ++i) {
            arrayList.add(new Pair<Double, MultivariateRealDistribution>(this.weight[i], (MultivariateRealDistribution)this.distribution.get(i)));
        }
        return arrayList;
    }

    @Override
    public MultivariateRealDistribution.Sampler createSampler(UniformRandomProvider uniformRandomProvider) {
        return new MixtureSampler(uniformRandomProvider);
    }

    private class MixtureSampler
    implements MultivariateRealDistribution.Sampler {
        private final UniformRandomProvider rng;
        private final MultivariateRealDistribution.Sampler[] samplers;

        MixtureSampler(UniformRandomProvider uniformRandomProvider) {
            this.rng = uniformRandomProvider;
            this.samplers = new MultivariateRealDistribution.Sampler[MixtureMultivariateRealDistribution.this.weight.length];
            for (int i = 0; i < MixtureMultivariateRealDistribution.this.weight.length; ++i) {
                this.samplers[i] = ((MultivariateRealDistribution)MixtureMultivariateRealDistribution.this.distribution.get(i)).createSampler(this.rng);
            }
        }

        @Override
        public double[] sample() {
            double[] dArray = null;
            double d = this.rng.nextDouble();
            double d2 = 0.0;
            for (int i = 0; i < MixtureMultivariateRealDistribution.this.weight.length; ++i) {
                if (!(d <= (d2 += MixtureMultivariateRealDistribution.this.weight[i]))) continue;
                dArray = this.samplers[i].sample();
                break;
            }
            if (dArray == null) {
                dArray = this.samplers[MixtureMultivariateRealDistribution.this.weight.length - 1].sample();
            }
            return dArray;
        }
    }
}

