/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathUtils;
import org.apache.commons.math4.util.MedianOf3PivotingStrategy;
import org.apache.commons.math4.util.PivotingStrategyInterface;

public class KthSelector
implements Serializable {
    private static final long serialVersionUID = 20140713L;
    private static final int MIN_SELECT_SIZE = 15;
    private final PivotingStrategyInterface pivotingStrategy;

    public KthSelector() {
        this.pivotingStrategy = new MedianOf3PivotingStrategy();
    }

    public KthSelector(PivotingStrategyInterface pivotingStrategyInterface) throws NullArgumentException {
        MathUtils.checkNotNull(pivotingStrategyInterface);
        this.pivotingStrategy = pivotingStrategyInterface;
    }

    public PivotingStrategyInterface getPivotingStrategy() {
        return this.pivotingStrategy;
    }

    public double select(double[] dArray, int[] nArray, int n) {
        boolean bl;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = 0;
        boolean bl2 = bl = nArray != null;
        while (n3 - n2 > 15) {
            int n5;
            if (bl && n4 < nArray.length && nArray[n4] >= 0) {
                n5 = nArray[n4];
            } else {
                n5 = this.partition(dArray, n2, n3, this.pivotingStrategy.pivotIndex(dArray, n2, n3));
                if (bl && n4 < nArray.length) {
                    nArray[n4] = n5;
                }
            }
            if (n == n5) {
                return dArray[n];
            }
            if (n < n5) {
                n3 = n5;
                n4 = FastMath.min(2 * n4 + 1, bl ? nArray.length : n3);
                continue;
            }
            n2 = n5 + 1;
            n4 = FastMath.min(2 * n4 + 2, bl ? nArray.length : n3);
        }
        Arrays.sort(dArray, n2, n3);
        return dArray[n];
    }

    private int partition(double[] dArray, int n, int n2, int n3) {
        double d = dArray[n3];
        dArray[n3] = dArray[n];
        int n4 = n + 1;
        int n5 = n2 - 1;
        while (n4 < n5) {
            while (n4 < n5 && Double.compare(dArray[n5], d) > 0) {
                --n5;
            }
            while (n4 < n5 && Double.compare(dArray[n4], d) < 0) {
                ++n4;
            }
            if (n4 >= n5) continue;
            double d2 = dArray[n4];
            dArray[n4++] = dArray[n5];
            dArray[n5--] = d2;
        }
        if (n4 >= n2 || Double.compare(dArray[n4], d) > 0) {
            --n4;
        }
        dArray[n] = dArray[n4];
        dArray[n4] = d;
        return n4;
    }
}

