/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.combinatorics;

import org.apache.commons.numbers.combinatorics.CombinatoricsException;
import org.apache.commons.numbers.combinatorics.Factorial;
import org.apache.commons.numbers.gamma.LogGamma;

public class LogFactorial {
    private static final int FACTORIALS_CACHE_SIZE = 21;
    private final double[] logFactorials;

    private LogFactorial(int n, double[] dArray) {
        int n2;
        if (n < 0) {
            throw new CombinatoricsException("Number {0} is negative", n);
        }
        this.logFactorials = new double[n];
        int n3 = dArray == null || dArray.length <= 2 ? 2 : (dArray.length <= n ? dArray.length : n);
        for (n2 = 2; n2 < n3; ++n2) {
            this.logFactorials[n2] = dArray[n2];
        }
        for (n2 = n3; n2 < n; ++n2) {
            this.logFactorials[n2] = this.logFactorials[n2 - 1] + Math.log(n2);
        }
    }

    public static LogFactorial create() {
        return new LogFactorial(0, null);
    }

    public LogFactorial withCache(int n) {
        return new LogFactorial(n, this.logFactorials);
    }

    public double value(int n) {
        if (n < 0) {
            throw new CombinatoricsException("Number {0} is negative", n);
        }
        if (n < this.logFactorials.length) {
            return this.logFactorials[n];
        }
        if (n < 21) {
            return Math.log(Factorial.value(n));
        }
        return LogGamma.value(n + 1);
    }
}

