/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

import org.apache.commons.numbers.gamma.InvGamma1pm1;
import org.apache.commons.numbers.gamma.LanczosApproximation;

public class Gamma {
    private static final double SQRT_TWO_PI = 2.5066282746310007;

    public static double value(double d) {
        if (d == Math.rint(d) && d <= 0.0) {
            return Double.NaN;
        }
        double d2 = Math.abs(d);
        if (d2 <= 20.0) {
            if (d >= 1.0) {
                double d3 = 1.0;
                double d4 = d;
                while (d4 > 2.5) {
                    d3 *= (d4 -= 1.0);
                }
                return d3 / (1.0 + InvGamma1pm1.value(d4 - 1.0));
            }
            double d5 = d;
            double d6 = d;
            while (d6 < -0.5) {
                d5 *= (d6 += 1.0);
            }
            return 1.0 / (d5 * (1.0 + InvGamma1pm1.value(d6)));
        }
        double d7 = d2 + LanczosApproximation.g() + 0.5;
        double d8 = 2.5066282746310007 / d2 * Math.pow(d7, d2 + 0.5) * Math.exp(-d7) * LanczosApproximation.value(d2);
        if (d > 0.0) {
            return d8;
        }
        return -Math.PI / (d * Math.sin(Math.PI * d) * d8);
    }
}

