/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

import org.apache.commons.numbers.gamma.Gamma;
import org.apache.commons.numbers.gamma.GammaException;
import org.apache.commons.numbers.gamma.LogGamma;
import org.apache.commons.numbers.gamma.LogGammaSum;

public class LogBeta {
    private static final double HALF_LOG_TWO_PI = 0.9189385332046727;
    private static final double[] DELTA = new double[]{0.08333333333333333, -2.777777777777778E-5, 7.936507936507937E-8, -5.952380952380953E-10, 8.417508417508329E-12, -1.917526917518546E-13, 6.410256405103255E-15, -2.955065141253382E-16, 1.7964371635940225E-17, -1.3922896466162779E-18, 1.338028550140209E-19, -1.542460098679661E-20, 1.9770199298095743E-21, -2.3406566479399704E-22, 1.713480149663986E-23};

    private static double deltaMinusDeltaSum(double d, double d2) {
        if (d < 0.0 || d > d2) {
            throw new GammaException("Number {0} is out of range [{1}, {2}]", d, 0, d2);
        }
        if (d2 < 10.0) {
            throw new GammaException("Number {0} is out of range [{1}, {2}]", d2, 10, Double.POSITIVE_INFINITY);
        }
        double d3 = d / d2;
        double d4 = d3 / (1.0 + d3);
        double d5 = 1.0 / (1.0 + d3);
        double d6 = d5 * d5;
        double[] dArray = new double[DELTA.length];
        dArray[0] = 1.0;
        for (int i = 1; i < dArray.length; ++i) {
            dArray[i] = 1.0 + (d5 + d6 * dArray[i - 1]);
        }
        double d7 = 10.0 / d2;
        double d8 = d7 * d7;
        double d9 = DELTA[DELTA.length - 1] * dArray[dArray.length - 1];
        for (int i = DELTA.length - 2; i >= 0; --i) {
            d9 = d8 * d9 + DELTA[i] * dArray[i];
        }
        return d9 * d4 / d2;
    }

    private static double sumDeltaMinusDeltaSum(double d, double d2) {
        if (d < 10.0) {
            throw new GammaException("Number {0} is out of range [{1}, {2}]", d, 10, Double.POSITIVE_INFINITY);
        }
        if (d2 < 10.0) {
            throw new GammaException("Number {0} is out of range [{1}, {2}]", d2, 10, Double.POSITIVE_INFINITY);
        }
        double d3 = Math.min(d, d2);
        double d4 = Math.max(d, d2);
        double d5 = 10.0 / d3;
        double d6 = d5 * d5;
        double d7 = DELTA[DELTA.length - 1];
        for (int i = DELTA.length - 2; i >= 0; --i) {
            d7 = d6 * d7 + DELTA[i];
        }
        return d7 / d3 + LogBeta.deltaMinusDeltaSum(d3, d4);
    }

    public static double value(double d, double d2) {
        if (Double.isNaN(d) || Double.isNaN(d2) || d <= 0.0 || d2 <= 0.0) {
            return Double.NaN;
        }
        double d3 = Math.min(d, d2);
        double d4 = Math.max(d, d2);
        if (d3 >= 10.0) {
            double d5;
            double d6 = LogBeta.sumDeltaMinusDeltaSum(d3, d4);
            double d7 = d3 / d4;
            double d8 = d7 / (1.0 + d7);
            double d9 = -(d3 - 0.5) * Math.log(d8);
            if (d9 <= (d5 = d4 * Math.log1p(d7))) {
                return -0.5 * Math.log(d4) + 0.9189385332046727 + d6 - d9 - d5;
            }
            return -0.5 * Math.log(d4) + 0.9189385332046727 + d6 - d5 - d9;
        }
        if (d3 > 2.0) {
            double d10;
            if (d4 > 1000.0) {
                int n = (int)Math.floor(d3 - 1.0);
                double d11 = 1.0;
                double d12 = d3;
                for (int i = 0; i < n; ++i) {
                    d11 *= (d12 -= 1.0) / (1.0 + d12 / d4);
                }
                return Math.log(d11) - (double)n * Math.log(d4) + (LogGamma.value(d12) + LogBeta.logGammaMinusLogGammaSum(d12, d4));
            }
            double d13 = 1.0;
            double d14 = d3;
            while (d14 > 2.0) {
                d10 = (d14 -= 1.0) / d4;
                d13 *= d10 / (1.0 + d10);
            }
            if (d4 < 10.0) {
                d10 = 1.0;
                double d15 = d4;
                while (d15 > 2.0) {
                    d10 *= (d15 -= 1.0) / (d14 + d15);
                }
                return Math.log(d13) + Math.log(d10) + (LogGamma.value(d14) + (LogGamma.value(d15) - LogGammaSum.value(d14, d15)));
            }
            return Math.log(d13) + LogGamma.value(d14) + LogBeta.logGammaMinusLogGammaSum(d14, d4);
        }
        if (d3 >= 1.0) {
            if (d4 > 2.0) {
                if (d4 < 10.0) {
                    double d16 = 1.0;
                    double d17 = d4;
                    while (d17 > 2.0) {
                        d16 *= (d17 -= 1.0) / (d3 + d17);
                    }
                    return Math.log(d16) + (LogGamma.value(d3) + (LogGamma.value(d17) - LogGammaSum.value(d3, d17)));
                }
                return LogGamma.value(d3) + LogBeta.logGammaMinusLogGammaSum(d3, d4);
            }
            return LogGamma.value(d3) + LogGamma.value(d4) - LogGammaSum.value(d3, d4);
        }
        if (d4 >= 10.0) {
            return LogGamma.value(d3) + LogBeta.logGammaMinusLogGammaSum(d3, d4);
        }
        return Math.log(Gamma.value(d3) * Gamma.value(d4) / Gamma.value(d3 + d4));
    }

    private static double logGammaMinusLogGammaSum(double d, double d2) {
        double d3;
        double d4;
        if (d < 0.0) {
            throw new GammaException("Number {0} is out of range [{1}, {2}]", d, 0, Double.POSITIVE_INFINITY);
        }
        if (d2 < 10.0) {
            throw new GammaException("Number {0} is out of range [{1}, {2}]", d2, 10, Double.POSITIVE_INFINITY);
        }
        if (d <= d2) {
            d4 = d2 + (d - 0.5);
            d3 = LogBeta.deltaMinusDeltaSum(d, d2);
        } else {
            d4 = d + (d2 - 0.5);
            d3 = LogBeta.deltaMinusDeltaSum(d2, d);
        }
        double d5 = d4 * Math.log1p(d / d2);
        double d6 = d * (Math.log(d2) - 1.0);
        return d5 <= d6 ? d3 - d5 - d6 : d3 - d6 - d5;
    }
}

