/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple;

import java.util.EnumMap;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.simple.RandomSource;

public final class ThreadLocalRandomSource {
    private static EnumMap<RandomSource, ThreadLocal<UniformRandomProvider>> sources = new EnumMap(RandomSource.class);

    private ThreadLocalRandomSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UniformRandomProvider current(RandomSource randomSource) {
        ThreadLocalRng threadLocalRng = sources.get((Object)randomSource);
        if (threadLocalRng == null) {
            if (randomSource == null) {
                throw new IllegalArgumentException("Random source is null");
            }
            EnumMap<RandomSource, ThreadLocal<UniformRandomProvider>> enumMap = sources;
            synchronized (enumMap) {
                threadLocalRng = sources.get((Object)randomSource);
                if (threadLocalRng == null) {
                    threadLocalRng = new ThreadLocalRng(randomSource);
                    sources.put(randomSource, threadLocalRng);
                }
            }
        }
        return threadLocalRng.get();
    }

    private static class ThreadLocalRng
    extends ThreadLocal<UniformRandomProvider> {
        private final RandomSource source;

        ThreadLocalRng(RandomSource randomSource) {
            this.source = randomSource;
        }

        @Override
        protected UniformRandomProvider initialValue() {
            return RandomSource.create(this.source, null, new Object[0]);
        }
    }
}

