/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.continuous.long_double;

import io.virtdata.annotations.Example;
import io.virtdata.annotations.Examples;
import io.virtdata.annotations.ThreadSafeMapper;
import io.virtdata.continuous.long_double.LongToDoubleContinuousCurve;
import org.apache.commons.math4.distribution.EnumeratedRealDistribution;

@ThreadSafeMapper
public class Enumerated
extends LongToDoubleContinuousCurve {
    @Examples(value={@Example(value={"Enumerated('1 2 3 4 5 6')", "a fair 6-sided die"}), @Example(value={"Enumerated('1:2.0 2 3 4 5:0.5 6:0.5')", "an unfair fair 6-sided die, where ones are twice as likely, and fives and sixes are half as likely"})})
    public Enumerated(String string, String ... stringArray) {
        super(new EnumeratedRealDistribution(Enumerated.parseWeights(string)[0], Enumerated.parseWeights(string)[1]), stringArray);
    }

    private static double[][] parseWeights(String string) {
        String[] stringArray = string.split("[;, ]");
        double[][] dArray = new double[2][stringArray.length];
        block4: for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(":");
            dArray[1][i] = 1.0;
            switch (stringArray2.length) {
                case 2: {
                    dArray[1][i] = Double.parseDouble(stringArray2[1]);
                }
                case 1: {
                    dArray[0][i] = Double.parseDouble(stringArray2[0]);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Unable to parse entry or weight from '" + stringArray[i] + "'");
                }
            }
        }
        return dArray;
    }
}

