/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.discrete.int_long;

import io.virtdata.discrete.common.DiscreteIntLongSampler;
import io.virtdata.discrete.common.IntegerDistributionICDSource;
import io.virtdata.discrete.common.InterpolatingIntLongSampler;
import io.virtdata.shaded.oac.statistics.distribution.DiscreteDistribution;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.IntToLongFunction;

public class IntToLongDiscreteCurve
implements IntToLongFunction {
    private DiscreteDistribution distribution;
    private IntToLongFunction function;
    public static final String COMPUTE = "compute";
    public static final String INTERPOLATE = "interpolate";
    public static final String MAP = "map";
    public static final String HASH = "hash";
    private static final HashSet<String> validModifiers = new HashSet<String>(){
        {
            this.add(IntToLongDiscreteCurve.COMPUTE);
            this.add(IntToLongDiscreteCurve.INTERPOLATE);
            this.add(IntToLongDiscreteCurve.MAP);
            this.add(IntToLongDiscreteCurve.HASH);
        }
    };

    public IntToLongDiscreteCurve(DiscreteDistribution discreteDistribution, String ... stringArray) {
        this.distribution = discreteDistribution;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        IntegerDistributionICDSource integerDistributionICDSource = new IntegerDistributionICDSource(discreteDistribution);
        if (hashSet.contains(HASH) && hashSet.contains(MAP)) {
            throw new RuntimeException("mods must not contain both hash and map.");
        }
        if (hashSet.contains(INTERPOLATE) && hashSet.contains(COMPUTE)) {
            throw new RuntimeException("mods must not contain both interpolate and compute.");
        }
        for (String string : stringArray) {
            if (validModifiers.contains(string)) continue;
            throw new RuntimeException("modifier '" + string + "' is not a valid modifier. Use one of " + validModifiers.toString() + " instead.");
        }
        boolean bl = hashSet.contains(HASH) || !hashSet.contains(MAP);
        int n = hashSet.contains(INTERPOLATE) || !hashSet.contains(COMPUTE) ? 1 : 0;
        this.function = n != 0 ? new InterpolatingIntLongSampler(integerDistributionICDSource, 1000, bl) : new DiscreteIntLongSampler(integerDistributionICDSource, bl);
    }

    @Override
    public long applyAsLong(int n) {
        return this.function.applyAsLong(n);
    }
}

