/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.correlation;

import io.virtdata.shaded.oac.statistics.descriptive.moment.Mean;
import io.virtdata.shaded.oac.statistics.descriptive.moment.Variance;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.linear.BlockRealMatrix;
import org.apache.commons.math4.linear.RealMatrix;

public class Covariance {
    private final RealMatrix covarianceMatrix;
    private final int n;

    public Covariance() {
        this.covarianceMatrix = null;
        this.n = 0;
    }

    public Covariance(double[][] dArray, boolean bl) throws MathIllegalArgumentException, NotStrictlyPositiveException {
        this(new BlockRealMatrix(dArray), bl);
    }

    public Covariance(double[][] dArray) throws MathIllegalArgumentException, NotStrictlyPositiveException {
        this(dArray, true);
    }

    public Covariance(RealMatrix realMatrix, boolean bl) throws MathIllegalArgumentException {
        this.checkSufficientData(realMatrix);
        this.n = realMatrix.getRowDimension();
        this.covarianceMatrix = this.computeCovarianceMatrix(realMatrix, bl);
    }

    public Covariance(RealMatrix realMatrix) throws MathIllegalArgumentException {
        this(realMatrix, true);
    }

    public RealMatrix getCovarianceMatrix() {
        return this.covarianceMatrix;
    }

    public int getN() {
        return this.n;
    }

    protected RealMatrix computeCovarianceMatrix(RealMatrix realMatrix, boolean bl) throws MathIllegalArgumentException {
        int n = realMatrix.getColumnDimension();
        Variance variance = new Variance(bl);
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(n, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double d = this.covariance(realMatrix.getColumn(i), realMatrix.getColumn(j), bl);
                blockRealMatrix.setEntry(i, j, d);
                blockRealMatrix.setEntry(j, i, d);
            }
            blockRealMatrix.setEntry(i, i, variance.evaluate(realMatrix.getColumn(i)));
        }
        return blockRealMatrix;
    }

    protected RealMatrix computeCovarianceMatrix(RealMatrix realMatrix) throws MathIllegalArgumentException {
        return this.computeCovarianceMatrix(realMatrix, true);
    }

    protected RealMatrix computeCovarianceMatrix(double[][] dArray, boolean bl) throws MathIllegalArgumentException, NotStrictlyPositiveException {
        return this.computeCovarianceMatrix(new BlockRealMatrix(dArray), bl);
    }

    protected RealMatrix computeCovarianceMatrix(double[][] dArray) throws MathIllegalArgumentException, NotStrictlyPositiveException {
        return this.computeCovarianceMatrix(dArray, true);
    }

    public double covariance(double[] dArray, double[] dArray2, boolean bl) throws MathIllegalArgumentException {
        Mean mean = new Mean();
        double d = 0.0;
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new MathIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, n, dArray2.length);
        }
        if (n < 2) {
            throw new MathIllegalArgumentException(LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, n, 2);
        }
        double d2 = mean.evaluate(dArray);
        double d3 = mean.evaluate(dArray2);
        for (int i = 0; i < n; ++i) {
            double d4 = dArray[i] - d2;
            double d5 = dArray2[i] - d3;
            d += (d4 * d5 - d) / (double)(i + 1);
        }
        return bl ? d * ((double)n / (double)(n - 1)) : d;
    }

    public double covariance(double[] dArray, double[] dArray2) throws MathIllegalArgumentException {
        return this.covariance(dArray, dArray2, true);
    }

    private void checkSufficientData(RealMatrix realMatrix) throws MathIllegalArgumentException {
        int n = realMatrix.getRowDimension();
        int n2 = realMatrix.getColumnDimension();
        if (n < 2 || n2 < 1) {
            throw new MathIllegalArgumentException(LocalizedFormats.INSUFFICIENT_ROWS_AND_COLUMNS, n, n2);
        }
    }
}

