/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive.summary;

import io.virtdata.shaded.oac.statistics.descriptive.AbstractStorelessUnivariateStatistic;
import java.io.Serializable;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;

public class Sum
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    private long n;
    private double value;

    public Sum() {
        this.n = 0L;
        this.value = 0.0;
    }

    public Sum(Sum sum) throws NullArgumentException {
        Sum.copy(sum, this);
    }

    @Override
    public void increment(double d) {
        this.value += d;
        ++this.n;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = 0.0;
        this.n = 0L;
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        double d = Double.NaN;
        if (MathArrays.verifyValues(dArray, n, n2, true)) {
            d = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d += dArray[i];
            }
        }
        return d;
    }

    public double evaluate(double[] dArray, double[] dArray2, int n, int n2) throws MathIllegalArgumentException {
        double d = Double.NaN;
        if (MathArrays.verifyValues(dArray, dArray2, n, n2, true)) {
            d = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d += dArray[i] * dArray2[i];
            }
        }
        return d;
    }

    public double evaluate(double[] dArray, double[] dArray2) throws MathIllegalArgumentException {
        return this.evaluate(dArray, dArray2, 0, dArray.length);
    }

    @Override
    public Sum copy() {
        Sum sum = new Sum();
        Sum.copy(this, sum);
        return sum;
    }

    public static void copy(Sum sum, Sum sum2) throws NullArgumentException {
        MathUtils.checkNotNull(sum);
        MathUtils.checkNotNull(sum2);
        sum2.n = sum.n;
        sum2.value = sum.value;
    }
}

