/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractDiscreteDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import io.virtdata.shaded.oac.statistics.distribution.SaddlePointExpansion;
import org.apache.commons.numbers.gamma.RegularizedBeta;

public class BinomialDistribution
extends AbstractDiscreteDistribution {
    private final int numberOfTrials;
    private final double probabilityOfSuccess;

    public BinomialDistribution(int n, double d) {
        if (n < 0) {
            throw new DistributionException("Number {0} is negative", n);
        }
        if (d < 0.0 || d > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", d, 0, 1);
        }
        this.probabilityOfSuccess = d;
        this.numberOfTrials = n;
    }

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public double probability(int n) {
        double d = this.logProbability(n);
        return d == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(d);
    }

    @Override
    public double logProbability(int n) {
        if (this.numberOfTrials == 0) {
            return n == 0 ? 0.0 : Double.NEGATIVE_INFINITY;
        }
        double d = n < 0 || n > this.numberOfTrials ? Double.NEGATIVE_INFINITY : SaddlePointExpansion.logBinomialProbability(n, this.numberOfTrials, this.probabilityOfSuccess, 1.0 - this.probabilityOfSuccess);
        return d;
    }

    @Override
    public double cumulativeProbability(int n) {
        double d = n < 0 ? 0.0 : (n >= this.numberOfTrials ? 1.0 : 1.0 - RegularizedBeta.value(this.probabilityOfSuccess, (double)n + 1.0, this.numberOfTrials - n));
        return d;
    }

    @Override
    public double getMean() {
        return (double)this.numberOfTrials * this.probabilityOfSuccess;
    }

    @Override
    public double getVariance() {
        double d = this.probabilityOfSuccess;
        return (double)this.numberOfTrials * d * (1.0 - d);
    }

    @Override
    public int getSupportLowerBound() {
        return this.probabilityOfSuccess < 1.0 ? 0 : this.numberOfTrials;
    }

    @Override
    public int getSupportUpperBound() {
        return this.probabilityOfSuccess > 0.0 ? this.numberOfTrials : 0;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

