/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractDiscreteDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;

public class GeometricDistribution
extends AbstractDiscreteDistribution {
    private final double probabilityOfSuccess;
    private final double logProbabilityOfSuccess;
    private final double log1mProbabilityOfSuccess;

    public GeometricDistribution(double d) {
        if (d <= 0.0 || d > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", d, 0, 1);
        }
        this.probabilityOfSuccess = d;
        this.logProbabilityOfSuccess = Math.log(d);
        this.log1mProbabilityOfSuccess = Math.log1p(-d);
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public double probability(int n) {
        if (n < 0) {
            return 0.0;
        }
        return Math.exp(this.log1mProbabilityOfSuccess * (double)n) * this.probabilityOfSuccess;
    }

    @Override
    public double logProbability(int n) {
        if (n < 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return (double)n * this.log1mProbabilityOfSuccess + this.logProbabilityOfSuccess;
    }

    @Override
    public double cumulativeProbability(int n) {
        if (n < 0) {
            return 0.0;
        }
        return -Math.expm1(this.log1mProbabilityOfSuccess * (double)(n + 1));
    }

    @Override
    public double getMean() {
        return (1.0 - this.probabilityOfSuccess) / this.probabilityOfSuccess;
    }

    @Override
    public double getVariance() {
        return (1.0 - this.probabilityOfSuccess) / (this.probabilityOfSuccess * this.probabilityOfSuccess);
    }

    @Override
    public int getSupportLowerBound() {
        return 0;
    }

    @Override
    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public int inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", d, 0, 1);
        }
        if (d == 1.0) {
            return Integer.MAX_VALUE;
        }
        if (d == 0.0) {
            return 0;
        }
        return Math.max(0, (int)Math.ceil(Math.log1p(-d) / this.log1mProbabilityOfSuccess - 1.0));
    }
}

