/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.function;

import org.apache.commons.math4.analysis.ParametricUnivariateFunction;
import org.apache.commons.math4.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math4.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.util.FastMath;

public class Logit
implements UnivariateDifferentiableFunction {
    private final double lo;
    private final double hi;

    public Logit() {
        this(0.0, 1.0);
    }

    public Logit(double d, double d2) {
        this.lo = d;
        this.hi = d2;
    }

    @Override
    public double value(double d) throws OutOfRangeException {
        return Logit.value(d, this.lo, this.hi);
    }

    private static double value(double d, double d2, double d3) throws OutOfRangeException {
        if (d < d2 || d > d3) {
            throw new OutOfRangeException(d, (Number)d2, d3);
        }
        return FastMath.log((d - d2) / (d3 - d));
    }

    @Override
    public DerivativeStructure value(DerivativeStructure derivativeStructure) throws OutOfRangeException {
        double d = derivativeStructure.getValue();
        if (d < this.lo || d > this.hi) {
            throw new OutOfRangeException(d, (Number)this.lo, this.hi);
        }
        double[] dArray = new double[derivativeStructure.getOrder() + 1];
        dArray[0] = FastMath.log((d - this.lo) / (this.hi - d));
        if (Double.isInfinite(dArray[0])) {
            if (dArray.length > 1) {
                dArray[1] = Double.POSITIVE_INFINITY;
            }
            for (int i = 2; i < dArray.length; ++i) {
                dArray[i] = dArray[i - 2];
            }
        } else {
            double d2;
            double d3;
            double d4 = d3 = 1.0 / (d - this.lo);
            double d5 = d2 = 1.0 / (this.hi - d);
            for (int i = 1; i < dArray.length; ++i) {
                dArray[i] = d4 + d5;
                d4 *= (double)(-i) * d3;
                d5 *= (double)i * d2;
            }
        }
        return derivativeStructure.compose(dArray);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        @Override
        public double value(double d, double ... dArray) throws NullArgumentException, DimensionMismatchException {
            this.validateParameters(dArray);
            return Logit.value(d, dArray[0], dArray[1]);
        }

        @Override
        public double[] gradient(double d, double ... dArray) throws NullArgumentException, DimensionMismatchException {
            this.validateParameters(dArray);
            double d2 = dArray[0];
            double d3 = dArray[1];
            return new double[]{1.0 / (d2 - d), 1.0 / (d3 - d)};
        }

        private void validateParameters(double[] dArray) throws NullArgumentException, DimensionMismatchException {
            if (dArray == null) {
                throw new NullArgumentException();
            }
            if (dArray.length != 2) {
                throw new DimensionMismatchException(dArray.length, 2);
            }
        }
    }
}

