/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.function;

import java.util.Arrays;
import org.apache.commons.math4.analysis.UnivariateFunction;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.NonMonotonicSequenceException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.util.MathArrays;

public class StepFunction
implements UnivariateFunction {
    private final double[] abscissa;
    private final double[] ordinate;

    public StepFunction(double[] dArray, double[] dArray2) throws NullArgumentException, NoDataException, DimensionMismatchException, NonMonotonicSequenceException {
        if (dArray == null || dArray2 == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0 || dArray2.length == 0) {
            throw new NoDataException();
        }
        if (dArray2.length != dArray.length) {
            throw new DimensionMismatchException(dArray2.length, dArray.length);
        }
        MathArrays.checkOrder(dArray);
        this.abscissa = MathArrays.copyOf(dArray);
        this.ordinate = MathArrays.copyOf(dArray2);
    }

    @Override
    public double value(double d) {
        int n = Arrays.binarySearch(this.abscissa, d);
        double d2 = 0.0;
        d2 = n < -1 ? this.ordinate[-n - 2] : (n >= 0 ? this.ordinate[n] : this.ordinate[0]);
        return d2;
    }
}

