/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.analysis.integration;

import org.apache.commons.math4.analysis.UnivariateFunction;
import org.apache.commons.math4.analysis.integration.BaseAbstractUnivariateIntegrator;
import org.apache.commons.math4.analysis.integration.gauss.GaussIntegrator;
import org.apache.commons.math4.analysis.integration.gauss.GaussIntegratorFactory;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.MaxCountExceededException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.TooManyEvaluationsException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;

public class IterativeLegendreGaussIntegrator
extends BaseAbstractUnivariateIntegrator {
    private static final GaussIntegratorFactory FACTORY = new GaussIntegratorFactory();
    private final int numberOfPoints;

    public IterativeLegendreGaussIntegrator(int n, double d, double d2, int n2, int n3) throws NotStrictlyPositiveException, NumberIsTooSmallException {
        super(d, d2, n2, n3);
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_POINTS, n);
        }
        this.numberOfPoints = n;
    }

    public IterativeLegendreGaussIntegrator(int n, double d, double d2) throws NotStrictlyPositiveException {
        this(n, d, d2, 3, Integer.MAX_VALUE);
    }

    public IterativeLegendreGaussIntegrator(int n, int n2, int n3) throws NotStrictlyPositiveException, NumberIsTooSmallException {
        this(n, 1.0E-6, 1.0E-15, n2, n3);
    }

    @Override
    protected double doIntegrate() throws MathIllegalArgumentException, TooManyEvaluationsException, MaxCountExceededException {
        double d = this.stage(1);
        int n = 2;
        while (true) {
            double d2 = this.stage(n);
            double d3 = FastMath.abs(d2 - d);
            double d4 = FastMath.max(this.getAbsoluteAccuracy(), this.getRelativeAccuracy() * (FastMath.abs(d) + FastMath.abs(d2)) * 0.5);
            if (this.iterations.getCount() + 1 >= this.getMinimalIterationCount() && d3 <= d4) {
                return d2;
            }
            double d5 = FastMath.min(4.0, FastMath.pow(d3 / d4, 0.5 / (double)this.numberOfPoints));
            n = FastMath.max((int)(d5 * (double)n), n + 1);
            d = d2;
            this.iterations.incrementCount();
        }
    }

    private double stage(int n) throws TooManyEvaluationsException {
        UnivariateFunction univariateFunction = new UnivariateFunction(){

            @Override
            public double value(double d) throws MathIllegalArgumentException, TooManyEvaluationsException {
                return IterativeLegendreGaussIntegrator.this.computeObjectiveValue(d);
            }
        };
        double d = this.getMin();
        double d2 = this.getMax();
        double d3 = (d2 - d) / (double)n;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d5 = d + (double)i * d3;
            double d6 = d5 + d3;
            GaussIntegrator gaussIntegrator = FACTORY.legendreHighPrecision(this.numberOfPoints, d5, d6);
            d4 += gaussIntegrator.integrate(univariateFunction);
        }
        return d4;
    }
}

