/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math4.exception.MathArithmeticException;
import org.apache.commons.math4.exception.NotANumberException;
import org.apache.commons.math4.exception.NotFiniteNumberException;
import org.apache.commons.math4.exception.NotPositiveException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.Pair;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.DiscreteProbabilityCollectionSampler;

public class EnumeratedDistribution<T>
implements Serializable {
    private static final long serialVersionUID = 20160319L;
    private final List<T> singletons;
    private final double[] probabilities;
    private final double[] cumulativeProbabilities;

    public EnumeratedDistribution(List<Pair<T, Double>> list) throws NotPositiveException, MathArithmeticException, NotFiniteNumberException, NotANumberException {
        this.singletons = new ArrayList<T>(list.size());
        double[] dArray = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Pair<T, Double> pair = list.get(i);
            this.singletons.add(pair.getKey());
            double d = pair.getValue();
            if (d < 0.0) {
                throw new NotPositiveException(pair.getValue());
            }
            if (Double.isInfinite(d)) {
                throw new NotFiniteNumberException(d, new Object[0]);
            }
            if (Double.isNaN(d)) {
                throw new NotANumberException();
            }
            dArray[i] = d;
        }
        this.probabilities = MathArrays.normalizeArray(dArray, 1.0);
        this.cumulativeProbabilities = new double[this.probabilities.length];
        double d = 0.0;
        for (int i = 0; i < this.probabilities.length; ++i) {
            this.cumulativeProbabilities[i] = d += this.probabilities[i];
        }
    }

    double probability(T t) {
        double d = 0.0;
        for (int i = 0; i < this.probabilities.length; ++i) {
            if ((t != null || this.singletons.get(i) != null) && (t == null || !t.equals(this.singletons.get(i)))) continue;
            d += this.probabilities[i];
        }
        return d;
    }

    public List<Pair<T, Double>> getPmf() {
        ArrayList<Pair<T, Double>> arrayList = new ArrayList<Pair<T, Double>>(this.probabilities.length);
        for (int i = 0; i < this.probabilities.length; ++i) {
            arrayList.add(new Pair<T, Double>(this.singletons.get(i), this.probabilities[i]));
        }
        return arrayList;
    }

    public Sampler createSampler(UniformRandomProvider uniformRandomProvider) {
        return new Sampler(uniformRandomProvider);
    }

    public class Sampler {
        private final DiscreteProbabilityCollectionSampler<T> sampler;

        Sampler(UniformRandomProvider uniformRandomProvider) {
            this.sampler = new DiscreteProbabilityCollectionSampler(uniformRandomProvider, EnumeratedDistribution.this.singletons, EnumeratedDistribution.this.probabilities);
        }

        public T sample() {
            return this.sampler.sample();
        }

        public Object[] sample(int n) throws NotStrictlyPositiveException {
            if (n <= 0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n);
            }
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.sample();
            }
            return objectArray;
        }

        public T[] sample(int n, T[] TArray) throws NotStrictlyPositiveException {
            Object[] objectArray;
            if (n <= 0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, n);
            }
            if (TArray == null) {
                throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
            }
            if (TArray.length < n) {
                Object[] objectArray2 = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
                objectArray = objectArray2;
            } else {
                objectArray = TArray;
            }
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.sample();
            }
            return objectArray;
        }
    }
}

