/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.MaxCountExceededException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.util.ExceptionContext;
import org.apache.commons.math4.linear.DefaultIterativeLinearSolverEvent;
import org.apache.commons.math4.linear.NonPositiveDefiniteOperatorException;
import org.apache.commons.math4.linear.NonSquareOperatorException;
import org.apache.commons.math4.linear.PreconditionedIterativeLinearSolver;
import org.apache.commons.math4.linear.RealLinearOperator;
import org.apache.commons.math4.linear.RealVector;
import org.apache.commons.math4.util.IterationManager;

public class ConjugateGradient
extends PreconditionedIterativeLinearSolver {
    public static final String OPERATOR = "operator";
    public static final String VECTOR = "vector";
    private boolean check;
    private final double delta;

    public ConjugateGradient(int n, double d, boolean bl) {
        super(n);
        this.delta = d;
        this.check = bl;
    }

    public ConjugateGradient(IterationManager iterationManager, double d, boolean bl) throws NullArgumentException {
        super(iterationManager);
        this.delta = d;
        this.check = bl;
    }

    public final boolean getCheck() {
        return this.check;
    }

    @Override
    public RealVector solveInPlace(RealLinearOperator realLinearOperator, RealLinearOperator realLinearOperator2, RealVector realVector, RealVector realVector2) throws NullArgumentException, NonPositiveDefiniteOperatorException, NonSquareOperatorException, DimensionMismatchException, MaxCountExceededException {
        ConjugateGradient.checkParameters(realLinearOperator, realLinearOperator2, realVector, realVector2);
        IterationManager iterationManager = this.getIterationManager();
        iterationManager.resetIterationCount();
        double d = this.delta * realVector.getNorm();
        RealVector realVector3 = RealVector.unmodifiableRealVector(realVector);
        iterationManager.incrementIterationCount();
        RealVector realVector4 = realVector2;
        RealVector realVector5 = RealVector.unmodifiableRealVector(realVector4);
        RealVector realVector6 = realVector4.copy();
        RealVector realVector7 = realLinearOperator.operate(realVector6);
        RealVector realVector8 = realVector.combine(1.0, -1.0, realVector7);
        RealVector realVector9 = RealVector.unmodifiableRealVector(realVector8);
        double d2 = realVector8.getNorm();
        RealVector realVector10 = realLinearOperator2 == null ? realVector8 : null;
        DefaultIterativeLinearSolverEvent defaultIterativeLinearSolverEvent = new DefaultIterativeLinearSolverEvent(this, iterationManager.getIterations(), realVector5, realVector3, realVector9, d2);
        iterationManager.fireInitializationEvent(defaultIterativeLinearSolverEvent);
        if (d2 <= d) {
            iterationManager.fireTerminationEvent(defaultIterativeLinearSolverEvent);
            return realVector4;
        }
        double d3 = 0.0;
        do {
            iterationManager.incrementIterationCount();
            defaultIterativeLinearSolverEvent = new DefaultIterativeLinearSolverEvent(this, iterationManager.getIterations(), realVector5, realVector3, realVector9, d2);
            iterationManager.fireIterationStartedEvent(defaultIterativeLinearSolverEvent);
            if (realLinearOperator2 != null) {
                realVector10 = realLinearOperator2.operate(realVector8);
            }
            double d4 = realVector8.dotProduct(realVector10);
            if (this.check && d4 <= 0.0) {
                NonPositiveDefiniteOperatorException nonPositiveDefiniteOperatorException = new NonPositiveDefiniteOperatorException();
                ExceptionContext exceptionContext = nonPositiveDefiniteOperatorException.getContext();
                exceptionContext.setValue(OPERATOR, realLinearOperator2);
                exceptionContext.setValue(VECTOR, realVector8);
                throw nonPositiveDefiniteOperatorException;
            }
            if (iterationManager.getIterations() == 2) {
                realVector6.setSubVector(0, realVector10);
            } else {
                realVector6.combineToSelf(d4 / d3, 1.0, realVector10);
            }
            realVector7 = realLinearOperator.operate(realVector6);
            double d5 = realVector6.dotProduct(realVector7);
            if (this.check && d5 <= 0.0) {
                NonPositiveDefiniteOperatorException nonPositiveDefiniteOperatorException = new NonPositiveDefiniteOperatorException();
                ExceptionContext exceptionContext = nonPositiveDefiniteOperatorException.getContext();
                exceptionContext.setValue(OPERATOR, realLinearOperator);
                exceptionContext.setValue(VECTOR, realVector6);
                throw nonPositiveDefiniteOperatorException;
            }
            double d6 = d4 / d5;
            realVector4.combineToSelf(1.0, d6, realVector6);
            realVector8.combineToSelf(1.0, -d6, realVector7);
            d3 = d4;
            d2 = realVector8.getNorm();
            defaultIterativeLinearSolverEvent = new DefaultIterativeLinearSolverEvent(this, iterationManager.getIterations(), realVector5, realVector3, realVector9, d2);
            iterationManager.fireIterationPerformedEvent(defaultIterativeLinearSolverEvent);
        } while (!(d2 <= d));
        iterationManager.fireTerminationEvent(defaultIterativeLinearSolverEvent);
        return realVector4;
    }
}

