/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.PivotingStrategyInterface;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.core.RandomProviderDefaultState;
import org.apache.commons.rng.simple.RandomSource;

public class RandomPivotingStrategy
implements PivotingStrategyInterface,
Serializable {
    private static final long serialVersionUID = 20160517L;
    private final RandomSource randomSource;
    private transient RestorableUniformRandomProvider random;

    public RandomPivotingStrategy(RandomSource randomSource, long l) {
        this.randomSource = randomSource;
        this.random = RandomSource.create(randomSource, l, new Object[0]);
    }

    @Override
    public int pivotIndex(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        MathArrays.verifyValues(dArray, n, n2 - n);
        return n + this.random.nextInt(n2 - n - 1);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(((RandomProviderDefaultState)this.random.saveState()).getState());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.random = RandomSource.create(this.randomSource);
        RandomProviderDefaultState randomProviderDefaultState = new RandomProviderDefaultState((byte[])objectInputStream.readObject());
        this.random.restoreState(randomProviderDefaultState);
    }
}

