/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.complex;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.numbers.core.Precision;

public final class Complex
implements Serializable {
    public static final Complex I = new Complex(0.0, 1.0);
    public static final Complex INF = new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Complex ONE = new Complex(1.0, 0.0);
    public static final Complex ZERO = new Complex(0.0, 0.0);
    private static final Complex NAN = new Complex(Double.NaN, Double.NaN);
    private static final long serialVersionUID = 20180201L;
    private static final String FORMAT_START = "(";
    private static final String FORMAT_END = ")";
    private static final String FORMAT_SEP = ",";
    private final double imaginary;
    private final double real;

    private Complex(double d, double d2) {
        this.real = d;
        this.imaginary = d2;
    }

    public static Complex ofCartesian(double d, double d2) {
        return new Complex(d, d2);
    }

    public static Complex ofReal(double d) {
        return new Complex(d, 0.0);
    }

    public static Complex ofPolar(double d, double d2) {
        Complex.checkNotNegative(d);
        return new Complex(d * Math.cos(d2), d * Math.sin(d2));
    }

    public static Complex ofCis(double d) {
        return new Complex(Math.cos(d), Math.sin(d));
    }

    public static Complex parse(String string) {
        double d;
        double d2;
        int n = string.length();
        int n2 = string.indexOf(FORMAT_START);
        if (n2 != 0) {
            throw new ComplexParsingException("Expected start string: (");
        }
        int n3 = string.indexOf(FORMAT_END);
        if (n3 != n - 1) {
            throw new ComplexParsingException("Expected end string: )");
        }
        String[] stringArray = string.substring(1, string.length() - 1).split(FORMAT_SEP);
        if (stringArray.length != 2) {
            throw new ComplexParsingException("Incorrect number of parts: Expected 2 but was " + stringArray.length + " (separator is ',')");
        }
        try {
            d2 = Double.parseDouble(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ComplexParsingException("Could not parse real part" + stringArray[0]);
        }
        try {
            d = Double.parseDouble(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ComplexParsingException("Could not parse imaginary part" + stringArray[1]);
        }
        return Complex.ofCartesian(d2, d);
    }

    public boolean isNaN() {
        return Double.isNaN(this.real) || Double.isNaN(this.imaginary);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.real) || Double.isInfinite(this.imaginary);
    }

    public Complex proj() {
        if (Double.isInfinite(this.real) || Double.isInfinite(this.imaginary)) {
            return new Complex(Double.POSITIVE_INFINITY, 0.0);
        }
        return this;
    }

    public double abs() {
        if (Math.abs(this.real) < Math.abs(this.imaginary)) {
            double d = this.real / this.imaginary;
            return Math.abs(this.imaginary) * Math.sqrt(1.0 + d * d);
        }
        if (this.real == 0.0) {
            return Math.abs(this.imaginary);
        }
        double d = this.imaginary / this.real;
        return Math.abs(this.real) * Math.sqrt(1.0 + d * d);
    }

    public Complex add(Complex complex) {
        return new Complex(this.real + complex.real, this.imaginary + complex.imaginary);
    }

    public Complex add(double d) {
        return new Complex(this.real + d, this.imaginary);
    }

    public Complex conjugate() {
        return new Complex(this.real, -this.imaginary);
    }

    public Complex conj() {
        return this.conjugate();
    }

    public Complex divide(Complex complex) {
        double d = this.real;
        double d2 = this.imaginary;
        double d3 = complex.getReal();
        double d4 = complex.getImaginary();
        int n = 0;
        double d5 = Math.log(Math.max(Math.abs(d3), Math.abs(d4))) / Math.log(2.0);
        if (!Double.isInfinite(d5)) {
            n = (int)d5;
            d3 = Math.scalb(d3, -n);
            d4 = Math.scalb(d4, -n);
        }
        double d6 = d3 * d3 + d4 * d4;
        double d7 = Math.scalb((d * d3 + d2 * d4) / d6, -n);
        double d8 = Math.scalb((d2 * d3 - d * d4) / d6, -n);
        if (Double.isNaN(d7) && Double.isNaN(d8)) {
            if (!(d6 != 0.0 || Double.isNaN(d) && Double.isNaN(d2))) {
                d7 = Math.copySign(Double.POSITIVE_INFINITY, d3) * d;
                d8 = Math.copySign(Double.POSITIVE_INFINITY, d3) * d2;
            } else if (Double.isInfinite(d) && Double.isInfinite(d2) && !Double.isInfinite(d3) && !Double.isInfinite(d4)) {
                d = Math.copySign(Double.isInfinite(d) ? 1.0 : 0.0, d);
                d2 = Math.copySign(Double.isInfinite(d2) ? 1.0 : 0.0, d2);
                d7 = Double.POSITIVE_INFINITY * (d * d3 + d2 * d4);
                d8 = Double.POSITIVE_INFINITY * (d2 * d3 - d * d4);
            } else if (Double.isInfinite(d5) && !Double.isInfinite(d) && !Double.isInfinite(d2)) {
                d3 = Math.copySign(Double.isInfinite(d3) ? 1.0 : 0.0, d3);
                d4 = Math.copySign(Double.isInfinite(d4) ? 1.0 : 0.0, d4);
                d7 = 0.0 * (d * d3 + d2 * d4);
                d8 = 0.0 * (d2 * d3 - d * d4);
            }
        }
        return new Complex(d7, d8);
    }

    public Complex divide(double d) {
        return this.divide(new Complex(d, 0.0));
    }

    public Complex reciprocal() {
        if (Math.abs(this.real) < Math.abs(this.imaginary)) {
            double d = this.real / this.imaginary;
            double d2 = 1.0 / (this.real * d + this.imaginary);
            double d3 = 0.0;
            if (d != 0.0 && d2 != 0.0) {
                d3 = d2 * d;
            }
            return new Complex(d3, -d2);
        }
        double d = this.imaginary / this.real;
        double d4 = 1.0 / (this.imaginary * d + this.real);
        double d5 = 0.0;
        if (d != 0.0 && d4 != 0.0) {
            d5 = d4 * d;
        }
        return new Complex(d4, -d5);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            return Complex.equals(this.real, complex.real) && Complex.equals(this.imaginary, complex.imaginary);
        }
        return false;
    }

    public static boolean equals(Complex complex, Complex complex2, int n) {
        return Precision.equals(complex.real, complex2.real, n) && Precision.equals(complex.imaginary, complex2.imaginary, n);
    }

    public static boolean equals(Complex complex, Complex complex2) {
        return Complex.equals(complex, complex2, 1);
    }

    public static boolean equals(Complex complex, Complex complex2, double d) {
        return Precision.equals(complex.real, complex2.real, d) && Precision.equals(complex.imaginary, complex2.imaginary, d);
    }

    public static boolean equalsWithRelativeTolerance(Complex complex, Complex complex2, double d) {
        return Precision.equalsWithRelativeTolerance(complex.real, complex2.real, d) && Precision.equalsWithRelativeTolerance(complex.imaginary, complex2.imaginary, d);
    }

    public int hashCode() {
        if (Double.isNaN(this.real) || Double.isNaN(this.imaginary)) {
            return 7;
        }
        return 37 * (17 * this.hash(this.imaginary) + this.hash(this.real));
    }

    private int hash(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    public double getImaginary() {
        return this.imaginary;
    }

    public double imag() {
        return this.imaginary;
    }

    public double getReal() {
        return this.real;
    }

    public double real() {
        return this.real;
    }

    public Complex multiply(Complex complex) {
        double d = this.real;
        double d2 = this.imaginary;
        double d3 = complex.getReal();
        double d4 = complex.getImaginary();
        double d5 = d * d3;
        double d6 = d2 * d4;
        double d7 = d * d4;
        double d8 = d2 * d3;
        double d9 = d5 - d6;
        double d10 = d7 + d8;
        if (Double.isNaN(d) && Double.isNaN(d2)) {
            boolean bl = false;
            if (Double.isInfinite(d) || Double.isInfinite(d2)) {
                d = Math.copySign(Double.isInfinite(d) ? 1.0 : 0.0, d);
                d2 = Math.copySign(Double.isInfinite(d) ? 1.0 : 0.0, d);
                if (Double.isNaN(d3)) {
                    d3 = Math.copySign(0.0, d3);
                }
                if (Double.isNaN(d4)) {
                    d4 = Math.copySign(0.0, d4);
                }
                bl = true;
            }
            if (Double.isInfinite(d3) || Double.isInfinite(d4)) {
                d3 = Math.copySign(Double.isInfinite(d3) ? 1.0 : 0.0, d3);
                d4 = Math.copySign(Double.isInfinite(d4) ? 1.0 : 0.0, d4);
                if (Double.isNaN(d)) {
                    d = Math.copySign(0.0, d);
                }
                if (Double.isNaN(d2)) {
                    d2 = Math.copySign(0.0, d2);
                }
                bl = true;
            }
            if (!bl && (Double.isInfinite(d5) || Double.isInfinite(d6) || Double.isInfinite(d7) || Double.isInfinite(d8))) {
                if (Double.isNaN(d)) {
                    d = Math.copySign(0.0, d);
                }
                if (Double.isNaN(d2)) {
                    d2 = Math.copySign(0.0, d2);
                }
                if (Double.isNaN(d3)) {
                    d3 = Math.copySign(0.0, d3);
                }
                if (Double.isNaN(d4)) {
                    d4 = Math.copySign(0.0, d4);
                }
                bl = true;
            }
            if (bl) {
                d9 = Double.POSITIVE_INFINITY * (d * d3 - d2 * d4);
                d10 = Double.POSITIVE_INFINITY * (d * d4 + d2 * d3);
            }
        }
        return new Complex(d9, d10);
    }

    public Complex multiply(int n) {
        return new Complex(this.real * (double)n, this.imaginary * (double)n);
    }

    public Complex multiply(double d) {
        return new Complex(this.real * d, this.imaginary * d);
    }

    public Complex negate() {
        return new Complex(-this.real, -this.imaginary);
    }

    public Complex subtract(Complex complex) {
        return new Complex(this.real - complex.real, this.imaginary - complex.imaginary);
    }

    public Complex subtract(double d) {
        return new Complex(this.real - d, this.imaginary);
    }

    public Complex acos() {
        if (this.real == 0.0 && Double.isNaN(this.imaginary)) {
            return new Complex(1.5707963267948966, Double.NaN);
        }
        if (Complex.neitherInfiniteNorZeroNorNaN(this.real) && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(1.5707963267948966, Double.NEGATIVE_INFINITY);
        }
        if (this.real == Double.NEGATIVE_INFINITY && this.imaginary == 1.0) {
            return new Complex(Math.PI, Double.NEGATIVE_INFINITY);
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == 1.0) {
            return new Complex(0.0, Double.NEGATIVE_INFINITY);
        }
        if (this.real == Double.NEGATIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(2.356194490192345, Double.NEGATIVE_INFINITY);
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(0.7853981633974483, Double.NEGATIVE_INFINITY);
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.NaN, Double.POSITIVE_INFINITY);
        }
        if (this.real == Double.NEGATIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.NaN, Double.NEGATIVE_INFINITY);
        }
        if (Double.isNaN(this.real) && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.NaN, Double.NEGATIVE_INFINITY);
        }
        return this.add(this.sqrt1z().multiply(I)).log().multiply(I.negate());
    }

    public Complex asin() {
        return this.sqrt1z().add(this.multiply(I)).log().multiply(I.negate());
    }

    public Complex atan() {
        return this.add(I).divide(I.subtract(this)).log().multiply(I.multiply(0.5));
    }

    public Complex asinh() {
        if (Complex.neitherInfiniteNorZeroNorNaN(this.real) && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, 1.5707963267948966);
        }
        if (this.real == Double.POSITIVE_INFINITY && !Double.isInfinite(this.imaginary) && !Double.isNaN(this.imaginary)) {
            return new Complex(Double.POSITIVE_INFINITY, 0.0);
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, 0.7853981633974483);
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        if (Double.isNaN(this.real) && this.imaginary == 0.0) {
            return new Complex(Double.NaN, 0.0);
        }
        if (Double.isNaN(this.real) && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        return this.square().add(ONE).sqrt().add(this).log();
    }

    public Complex atanh() {
        if (this.real == 0.0 && Double.isNaN(this.imaginary)) {
            return new Complex(0.0, Double.NaN);
        }
        if (Complex.neitherInfiniteNorZeroNorNaN(this.real) && this.imaginary == 0.0) {
            return new Complex(Double.POSITIVE_INFINITY, 0.0);
        }
        if (Complex.neitherInfiniteNorZeroNorNaN(this.real) && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(0.0, 1.5707963267948966);
        }
        if (this.real == Double.POSITIVE_INFINITY && Complex.neitherInfiniteNorZeroNorNaN(this.imaginary)) {
            return new Complex(0.0, 1.5707963267948966);
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(0.0, 1.5707963267948966);
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(0.0, Double.NaN);
        }
        if (Double.isNaN(this.real) && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(0.0, 1.5707963267948966);
        }
        return this.add(ONE).divide(ONE.subtract(this)).log().multiply(0.5);
    }

    public Complex acosh() {
        return this.square().subtract(ONE).sqrt().add(this).log();
    }

    public Complex square() {
        return this.multiply(this);
    }

    public Complex cos() {
        return new Complex(Math.cos(this.real) * Math.cosh(this.imaginary), -Math.sin(this.real) * Math.sinh(this.imaginary));
    }

    public Complex cosh() {
        if (this.real == 0.0 && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.NaN, 0.0);
        }
        if (this.real == 0.0 && Double.isNaN(this.imaginary)) {
            return new Complex(Double.NaN, 0.0);
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == 0.0) {
            return new Complex(Double.POSITIVE_INFINITY, 0.0);
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        if (Double.isNaN(this.real) && this.imaginary == 0.0) {
            return new Complex(Double.NaN, 0.0);
        }
        return new Complex(Math.cosh(this.real) * Math.cos(this.imaginary), Math.sinh(this.real) * Math.sin(this.imaginary));
    }

    public Complex exp() {
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == 0.0) {
            return new Complex(Double.POSITIVE_INFINITY, 0.0);
        }
        if (this.real == Double.NEGATIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return ZERO;
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        if (this.real == Double.NEGATIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return ZERO;
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        if (Double.isNaN(this.real) && this.imaginary == 0.0) {
            return new Complex(Double.NaN, 0.0);
        }
        double d = Math.exp(this.real);
        return new Complex(d * Math.cos(this.imaginary), d * Math.sin(this.imaginary));
    }

    public Complex log() {
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, 0.7853981633974483);
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        if (Double.isNaN(this.real) && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        return new Complex(Math.log(this.abs()), Math.atan2(this.imaginary, this.real));
    }

    public Complex log10() {
        return new Complex(Math.log(this.abs()) / Math.log(10.0), Math.atan2(this.imaginary, this.real));
    }

    public Complex pow(Complex complex) {
        if (this.real == 0.0 && this.imaginary == 0.0) {
            if (complex.real > 0.0 && complex.imaginary == 0.0) {
                return ZERO;
            }
            return NAN;
        }
        return this.log().multiply(complex).exp();
    }

    public Complex pow(double d) {
        if (this.real == 0.0 && this.imaginary == 0.0) {
            if (d > 0.0) {
                return ZERO;
            }
            return NAN;
        }
        return this.log().multiply(d).exp();
    }

    public Complex sin() {
        return new Complex(Math.sin(this.real) * Math.cosh(this.imaginary), Math.cos(this.real) * Math.sinh(this.imaginary));
    }

    public Complex sinh() {
        if (this.real == 0.0 && this.imaginary == 0.0) {
            return ZERO;
        }
        if (this.real == 0.0 && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(0.0, Double.NaN);
        }
        if (this.real == 0.0 && Double.isNaN(this.imaginary)) {
            return new Complex(0.0, Double.NaN);
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == 0.0) {
            return new Complex(Double.POSITIVE_INFINITY, 0.0);
        }
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        if (Double.isNaN(this.real) && this.imaginary == 0.0) {
            return new Complex(Double.NaN, 0.0);
        }
        return new Complex(Math.sinh(this.real) * Math.cos(this.imaginary), Math.cosh(this.real) * Math.sin(this.imaginary));
    }

    public Complex sqrt() {
        if (this.real == 0.0 && this.imaginary == 0.0) {
            return ZERO;
        }
        if (Complex.neitherInfiniteNorZeroNorNaN(this.real) && this.imaginary == Double.POSITIVE_INFINITY) {
            return new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        if (this.real == Double.NEGATIVE_INFINITY && Complex.neitherInfiniteNorZeroNorNaN(this.imaginary)) {
            return new Complex(0.0, Double.NaN);
        }
        if (this.real == Double.NEGATIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.NaN, Double.POSITIVE_INFINITY);
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return new Complex(Double.POSITIVE_INFINITY, Double.NaN);
        }
        double d = Math.sqrt((Math.abs(this.real) + this.abs()) / 2.0);
        if (this.real >= 0.0) {
            return new Complex(d, this.imaginary / (2.0 * d));
        }
        return new Complex(Math.abs(this.imaginary) / (2.0 * d), Math.copySign(1.0, this.imaginary) * d);
    }

    private Complex sqrt1z() {
        return ONE.subtract(this.square()).sqrt();
    }

    public Complex tan() {
        if (this.imaginary > 20.0) {
            return ONE;
        }
        if (this.imaginary < -20.0) {
            return new Complex(0.0, -1.0);
        }
        double d = 2.0 * this.real;
        double d2 = 2.0 * this.imaginary;
        double d3 = Math.cos(d) + Math.cosh(d2);
        return new Complex(Math.sin(d) / d3, Math.sinh(d2) / d3);
    }

    public Complex tanh() {
        if (this.real == Double.POSITIVE_INFINITY && this.imaginary == Double.POSITIVE_INFINITY) {
            return ONE;
        }
        if (this.real == Double.POSITIVE_INFINITY && Double.isNaN(this.imaginary)) {
            return ONE;
        }
        if (Double.isNaN(this.real) && this.imaginary == 0.0) {
            return new Complex(Double.NaN, 0.0);
        }
        double d = 2.0 * this.real;
        double d2 = 2.0 * this.imaginary;
        double d3 = Math.cosh(d) + Math.cos(d2);
        return new Complex(Math.sinh(d) / d3, Math.sin(d2) / d3);
    }

    public double getArgument() {
        return Math.atan2(this.imaginary, this.real);
    }

    public double arg() {
        return this.getArgument();
    }

    public List<Complex> nthRoot(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("cannot compute zeroth root");
        }
        ArrayList<Complex> arrayList = new ArrayList<Complex>();
        double d = Math.pow(this.abs(), 1.0 / (double)n);
        double d2 = this.getArgument() / (double)n;
        double d3 = Math.PI * 2 / (double)n;
        double d4 = d2;
        for (int i = 0; i < Math.abs(n); ++i) {
            double d5 = d * Math.cos(d4);
            double d6 = d * Math.sin(d4);
            arrayList.add(new Complex(d5, d6));
            d4 += d3;
        }
        return arrayList;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(FORMAT_START).append(this.real).append(FORMAT_SEP).append(this.imaginary).append(FORMAT_END);
        return stringBuilder.toString();
    }

    private static void checkNotNegative(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Complex: Non-positive argument");
        }
    }

    private static boolean equals(double d, double d2) {
        return Double.doubleToLongBits(d) == Double.doubleToLongBits(d2);
    }

    private static boolean neitherInfiniteNorZeroNorNaN(double d) {
        return !Double.isNaN(d) && !Double.isInfinite(d) && d != 0.0;
    }

    private static class ComplexParsingException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 20180430L;

        ComplexParsingException(String string) {
            super(string);
        }
    }
}

