/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

@Deprecated
public class BoxMullerGaussianSampler
extends SamplerBase
implements ContinuousSampler {
    private double nextGaussian = Double.NaN;
    private final double mean;
    private final double standardDeviation;
    private final UniformRandomProvider rng;

    public BoxMullerGaussianSampler(UniformRandomProvider uniformRandomProvider, double d, double d2) {
        super(null);
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("standard deviation is not strictly positive: " + d2);
        }
        this.rng = uniformRandomProvider;
        this.mean = d;
        this.standardDeviation = d2;
    }

    @Override
    public double sample() {
        double d;
        if (Double.isNaN(this.nextGaussian)) {
            double d2 = this.rng.nextDouble();
            double d3 = this.rng.nextDouble();
            double d4 = Math.PI * 2 * d2;
            double d5 = Math.sqrt(-2.0 * Math.log(d3));
            d = d5 * Math.cos(d4);
            this.nextGaussian = d5 * Math.sin(d4);
        } else {
            d = this.nextGaussian;
            this.nextGaussian = Double.NaN;
        }
        return this.standardDeviation * d + this.mean;
    }

    @Override
    public String toString() {
        return "Box-Muller Gaussian deviate [" + this.rng.toString() + "]";
    }
}

