/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;

public class RejectionInversionZipfSampler
extends SamplerBase
implements DiscreteSampler {
    private static final double TAYLOR_THRESHOLD = 1.0E-8;
    private static final double F_1_2 = 0.5;
    private static final double F_1_3 = 0.3333333333333333;
    private static final double F_1_4 = 0.25;
    private final int numberOfElements;
    private final double exponent;
    private final double hIntegralX1;
    private final double hIntegralNumberOfElements;
    private final double s;
    private final UniformRandomProvider rng;

    public RejectionInversionZipfSampler(UniformRandomProvider uniformRandomProvider, int n, double d) {
        super(null);
        this.rng = uniformRandomProvider;
        if (n <= 0) {
            throw new IllegalArgumentException("number of elements is not strictly positive: " + n);
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("exponent is not strictly positive: " + d);
        }
        this.numberOfElements = n;
        this.exponent = d;
        this.hIntegralX1 = this.hIntegral(1.5) - 1.0;
        this.hIntegralNumberOfElements = this.hIntegral((double)n + 0.5);
        this.s = 2.0 - this.hIntegralInverse(this.hIntegral(2.5) - this.h(2.0));
    }

    @Override
    public int sample() {
        double d;
        double d2;
        int n;
        do {
            if ((n = (int)((d2 = this.hIntegralInverse(d = this.hIntegralNumberOfElements + this.rng.nextDouble() * (this.hIntegralX1 - this.hIntegralNumberOfElements))) + 0.5)) < 1) {
                n = 1;
                continue;
            }
            if (n <= this.numberOfElements) continue;
            n = this.numberOfElements;
        } while (!((double)n - d2 <= this.s) && !(d >= this.hIntegral((double)n + 0.5) - this.h(n)));
        return n;
    }

    @Override
    public String toString() {
        return "Rejection inversion Zipf deviate [" + this.rng.toString() + "]";
    }

    private double hIntegral(double d) {
        double d2 = Math.log(d);
        return RejectionInversionZipfSampler.helper2((1.0 - this.exponent) * d2) * d2;
    }

    private double h(double d) {
        return Math.exp(-this.exponent * Math.log(d));
    }

    private double hIntegralInverse(double d) {
        double d2 = d * (1.0 - this.exponent);
        if (d2 < -1.0) {
            d2 = -1.0;
        }
        return Math.exp(RejectionInversionZipfSampler.helper1(d2) * d);
    }

    private static double helper1(double d) {
        if (Math.abs(d) > 1.0E-8) {
            return Math.log1p(d) / d;
        }
        return 1.0 - d * (0.5 - d * (0.3333333333333333 - 0.25 * d));
    }

    private static double helper2(double d) {
        if (Math.abs(d) > 1.0E-8) {
            return Math.expm1(d) / d;
        }
        return 1.0 + d * 0.5 * (1.0 + d * 0.3333333333333333 * (1.0 + 0.25 * d));
    }
}

