/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.continuous.common;

import io.virtdata.discrete.common.ThreadSafeHash;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;

public class RealIntDoubleSampler
implements IntToDoubleFunction {
    private final DoubleUnaryOperator f;
    private final boolean clamp;
    private final double clampMax;
    private ThreadSafeHash hash;

    public RealIntDoubleSampler(DoubleUnaryOperator doubleUnaryOperator, boolean bl, boolean bl2, double d) {
        this.f = doubleUnaryOperator;
        if (bl) {
            this.hash = new ThreadSafeHash();
        }
        this.clamp = bl2;
        this.clampMax = d;
    }

    @Override
    public double applyAsDouble(int n) {
        long l = n;
        if (this.hash != null) {
            l = this.hash.applyAsLong(l);
        }
        double d = (double)l / 9.223372036854776E18;
        double d2 = this.clamp ? Double.min(this.clampMax, this.f.applyAsDouble(d)) : this.f.applyAsDouble(d);
        return d2;
    }
}

