/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.discrete.long_int;

import io.virtdata.discrete.common.DiscreteLongIntSampler;
import io.virtdata.discrete.common.IntegerDistributionICDSource;
import io.virtdata.discrete.common.InterpolatingLongIntSampler;
import io.virtdata.shaded.oac.statistics.distribution.DiscreteDistribution;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.LongToIntFunction;

public class LongToIntDiscreteCurve
implements LongToIntFunction {
    private DiscreteDistribution distribution;
    private LongToIntFunction function;
    public static final String COMPUTE = "compute";
    public static final String INTERPOLATE = "interpolate";
    public static final String MAP = "map";
    public static final String HASH = "hash";
    private static final HashSet<String> validModifiers = new HashSet<String>(){
        {
            this.add(LongToIntDiscreteCurve.COMPUTE);
            this.add(LongToIntDiscreteCurve.INTERPOLATE);
            this.add(LongToIntDiscreteCurve.MAP);
            this.add(LongToIntDiscreteCurve.HASH);
        }
    };

    public LongToIntDiscreteCurve(DiscreteDistribution discreteDistribution, String ... stringArray) {
        this.distribution = discreteDistribution;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        IntegerDistributionICDSource integerDistributionICDSource = new IntegerDistributionICDSource(discreteDistribution);
        if (hashSet.contains(HASH) && hashSet.contains(MAP)) {
            throw new RuntimeException("mods must not contain both hash and map.");
        }
        if (hashSet.contains(INTERPOLATE) && hashSet.contains(COMPUTE)) {
            throw new RuntimeException("mods must not contain both interpolate and compute.");
        }
        for (String string : stringArray) {
            if (validModifiers.contains(string)) continue;
            throw new RuntimeException("modifier '" + string + "' is not a valid modifier. Use one of " + validModifiers.toString() + " instead.");
        }
        boolean bl = hashSet.contains(HASH) || !hashSet.contains(MAP);
        int n = hashSet.contains(INTERPOLATE) || !hashSet.contains(COMPUTE) ? 1 : 0;
        this.function = n != 0 ? new InterpolatingLongIntSampler(integerDistributionICDSource, 1000, bl) : new DiscreteLongIntSampler(integerDistributionICDSource, bl);
    }

    @Override
    public int applyAsInt(long l) {
        return this.function.applyAsInt(l);
    }
}

