/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive.rank;

import io.virtdata.shaded.oac.statistics.descriptive.AbstractStorelessUnivariateStatistic;
import io.virtdata.shaded.oac.statistics.descriptive.StorelessUnivariateStatistic;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math4.analysis.UnivariateFunction;
import org.apache.commons.math4.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math4.analysis.interpolation.NevilleInterpolator;
import org.apache.commons.math4.analysis.interpolation.UnivariateInterpolator;
import org.apache.commons.math4.exception.InsufficientDataException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;
import org.apache.commons.numbers.core.Precision;

public class PSquarePercentile
extends AbstractStorelessUnivariateStatistic
implements StorelessUnivariateStatistic,
Serializable {
    private static final int PSQUARE_CONSTANT = 5;
    private static final double DEFAULT_QUANTILE_DESIRED = 50.0;
    private static final long serialVersionUID = 20150412L;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00.00");
    private final List<Double> initialFive = new FixedCapacityList<Double>(5);
    private final double quantile;
    private transient double lastObservation;
    private PSquareMarkers markers = null;
    private double pValue = Double.NaN;
    private long countOfObservations;

    public PSquarePercentile(double d) {
        if (d > 100.0 || d < 0.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_RANGE, (Number)d, 0, 100);
        }
        this.quantile = d / 100.0;
    }

    PSquarePercentile() {
        this(50.0);
    }

    @Override
    public int hashCode() {
        double d = this.getResult();
        d = Double.isNaN(d) ? 37.0 : d;
        double d2 = this.markers == null ? 0.0 : (double)this.markers.hashCode();
        double[] dArray = new double[]{d, this.quantile, d2, this.countOfObservations};
        return Arrays.hashCode(dArray);
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof PSquarePercentile) {
            PSquarePercentile pSquarePercentile = (PSquarePercentile)object;
            boolean bl2 = this.markers != null && pSquarePercentile.markers != null;
            boolean bl3 = this.markers == null && pSquarePercentile.markers == null;
            bl = bl2 ? this.markers.equals(pSquarePercentile.markers) : bl3;
            bl = bl && this.getN() == pSquarePercentile.getN();
        }
        return bl;
    }

    @Override
    public void increment(double d) {
        ++this.countOfObservations;
        this.lastObservation = d;
        if (this.markers == null) {
            if (this.initialFive.add(d)) {
                Collections.sort(this.initialFive);
                this.pValue = this.initialFive.get((int)(this.quantile * (double)(this.initialFive.size() - 1)));
                return;
            }
            this.markers = PSquarePercentile.newMarkers(this.initialFive, this.quantile);
        }
        this.pValue = this.markers.processDataPoint(d);
    }

    public String toString() {
        if (this.markers == null) {
            return String.format("obs=%s pValue=%s", DECIMAL_FORMAT.format(this.lastObservation), DECIMAL_FORMAT.format(this.pValue));
        }
        return String.format("obs=%s markers=%s", DECIMAL_FORMAT.format(this.lastObservation), this.markers.toString());
    }

    @Override
    public long getN() {
        return this.countOfObservations;
    }

    @Override
    public StorelessUnivariateStatistic copy() {
        PSquarePercentile pSquarePercentile = new PSquarePercentile(100.0 * this.quantile);
        if (this.markers != null) {
            pSquarePercentile.markers = (PSquareMarkers)this.markers.clone();
        }
        pSquarePercentile.countOfObservations = this.countOfObservations;
        pSquarePercentile.pValue = this.pValue;
        pSquarePercentile.initialFive.clear();
        pSquarePercentile.initialFive.addAll(this.initialFive);
        return pSquarePercentile;
    }

    public double quantile() {
        return this.quantile;
    }

    @Override
    public void clear() {
        this.markers = null;
        this.initialFive.clear();
        this.countOfObservations = 0L;
        this.pValue = Double.NaN;
    }

    @Override
    public double getResult() {
        if (Double.compare(this.quantile, 1.0) == 0) {
            this.pValue = this.maximum();
        } else if (Double.compare(this.quantile, 0.0) == 0) {
            this.pValue = this.minimum();
        }
        return this.pValue;
    }

    private double maximum() {
        double d = Double.NaN;
        if (this.markers != null) {
            d = this.markers.height(5);
        } else if (!this.initialFive.isEmpty()) {
            d = this.initialFive.get(this.initialFive.size() - 1);
        }
        return d;
    }

    private double minimum() {
        double d = Double.NaN;
        if (this.markers != null) {
            d = this.markers.height(1);
        } else if (!this.initialFive.isEmpty()) {
            d = this.initialFive.get(0);
        }
        return d;
    }

    public static PSquareMarkers newMarkers(List<Double> list, double d) {
        return new Markers(list, d);
    }

    protected static interface PSquareMarkers
    extends Cloneable {
        public double getPercentileValue();

        public Object clone();

        public double height(int var1);

        public double processDataPoint(double var1);

        public double estimate(int var1);
    }

    private static class FixedCapacityList<E>
    extends ArrayList<E>
    implements Serializable {
        private static final long serialVersionUID = 2283952083075725479L;
        private final int capacity;

        FixedCapacityList(int n) {
            super(n);
            this.capacity = n;
        }

        @Override
        public boolean add(E e) {
            return this.size() < this.capacity ? super.add(e) : false;
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            boolean bl = collection != null && collection.size() + this.size() <= this.capacity;
            return bl ? super.addAll(collection) : false;
        }
    }

    private static class Marker
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -3575879478288538431L;
        private int index;
        private double intMarkerPosition;
        private double desiredMarkerPosition;
        private double markerHeight;
        private double desiredMarkerIncrement;
        private transient Marker next;
        private transient Marker previous;
        private final UnivariateInterpolator nonLinear = new NevilleInterpolator();
        private transient UnivariateInterpolator linear = new LinearInterpolator();

        private Marker() {
            this.next = this.previous = this;
        }

        private Marker(double d, double d2, double d3, double d4) {
            this();
            this.markerHeight = d;
            this.desiredMarkerPosition = d2;
            this.desiredMarkerIncrement = d3;
            this.intMarkerPosition = d4;
        }

        private Marker previous(Marker marker) {
            MathUtils.checkNotNull(marker);
            this.previous = marker;
            return this;
        }

        private Marker next(Marker marker) {
            MathUtils.checkNotNull(marker);
            this.next = marker;
            return this;
        }

        private Marker index(int n) {
            this.index = n;
            return this;
        }

        private void updateDesiredPosition() {
            this.desiredMarkerPosition += this.desiredMarkerIncrement;
        }

        private void incrementPosition(int n) {
            this.intMarkerPosition += (double)n;
        }

        private double difference() {
            return this.desiredMarkerPosition - this.intMarkerPosition;
        }

        private double estimate() {
            boolean bl;
            double d = this.difference();
            boolean bl2 = this.next.intMarkerPosition - this.intMarkerPosition > 1.0;
            boolean bl3 = bl = this.previous.intMarkerPosition - this.intMarkerPosition < -1.0;
            if (d >= 1.0 && bl2 || d <= -1.0 && bl) {
                int n = d >= 0.0 ? 1 : -1;
                double[] dArray = new double[]{this.previous.intMarkerPosition, this.intMarkerPosition, this.next.intMarkerPosition};
                double[] dArray2 = new double[]{this.previous.markerHeight, this.markerHeight, this.next.markerHeight};
                double d2 = this.intMarkerPosition + (double)n;
                UnivariateFunction univariateFunction = this.nonLinear.interpolate(dArray, dArray2);
                this.markerHeight = univariateFunction.value(d2);
                if (this.isEstimateBad(dArray2, this.markerHeight)) {
                    int n2 = d2 - dArray[1] > 0.0 ? 1 : -1;
                    double[] dArray3 = new double[]{dArray[1], dArray[1 + n2]};
                    double[] dArray4 = new double[]{dArray2[1], dArray2[1 + n2]};
                    MathArrays.sortInPlace(dArray3, new double[][]{dArray4});
                    univariateFunction = this.linear.interpolate(dArray3, dArray4);
                    this.markerHeight = univariateFunction.value(d2);
                }
                this.incrementPosition(n);
            }
            return this.markerHeight;
        }

        private boolean isEstimateBad(double[] dArray, double d) {
            return d <= dArray[0] || d >= dArray[2];
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                bl = true;
            } else if (object instanceof Marker) {
                Marker marker = (Marker)object;
                bl = Double.compare(this.markerHeight, marker.markerHeight) == 0;
                bl = bl && Double.compare(this.intMarkerPosition, marker.intMarkerPosition) == 0;
                bl = bl && Double.compare(this.desiredMarkerPosition, marker.desiredMarkerPosition) == 0;
                bl = bl && Double.compare(this.desiredMarkerIncrement, marker.desiredMarkerIncrement) == 0;
                bl = bl && this.next.index == marker.next.index;
                bl = bl && this.previous.index == marker.previous.index;
            }
            return bl;
        }

        public int hashCode() {
            return Arrays.hashCode(new double[]{this.markerHeight, this.intMarkerPosition, this.desiredMarkerIncrement, this.desiredMarkerPosition, this.previous.index, this.next.index});
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            this.previous = this.next = this;
            this.linear = new LinearInterpolator();
        }

        public Object clone() {
            return new Marker(this.markerHeight, this.desiredMarkerPosition, this.desiredMarkerIncrement, this.intMarkerPosition);
        }

        public String toString() {
            return String.format("index=%.0f,n=%.0f,np=%.2f,q=%.2f,dn=%.2f,prev=%d,next=%d", this.index, Precision.round(this.intMarkerPosition, 0), Precision.round(this.desiredMarkerPosition, 2), Precision.round(this.markerHeight, 2), Precision.round(this.desiredMarkerIncrement, 2), this.previous.index, this.next.index);
        }
    }

    private static class Markers
    implements PSquareMarkers,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final int LOW = 2;
        private static final int HIGH = 4;
        private final Marker[] markerArray;
        private transient int k = -1;

        private Markers(Marker[] markerArray) {
            MathUtils.checkNotNull(markerArray);
            this.markerArray = markerArray;
            for (int i = 1; i < 5; ++i) {
                this.markerArray[i].previous(this.markerArray[i - 1]).next(this.markerArray[i + 1]).index(i);
            }
            this.markerArray[0].previous(this.markerArray[0]).next(this.markerArray[1]).index(0);
            this.markerArray[5].previous(this.markerArray[4]).next(this.markerArray[5]).index(5);
        }

        private Markers(List<Double> list, double d) {
            this(Markers.createMarkerArray(list, d));
        }

        private static Marker[] createMarkerArray(List<Double> list, double d) {
            int n;
            int n2 = n = list == null ? -1 : list.size();
            if (n < 5) {
                throw new InsufficientDataException(LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, n, 5);
            }
            Collections.sort(list);
            return new Marker[]{new Marker(), new Marker(list.get(0), 1.0, 0.0, 1.0), new Marker(list.get(1), 1.0 + 2.0 * d, d / 2.0, 2.0), new Marker(list.get(2), 1.0 + 4.0 * d, d, 3.0), new Marker(list.get(3), 3.0 + 2.0 * d, (1.0 + d) / 2.0, 4.0), new Marker(list.get(4), 5.0, 1.0, 5.0)};
        }

        public int hashCode() {
            return Arrays.deepHashCode(this.markerArray);
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                bl = true;
            } else if (object instanceof Markers) {
                Markers markers = (Markers)object;
                bl = Arrays.deepEquals(this.markerArray, markers.markerArray);
            }
            return bl;
        }

        @Override
        public double processDataPoint(double d) {
            int n = this.findCellAndUpdateMinMax(d);
            this.incrementPositions(1, n + 1, 5);
            this.updateDesiredPositions();
            this.adjustHeightsOfMarkers();
            return this.getPercentileValue();
        }

        @Override
        public double getPercentileValue() {
            return this.height(3);
        }

        private int findCellAndUpdateMinMax(double d) {
            this.k = -1;
            if (d < this.height(1)) {
                this.markerArray[1].markerHeight = d;
                this.k = 1;
            } else if (d < this.height(2)) {
                this.k = 1;
            } else if (d < this.height(3)) {
                this.k = 2;
            } else if (d < this.height(4)) {
                this.k = 3;
            } else if (d <= this.height(5)) {
                this.k = 4;
            } else {
                this.markerArray[5].markerHeight = d;
                this.k = 4;
            }
            return this.k;
        }

        private void adjustHeightsOfMarkers() {
            for (int i = 2; i <= 4; ++i) {
                this.estimate(i);
            }
        }

        @Override
        public double estimate(int n) {
            if (n < 2 || n > 4) {
                throw new OutOfRangeException(n, (Number)2, 4);
            }
            return this.markerArray[n].estimate();
        }

        private void incrementPositions(int n, int n2, int n3) {
            for (int i = n2; i <= n3; ++i) {
                this.markerArray[i].incrementPosition(n);
            }
        }

        private void updateDesiredPositions() {
            for (int i = 1; i < this.markerArray.length; ++i) {
                this.markerArray[i].updateDesiredPosition();
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            for (int i = 1; i < 5; ++i) {
                this.markerArray[i].previous(this.markerArray[i - 1]).next(this.markerArray[i + 1]).index(i);
            }
            this.markerArray[0].previous(this.markerArray[0]).next(this.markerArray[1]).index(0);
            this.markerArray[5].previous(this.markerArray[4]).next(this.markerArray[5]).index(5);
        }

        @Override
        public double height(int n) {
            if (n >= this.markerArray.length || n <= 0) {
                throw new OutOfRangeException(n, (Number)1, this.markerArray.length);
            }
            return this.markerArray[n].markerHeight;
        }

        @Override
        public Object clone() {
            return new Markers(new Marker[]{new Marker(), (Marker)this.markerArray[1].clone(), (Marker)this.markerArray[2].clone(), (Marker)this.markerArray[3].clone(), (Marker)this.markerArray[4].clone(), (Marker)this.markerArray[5].clone()});
        }

        public String toString() {
            return String.format("m1=[%s],m2=[%s],m3=[%s],m4=[%s],m5=[%s]", this.markerArray[1].toString(), this.markerArray[2].toString(), this.markerArray[3].toString(), this.markerArray[4].toString(), this.markerArray[5].toString());
        }
    }
}

