/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.descriptive.summary;

import io.virtdata.shaded.oac.statistics.descriptive.AbstractStorelessUnivariateStatistic;
import java.io.Serializable;
import org.apache.commons.math4.exception.MathIllegalArgumentException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.util.MathArrays;
import org.apache.commons.math4.util.MathUtils;

public class SumOfSquares
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 20150412L;
    private long n;
    private double value;

    public SumOfSquares() {
        this.n = 0L;
        this.value = 0.0;
    }

    public SumOfSquares(SumOfSquares sumOfSquares) throws NullArgumentException {
        SumOfSquares.copy(sumOfSquares, this);
    }

    @Override
    public void increment(double d) {
        this.value += d * d;
        ++this.n;
    }

    @Override
    public double getResult() {
        return this.value;
    }

    @Override
    public long getN() {
        return this.n;
    }

    @Override
    public void clear() {
        this.value = 0.0;
        this.n = 0L;
    }

    @Override
    public double evaluate(double[] dArray, int n, int n2) throws MathIllegalArgumentException {
        double d = Double.NaN;
        if (MathArrays.verifyValues(dArray, n, n2, true)) {
            d = 0.0;
            for (int i = n; i < n + n2; ++i) {
                d += dArray[i] * dArray[i];
            }
        }
        return d;
    }

    @Override
    public SumOfSquares copy() {
        SumOfSquares sumOfSquares = new SumOfSquares();
        SumOfSquares.copy(this, sumOfSquares);
        return sumOfSquares;
    }

    public static void copy(SumOfSquares sumOfSquares, SumOfSquares sumOfSquares2) throws NullArgumentException {
        MathUtils.checkNotNull(sumOfSquares);
        MathUtils.checkNotNull(sumOfSquares2);
        sumOfSquares2.n = sumOfSquares.n;
        sumOfSquares2.value = sumOfSquares.value;
    }
}

