/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractContinuousDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;

public class GumbelDistribution
extends AbstractContinuousDistribution {
    private static final double PI_SQUARED_OVER_SIX = 1.6449340668482264;
    private static final double EULER = 0.5778636748954609;
    private final double mu;
    private final double beta;

    public GumbelDistribution(double d, double d2) {
        if (d2 <= 0.0) {
            throw new DistributionException("Number {0} is negative", d2);
        }
        this.beta = d2;
        this.mu = d;
    }

    public double getLocation() {
        return this.mu;
    }

    public double getScale() {
        return this.beta;
    }

    @Override
    public double density(double d) {
        double d2 = (d - this.mu) / this.beta;
        double d3 = Math.exp(-d2);
        return Math.exp(-d2 - d3) / this.beta;
    }

    @Override
    public double cumulativeProbability(double d) {
        double d2 = (d - this.mu) / this.beta;
        return Math.exp(-Math.exp(-d2));
    }

    @Override
    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", d, 0, 1);
        }
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.mu - Math.log(-Math.log(d)) * this.beta;
    }

    @Override
    public double getMean() {
        return this.mu + 0.5778636748954609 * this.beta;
    }

    @Override
    public double getVariance() {
        return 1.6449340668482264 * this.beta * this.beta;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

