/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractDiscreteDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.numbers.combinatorics.BinomialCoefficientDouble;
import org.apache.commons.numbers.combinatorics.LogBinomialCoefficient;
import org.apache.commons.numbers.gamma.RegularizedBeta;

public class PascalDistribution
extends AbstractDiscreteDistribution {
    private final int numberOfSuccesses;
    private final double probabilityOfSuccess;
    private final double logProbabilityOfSuccess;
    private final double log1mProbabilityOfSuccess;

    public PascalDistribution(int n, double d) {
        if (n <= 0) {
            throw new DistributionException("Number {0} is negative", n);
        }
        if (d < 0.0 || d > 1.0) {
            throw new DistributionException("Number {0} is out of range [{1}, {2}]", d, 0, 1);
        }
        this.numberOfSuccesses = n;
        this.probabilityOfSuccess = d;
        this.logProbabilityOfSuccess = Math.log(d);
        this.log1mProbabilityOfSuccess = Math.log1p(-d);
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public double probability(int n) {
        double d = n < 0 ? 0.0 : BinomialCoefficientDouble.value(n + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) * Math.pow(this.probabilityOfSuccess, this.numberOfSuccesses) * Math.pow(1.0 - this.probabilityOfSuccess, n);
        return d;
    }

    @Override
    public double logProbability(int n) {
        double d = n < 0 ? Double.NEGATIVE_INFINITY : LogBinomialCoefficient.value(n + this.numberOfSuccesses - 1, this.numberOfSuccesses - 1) + this.logProbabilityOfSuccess * (double)this.numberOfSuccesses + this.log1mProbabilityOfSuccess * (double)n;
        return d;
    }

    @Override
    public double cumulativeProbability(int n) {
        double d = n < 0 ? 0.0 : RegularizedBeta.value(this.probabilityOfSuccess, this.numberOfSuccesses, (double)n + 1.0);
        return d;
    }

    @Override
    public double getMean() {
        double d = this.getProbabilityOfSuccess();
        double d2 = this.getNumberOfSuccesses();
        return d2 * (1.0 - d) / d;
    }

    @Override
    public double getVariance() {
        double d = this.getProbabilityOfSuccess();
        double d2 = this.getNumberOfSuccesses();
        return d2 * (1.0 - d) / (d * d);
    }

    @Override
    public int getSupportLowerBound() {
        return 0;
    }

    @Override
    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

