/*
 * Decompiled with CFR 0.152.
 */
package io.virtdata.shaded.oac.statistics.distribution;

import io.virtdata.shaded.oac.statistics.distribution.AbstractDiscreteDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DiscreteDistribution;
import io.virtdata.shaded.oac.statistics.distribution.DistributionException;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.RejectionInversionZipfSampler;

public class ZipfDistribution
extends AbstractDiscreteDistribution {
    private final int numberOfElements;
    private final double exponent;
    private final double nthHarmonic;

    public ZipfDistribution(int n, double d) {
        if (n <= 0) {
            throw new DistributionException("Number {0} is negative", n);
        }
        if (d <= 0.0) {
            throw new DistributionException("Number {0} is negative", d);
        }
        this.numberOfElements = n;
        this.exponent = d;
        this.nthHarmonic = this.generalizedHarmonic(n, d);
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public double getExponent() {
        return this.exponent;
    }

    @Override
    public double probability(int n) {
        if (n <= 0 || n > this.numberOfElements) {
            return 0.0;
        }
        return 1.0 / Math.pow(n, this.exponent) / this.nthHarmonic;
    }

    @Override
    public double logProbability(int n) {
        if (n <= 0 || n > this.numberOfElements) {
            return Double.NEGATIVE_INFINITY;
        }
        return -Math.log(n) * this.exponent - Math.log(this.nthHarmonic);
    }

    @Override
    public double cumulativeProbability(int n) {
        if (n <= 0) {
            return 0.0;
        }
        if (n >= this.numberOfElements) {
            return 1.0;
        }
        return this.generalizedHarmonic(n, this.exponent) / this.nthHarmonic;
    }

    @Override
    public double getMean() {
        int n = this.getNumberOfElements();
        double d = this.getExponent();
        double d2 = this.generalizedHarmonic(n, d - 1.0);
        double d3 = this.nthHarmonic;
        return d2 / d3;
    }

    @Override
    public double getVariance() {
        int n = this.getNumberOfElements();
        double d = this.getExponent();
        double d2 = this.generalizedHarmonic(n, d - 2.0);
        double d3 = this.generalizedHarmonic(n, d - 1.0);
        double d4 = this.nthHarmonic;
        return d2 / d4 - d3 * d3 / (d4 * d4);
    }

    private double generalizedHarmonic(int n, double d) {
        double d2 = 0.0;
        for (int i = n; i > 0; --i) {
            d2 += 1.0 / Math.pow(i, d);
        }
        return d2;
    }

    @Override
    public int getSupportLowerBound() {
        return 1;
    }

    @Override
    public int getSupportUpperBound() {
        return this.getNumberOfElements();
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(final UniformRandomProvider uniformRandomProvider) {
        return new DiscreteDistribution.Sampler(){
            private final DiscreteSampler sampler;
            {
                this.sampler = new RejectionInversionZipfSampler(uniformRandomProvider, ZipfDistribution.this.numberOfElements, ZipfDistribution.this.exponent);
            }

            @Override
            public int sample() {
                return this.sampler.sample();
            }
        };
    }
}

