/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.distribution;

import io.virtdata.shaded.oac.statistics.distribution.DiscreteDistribution;
import java.io.Serializable;
import org.apache.commons.math4.distribution.IntegerDistribution;
import org.apache.commons.math4.exception.MathInternalError;
import org.apache.commons.math4.exception.NumberIsTooLargeException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.Localizable;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteInverseCumulativeProbabilityFunction;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.InverseTransformDiscreteSampler;

public abstract class AbstractIntegerDistribution
implements IntegerDistribution,
Serializable {
    private static final long serialVersionUID = 20160318L;

    @Override
    public double probability(int n, int n2) throws NumberIsTooLargeException {
        if (n2 < n) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, (Number)n, n2, true);
        }
        return this.cumulativeProbability(n2) - this.cumulativeProbability(n);
    }

    @Override
    public int inverseCumulativeProbability(double d) throws OutOfRangeException {
        boolean bl;
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException(d, (Number)0, 1);
        }
        int n = this.getSupportLowerBound();
        if (d == 0.0) {
            return n;
        }
        if (n == Integer.MIN_VALUE) {
            if (this.checkedCumulativeProbability(n) >= d) {
                return n;
            }
        } else {
            --n;
        }
        int n2 = this.getSupportUpperBound();
        if (d == 1.0) {
            return n2;
        }
        double d2 = this.getMean();
        double d3 = FastMath.sqrt(this.getVariance());
        boolean bl2 = bl = !Double.isInfinite(d2) && !Double.isNaN(d2) && !Double.isInfinite(d3) && !Double.isNaN(d3) && d3 != 0.0;
        if (bl) {
            double d4 = FastMath.sqrt((1.0 - d) / d);
            double d5 = d2 - d4 * d3;
            if (d5 > (double)n) {
                n = (int)FastMath.ceil(d5) - 1;
            }
            if ((d5 = d2 + (d4 = 1.0 / d4) * d3) < (double)n2) {
                n2 = (int)FastMath.ceil(d5) - 1;
            }
        }
        return this.solveInverseCumulativeProbability(d, n, n2);
    }

    protected int solveInverseCumulativeProbability(double d, int n, int n2) {
        while (n + 1 < n2) {
            double d2;
            int n3 = (n + n2) / 2;
            if (n3 < n || n3 > n2) {
                n3 = n + (n2 - n) / 2;
            }
            if ((d2 = this.checkedCumulativeProbability(n3)) >= d) {
                n2 = n3;
                continue;
            }
            n = n3;
        }
        return n2;
    }

    private double checkedCumulativeProbability(int n) throws MathInternalError {
        double d = this.cumulativeProbability(n);
        if (Double.isNaN(d)) {
            throw new MathInternalError(LocalizedFormats.DISCRETE_CUMULATIVE_PROBABILITY_RETURNED_NAN, n);
        }
        return d;
    }

    @Override
    public double logProbability(int n) {
        return FastMath.log(this.probability(n));
    }

    public static int[] sample(int n, DiscreteDistribution.Sampler sampler) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = sampler.sample();
        }
        return nArray;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(final UniformRandomProvider uniformRandomProvider) {
        return new DiscreteDistribution.Sampler(){
            private final DiscreteSampler sampler;
            {
                this.sampler = new InverseTransformDiscreteSampler(uniformRandomProvider, AbstractIntegerDistribution.this.createICPF());
            }

            @Override
            public int sample() {
                return this.sampler.sample();
            }
        };
    }

    private DiscreteInverseCumulativeProbabilityFunction createICPF() {
        return new DiscreteInverseCumulativeProbabilityFunction(){

            @Override
            public int inverseCumulativeProbability(double d) {
                return AbstractIntegerDistribution.this.inverseCumulativeProbability(d);
            }
        };
    }
}

