/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.linear;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.math4.exception.DimensionMismatchException;
import org.apache.commons.math4.exception.NoDataException;
import org.apache.commons.math4.exception.NotStrictlyPositiveException;
import org.apache.commons.math4.exception.NullArgumentException;
import org.apache.commons.math4.exception.NumberIsTooSmallException;
import org.apache.commons.math4.exception.OutOfRangeException;
import org.apache.commons.math4.exception.util.LocalizedFormats;
import org.apache.commons.math4.linear.AbstractRealMatrix;
import org.apache.commons.math4.linear.ArrayRealVector;
import org.apache.commons.math4.linear.MatrixDimensionMismatchException;
import org.apache.commons.math4.linear.MatrixUtils;
import org.apache.commons.math4.linear.RealMatrix;
import org.apache.commons.math4.linear.RealMatrixChangingVisitor;
import org.apache.commons.math4.linear.RealMatrixPreservingVisitor;
import org.apache.commons.math4.linear.RealVector;
import org.apache.commons.math4.util.FastMath;
import org.apache.commons.math4.util.MathUtils;

public class BlockRealMatrix
extends AbstractRealMatrix
implements Serializable {
    public static final int BLOCK_SIZE = 52;
    private static final long serialVersionUID = 4991895511313664478L;
    private final double[][] blocks;
    private final int rows;
    private final int columns;
    private final int blockRows;
    private final int blockColumns;

    public BlockRealMatrix(int n, int n2) throws NotStrictlyPositiveException {
        super(n, n2);
        this.rows = n;
        this.columns = n2;
        this.blockRows = (n + 52 - 1) / 52;
        this.blockColumns = (n2 + 52 - 1) / 52;
        this.blocks = BlockRealMatrix.createBlocksLayout(n, n2);
    }

    public BlockRealMatrix(double[][] dArray) throws DimensionMismatchException, NotStrictlyPositiveException {
        this(dArray.length, dArray[0].length, BlockRealMatrix.toBlocksLayout(dArray), false);
    }

    public BlockRealMatrix(int n, int n2, double[][] dArray, boolean bl) throws DimensionMismatchException, NotStrictlyPositiveException {
        super(n, n2);
        this.rows = n;
        this.columns = n2;
        this.blockRows = (n + 52 - 1) / 52;
        this.blockColumns = (n2 + 52 - 1) / 52;
        this.blocks = bl ? (Object)new double[this.blockRows * this.blockColumns][] : dArray;
        int n3 = 0;
        for (int i = 0; i < this.blockRows; ++i) {
            int n4 = this.blockHeight(i);
            int n5 = 0;
            while (n5 < this.blockColumns) {
                if (dArray[n3].length != n4 * this.blockWidth(n5)) {
                    throw new DimensionMismatchException(dArray[n3].length, n4 * this.blockWidth(n5));
                }
                if (bl) {
                    this.blocks[n3] = (double[])dArray[n3].clone();
                }
                ++n5;
                ++n3;
            }
        }
    }

    public static double[][] toBlocksLayout(double[][] dArray) throws DimensionMismatchException {
        int n;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        int n4 = (n2 + 52 - 1) / 52;
        int n5 = (n3 + 52 - 1) / 52;
        for (int i = 0; i < dArray.length; ++i) {
            n = dArray[i].length;
            if (n == n3) continue;
            throw new DimensionMismatchException(n3, n);
        }
        double[][] dArrayArray = new double[n4 * n5][];
        n = 0;
        for (int i = 0; i < n4; ++i) {
            int n6 = i * 52;
            int n7 = FastMath.min(n6 + 52, n2);
            int n8 = n7 - n6;
            for (int j = 0; j < n5; ++j) {
                int n9 = j * 52;
                int n10 = FastMath.min(n9 + 52, n3);
                int n11 = n10 - n9;
                double[] dArray2 = new double[n8 * n11];
                dArrayArray[n] = dArray2;
                int n12 = 0;
                for (int k = n6; k < n7; ++k) {
                    System.arraycopy(dArray[k], n9, dArray2, n12, n11);
                    n12 += n11;
                }
                ++n;
            }
        }
        return dArrayArray;
    }

    public static double[][] createBlocksLayout(int n, int n2) {
        int n3 = (n + 52 - 1) / 52;
        int n4 = (n2 + 52 - 1) / 52;
        double[][] dArrayArray = new double[n3 * n4][];
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            int n6 = i * 52;
            int n7 = FastMath.min(n6 + 52, n);
            int n8 = n7 - n6;
            for (int j = 0; j < n4; ++j) {
                int n9 = j * 52;
                int n10 = FastMath.min(n9 + 52, n2);
                int n11 = n10 - n9;
                dArrayArray[n5] = new double[n8 * n11];
                ++n5;
            }
        }
        return dArrayArray;
    }

    @Override
    public BlockRealMatrix createMatrix(int n, int n2) throws NotStrictlyPositiveException {
        return new BlockRealMatrix(n, n2);
    }

    @Override
    public BlockRealMatrix copy() {
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(this.rows, this.columns);
        for (int i = 0; i < this.blocks.length; ++i) {
            System.arraycopy(this.blocks[i], 0, blockRealMatrix.blocks[i], 0, this.blocks[i].length);
        }
        return blockRealMatrix;
    }

    @Override
    public BlockRealMatrix add(RealMatrix realMatrix) throws MatrixDimensionMismatchException {
        try {
            return this.add((BlockRealMatrix)realMatrix);
        }
        catch (ClassCastException classCastException) {
            MatrixUtils.checkAdditionCompatible(this, realMatrix);
            BlockRealMatrix blockRealMatrix = new BlockRealMatrix(this.rows, this.columns);
            int n = 0;
            for (int i = 0; i < blockRealMatrix.blockRows; ++i) {
                for (int j = 0; j < blockRealMatrix.blockColumns; ++j) {
                    double[] dArray = blockRealMatrix.blocks[n];
                    double[] dArray2 = this.blocks[n];
                    int n2 = i * 52;
                    int n3 = FastMath.min(n2 + 52, this.rows);
                    int n4 = j * 52;
                    int n5 = FastMath.min(n4 + 52, this.columns);
                    int n6 = 0;
                    for (int k = n2; k < n3; ++k) {
                        for (int i2 = n4; i2 < n5; ++i2) {
                            dArray[n6] = dArray2[n6] + realMatrix.getEntry(k, i2);
                            ++n6;
                        }
                    }
                    ++n;
                }
            }
            return blockRealMatrix;
        }
    }

    public BlockRealMatrix add(BlockRealMatrix blockRealMatrix) throws MatrixDimensionMismatchException {
        MatrixUtils.checkAdditionCompatible(this, blockRealMatrix);
        BlockRealMatrix blockRealMatrix2 = new BlockRealMatrix(this.rows, this.columns);
        for (int i = 0; i < blockRealMatrix2.blocks.length; ++i) {
            double[] dArray = blockRealMatrix2.blocks[i];
            double[] dArray2 = this.blocks[i];
            double[] dArray3 = blockRealMatrix.blocks[i];
            for (int j = 0; j < dArray.length; ++j) {
                dArray[j] = dArray2[j] + dArray3[j];
            }
        }
        return blockRealMatrix2;
    }

    @Override
    public BlockRealMatrix subtract(RealMatrix realMatrix) throws MatrixDimensionMismatchException {
        try {
            return this.subtract((BlockRealMatrix)realMatrix);
        }
        catch (ClassCastException classCastException) {
            MatrixUtils.checkSubtractionCompatible(this, realMatrix);
            BlockRealMatrix blockRealMatrix = new BlockRealMatrix(this.rows, this.columns);
            int n = 0;
            for (int i = 0; i < blockRealMatrix.blockRows; ++i) {
                for (int j = 0; j < blockRealMatrix.blockColumns; ++j) {
                    double[] dArray = blockRealMatrix.blocks[n];
                    double[] dArray2 = this.blocks[n];
                    int n2 = i * 52;
                    int n3 = FastMath.min(n2 + 52, this.rows);
                    int n4 = j * 52;
                    int n5 = FastMath.min(n4 + 52, this.columns);
                    int n6 = 0;
                    for (int k = n2; k < n3; ++k) {
                        for (int i2 = n4; i2 < n5; ++i2) {
                            dArray[n6] = dArray2[n6] - realMatrix.getEntry(k, i2);
                            ++n6;
                        }
                    }
                    ++n;
                }
            }
            return blockRealMatrix;
        }
    }

    public BlockRealMatrix subtract(BlockRealMatrix blockRealMatrix) throws MatrixDimensionMismatchException {
        MatrixUtils.checkSubtractionCompatible(this, blockRealMatrix);
        BlockRealMatrix blockRealMatrix2 = new BlockRealMatrix(this.rows, this.columns);
        for (int i = 0; i < blockRealMatrix2.blocks.length; ++i) {
            double[] dArray = blockRealMatrix2.blocks[i];
            double[] dArray2 = this.blocks[i];
            double[] dArray3 = blockRealMatrix.blocks[i];
            for (int j = 0; j < dArray.length; ++j) {
                dArray[j] = dArray2[j] - dArray3[j];
            }
        }
        return blockRealMatrix2;
    }

    @Override
    public BlockRealMatrix scalarAdd(double d) {
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(this.rows, this.columns);
        for (int i = 0; i < blockRealMatrix.blocks.length; ++i) {
            double[] dArray = blockRealMatrix.blocks[i];
            double[] dArray2 = this.blocks[i];
            for (int j = 0; j < dArray.length; ++j) {
                dArray[j] = dArray2[j] + d;
            }
        }
        return blockRealMatrix;
    }

    @Override
    public RealMatrix scalarMultiply(double d) {
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(this.rows, this.columns);
        for (int i = 0; i < blockRealMatrix.blocks.length; ++i) {
            double[] dArray = blockRealMatrix.blocks[i];
            double[] dArray2 = this.blocks[i];
            for (int j = 0; j < dArray.length; ++j) {
                dArray[j] = dArray2[j] * d;
            }
        }
        return blockRealMatrix;
    }

    @Override
    public BlockRealMatrix multiply(RealMatrix realMatrix) throws DimensionMismatchException {
        try {
            return this.multiply((BlockRealMatrix)realMatrix);
        }
        catch (ClassCastException classCastException) {
            MatrixUtils.checkMultiplicationCompatible(this, realMatrix);
            BlockRealMatrix blockRealMatrix = new BlockRealMatrix(this.rows, realMatrix.getColumnDimension());
            int n = 0;
            for (int i = 0; i < blockRealMatrix.blockRows; ++i) {
                int n2 = i * 52;
                int n3 = FastMath.min(n2 + 52, this.rows);
                for (int j = 0; j < blockRealMatrix.blockColumns; ++j) {
                    int n4 = j * 52;
                    int n5 = FastMath.min(n4 + 52, realMatrix.getColumnDimension());
                    double[] dArray = blockRealMatrix.blocks[n];
                    for (int k = 0; k < this.blockColumns; ++k) {
                        int n6 = this.blockWidth(k);
                        double[] dArray2 = this.blocks[i * this.blockColumns + k];
                        int n7 = k * 52;
                        int n8 = 0;
                        for (int i2 = n2; i2 < n3; ++i2) {
                            int n9 = (i2 - n2) * n6;
                            int n10 = n9 + n6;
                            for (int i3 = n4; i3 < n5; ++i3) {
                                double d = 0.0;
                                int n11 = n7;
                                for (int i4 = n9; i4 < n10; ++i4) {
                                    d += dArray2[i4] * realMatrix.getEntry(n11, i3);
                                    ++n11;
                                }
                                int n12 = n8++;
                                dArray[n12] = dArray[n12] + d;
                            }
                        }
                    }
                    ++n;
                }
            }
            return blockRealMatrix;
        }
    }

    public BlockRealMatrix multiply(BlockRealMatrix blockRealMatrix) throws DimensionMismatchException {
        MatrixUtils.checkMultiplicationCompatible(this, blockRealMatrix);
        BlockRealMatrix blockRealMatrix2 = new BlockRealMatrix(this.rows, blockRealMatrix.columns);
        int n = 0;
        for (int i = 0; i < blockRealMatrix2.blockRows; ++i) {
            int n2 = i * 52;
            int n3 = FastMath.min(n2 + 52, this.rows);
            for (int j = 0; j < blockRealMatrix2.blockColumns; ++j) {
                int n4 = blockRealMatrix2.blockWidth(j);
                int n5 = n4 + n4;
                int n6 = n5 + n4;
                int n7 = n6 + n4;
                double[] dArray = blockRealMatrix2.blocks[n];
                for (int k = 0; k < this.blockColumns; ++k) {
                    int n8 = this.blockWidth(k);
                    double[] dArray2 = this.blocks[i * this.blockColumns + k];
                    double[] dArray3 = blockRealMatrix.blocks[k * blockRealMatrix.blockColumns + j];
                    int n9 = 0;
                    for (int i2 = n2; i2 < n3; ++i2) {
                        int n10 = (i2 - n2) * n8;
                        int n11 = n10 + n8;
                        for (int i3 = 0; i3 < n4; ++i3) {
                            double d = 0.0;
                            int n12 = n10;
                            int n13 = i3;
                            while (n12 < n11 - 3) {
                                d += dArray2[n12] * dArray3[n13] + dArray2[n12 + 1] * dArray3[n13 + n4] + dArray2[n12 + 2] * dArray3[n13 + n5] + dArray2[n12 + 3] * dArray3[n13 + n6];
                                n12 += 4;
                                n13 += n7;
                            }
                            while (n12 < n11) {
                                d += dArray2[n12++] * dArray3[n13];
                                n13 += n4;
                            }
                            int n14 = n9++;
                            dArray[n14] = dArray[n14] + d;
                        }
                    }
                }
                ++n;
            }
        }
        return blockRealMatrix2;
    }

    @Override
    public double[][] getData() {
        double[][] dArray = new double[this.getRowDimension()][this.getColumnDimension()];
        int n = this.columns - (this.blockColumns - 1) * 52;
        for (int i = 0; i < this.blockRows; ++i) {
            int n2 = i * 52;
            int n3 = FastMath.min(n2 + 52, this.rows);
            int n4 = 0;
            int n5 = 0;
            for (int j = n2; j < n3; ++j) {
                double[] dArray2 = dArray[j];
                int n6 = i * this.blockColumns;
                int n7 = 0;
                for (int k = 0; k < this.blockColumns - 1; ++k) {
                    System.arraycopy(this.blocks[n6++], n4, dArray2, n7, 52);
                    n7 += 52;
                }
                System.arraycopy(this.blocks[n6], n5, dArray2, n7, n);
                n4 += 52;
                n5 += n;
            }
        }
        return dArray;
    }

    @Override
    public double getNorm() {
        double[] dArray = new double[52];
        double d = 0.0;
        for (int i = 0; i < this.blockColumns; ++i) {
            int n;
            int n2 = this.blockWidth(i);
            Arrays.fill(dArray, 0, n2, 0.0);
            for (n = 0; n < this.blockRows; ++n) {
                int n3 = this.blockHeight(n);
                double[] dArray2 = this.blocks[n * this.blockColumns + i];
                int n4 = 0;
                while (n4 < n2) {
                    double d2 = 0.0;
                    for (int j = 0; j < n3; ++j) {
                        d2 += FastMath.abs(dArray2[j * n2 + n4]);
                    }
                    int n5 = n4++;
                    dArray[n5] = dArray[n5] + d2;
                }
            }
            for (n = 0; n < n2; ++n) {
                d = FastMath.max(d, dArray[n]);
            }
        }
        return d;
    }

    @Override
    public double getFrobeniusNorm() {
        double d = 0.0;
        for (int i = 0; i < this.blocks.length; ++i) {
            for (double d2 : this.blocks[i]) {
                d += d2 * d2;
            }
        }
        return FastMath.sqrt(d);
    }

    @Override
    public BlockRealMatrix getSubMatrix(int n, int n2, int n3, int n4) throws OutOfRangeException, NumberIsTooSmallException {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(n2 - n + 1, n4 - n3 + 1);
        int n5 = n / 52;
        int n6 = n % 52;
        int n7 = n3 / 52;
        int n8 = n3 % 52;
        int n9 = n5;
        for (int i = 0; i < blockRealMatrix.blockRows; ++i) {
            int n10 = blockRealMatrix.blockHeight(i);
            int n11 = n7;
            for (int j = 0; j < blockRealMatrix.blockColumns; ++j) {
                int n12;
                int n13 = blockRealMatrix.blockWidth(j);
                int n14 = i * blockRealMatrix.blockColumns + j;
                double[] dArray = blockRealMatrix.blocks[n14];
                int n15 = n9 * this.blockColumns + n11;
                int n16 = this.blockWidth(n11);
                int n17 = n10 + n6 - 52;
                int n18 = n13 + n8 - 52;
                if (n17 > 0) {
                    if (n18 > 0) {
                        n12 = this.blockWidth(n11 + 1);
                        this.copyBlockPart(this.blocks[n15], n16, n6, 52, n8, 52, dArray, n13, 0, 0);
                        this.copyBlockPart(this.blocks[n15 + 1], n12, n6, 52, 0, n18, dArray, n13, 0, n13 - n18);
                        this.copyBlockPart(this.blocks[n15 + this.blockColumns], n16, 0, n17, n8, 52, dArray, n13, n10 - n17, 0);
                        this.copyBlockPart(this.blocks[n15 + this.blockColumns + 1], n12, 0, n17, 0, n18, dArray, n13, n10 - n17, n13 - n18);
                    } else {
                        this.copyBlockPart(this.blocks[n15], n16, n6, 52, n8, n13 + n8, dArray, n13, 0, 0);
                        this.copyBlockPart(this.blocks[n15 + this.blockColumns], n16, 0, n17, n8, n13 + n8, dArray, n13, n10 - n17, 0);
                    }
                } else if (n18 > 0) {
                    n12 = this.blockWidth(n11 + 1);
                    this.copyBlockPart(this.blocks[n15], n16, n6, n10 + n6, n8, 52, dArray, n13, 0, 0);
                    this.copyBlockPart(this.blocks[n15 + 1], n12, n6, n10 + n6, 0, n18, dArray, n13, 0, n13 - n18);
                } else {
                    this.copyBlockPart(this.blocks[n15], n16, n6, n10 + n6, n8, n13 + n8, dArray, n13, 0, 0);
                }
                ++n11;
            }
            ++n9;
        }
        return blockRealMatrix;
    }

    private void copyBlockPart(double[] dArray, int n, int n2, int n3, int n4, int n5, double[] dArray2, int n6, int n7, int n8) {
        int n9 = n5 - n4;
        int n10 = n2 * n + n4;
        int n11 = n7 * n6 + n8;
        for (int i = n2; i < n3; ++i) {
            System.arraycopy(dArray, n10, dArray2, n11, n9);
            n10 += n;
            n11 += n6;
        }
    }

    @Override
    public void setSubMatrix(double[][] dArray, int n, int n2) throws OutOfRangeException, NoDataException, NullArgumentException, DimensionMismatchException {
        MathUtils.checkNotNull(dArray);
        int n3 = dArray[0].length;
        if (n3 == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        int n4 = n + dArray.length - 1;
        int n5 = n2 + n3 - 1;
        MatrixUtils.checkSubMatrixIndex(this, n, n4, n2, n5);
        for (double[] dArray2 : dArray) {
            if (dArray2.length == n3) continue;
            throw new DimensionMismatchException(n3, dArray2.length);
        }
        int n6 = n / 52;
        int n7 = (n4 + 52) / 52;
        int n8 = n2 / 52;
        int n9 = (n5 + 52) / 52;
        for (int i = n6; i < n7; ++i) {
            int n10 = this.blockHeight(i);
            int n11 = i * 52;
            int n12 = FastMath.max(n, n11);
            int n13 = FastMath.min(n4 + 1, n11 + n10);
            for (int j = n8; j < n9; ++j) {
                int n14 = this.blockWidth(j);
                int n15 = j * 52;
                int n16 = FastMath.max(n2, n15);
                int n17 = FastMath.min(n5 + 1, n15 + n14);
                int n18 = n17 - n16;
                double[] dArray3 = this.blocks[i * this.blockColumns + j];
                for (int k = n12; k < n13; ++k) {
                    System.arraycopy(dArray[k - n], n16 - n2, dArray3, (k - n11) * n14 + (n16 - n15), n18);
                }
            }
        }
    }

    @Override
    public BlockRealMatrix getRowMatrix(int n) throws OutOfRangeException {
        MatrixUtils.checkRowIndex(this, n);
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(1, this.columns);
        int n2 = n / 52;
        int n3 = n - n2 * 52;
        int n4 = 0;
        int n5 = 0;
        double[] dArray = blockRealMatrix.blocks[n4];
        for (int i = 0; i < this.blockColumns; ++i) {
            int n6 = this.blockWidth(i);
            double[] dArray2 = this.blocks[n2 * this.blockColumns + i];
            int n7 = dArray.length - n5;
            if (n6 > n7) {
                System.arraycopy(dArray2, n3 * n6, dArray, n5, n7);
                dArray = blockRealMatrix.blocks[++n4];
                System.arraycopy(dArray2, n3 * n6, dArray, 0, n6 - n7);
                n5 = n6 - n7;
                continue;
            }
            System.arraycopy(dArray2, n3 * n6, dArray, n5, n6);
            n5 += n6;
        }
        return blockRealMatrix;
    }

    @Override
    public void setRowMatrix(int n, RealMatrix realMatrix) throws OutOfRangeException, MatrixDimensionMismatchException {
        try {
            this.setRowMatrix(n, (BlockRealMatrix)realMatrix);
        }
        catch (ClassCastException classCastException) {
            super.setRowMatrix(n, realMatrix);
        }
    }

    public void setRowMatrix(int n, BlockRealMatrix blockRealMatrix) throws OutOfRangeException, MatrixDimensionMismatchException {
        MatrixUtils.checkRowIndex(this, n);
        int n2 = this.getColumnDimension();
        if (blockRealMatrix.getRowDimension() != 1 || blockRealMatrix.getColumnDimension() != n2) {
            throw new MatrixDimensionMismatchException(blockRealMatrix.getRowDimension(), blockRealMatrix.getColumnDimension(), 1, n2);
        }
        int n3 = n / 52;
        int n4 = n - n3 * 52;
        int n5 = 0;
        int n6 = 0;
        double[] dArray = blockRealMatrix.blocks[n5];
        for (int i = 0; i < this.blockColumns; ++i) {
            int n7 = this.blockWidth(i);
            double[] dArray2 = this.blocks[n3 * this.blockColumns + i];
            int n8 = dArray.length - n6;
            if (n7 > n8) {
                System.arraycopy(dArray, n6, dArray2, n4 * n7, n8);
                dArray = blockRealMatrix.blocks[++n5];
                System.arraycopy(dArray, 0, dArray2, n4 * n7, n7 - n8);
                n6 = n7 - n8;
                continue;
            }
            System.arraycopy(dArray, n6, dArray2, n4 * n7, n7);
            n6 += n7;
        }
    }

    @Override
    public BlockRealMatrix getColumnMatrix(int n) throws OutOfRangeException {
        MatrixUtils.checkColumnIndex(this, n);
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(this.rows, 1);
        int n2 = n / 52;
        int n3 = n - n2 * 52;
        int n4 = this.blockWidth(n2);
        int n5 = 0;
        int n6 = 0;
        double[] dArray = blockRealMatrix.blocks[n5];
        for (int i = 0; i < this.blockRows; ++i) {
            int n7 = this.blockHeight(i);
            double[] dArray2 = this.blocks[i * this.blockColumns + n2];
            for (int j = 0; j < n7; ++j) {
                if (n6 >= dArray.length) {
                    dArray = blockRealMatrix.blocks[++n5];
                    n6 = 0;
                }
                dArray[n6++] = dArray2[j * n4 + n3];
            }
        }
        return blockRealMatrix;
    }

    @Override
    public void setColumnMatrix(int n, RealMatrix realMatrix) throws OutOfRangeException, MatrixDimensionMismatchException {
        try {
            this.setColumnMatrix(n, (BlockRealMatrix)realMatrix);
        }
        catch (ClassCastException classCastException) {
            super.setColumnMatrix(n, realMatrix);
        }
    }

    void setColumnMatrix(int n, BlockRealMatrix blockRealMatrix) throws OutOfRangeException, MatrixDimensionMismatchException {
        MatrixUtils.checkColumnIndex(this, n);
        int n2 = this.getRowDimension();
        if (blockRealMatrix.getRowDimension() != n2 || blockRealMatrix.getColumnDimension() != 1) {
            throw new MatrixDimensionMismatchException(blockRealMatrix.getRowDimension(), blockRealMatrix.getColumnDimension(), n2, 1);
        }
        int n3 = n / 52;
        int n4 = n - n3 * 52;
        int n5 = this.blockWidth(n3);
        int n6 = 0;
        int n7 = 0;
        double[] dArray = blockRealMatrix.blocks[n6];
        for (int i = 0; i < this.blockRows; ++i) {
            int n8 = this.blockHeight(i);
            double[] dArray2 = this.blocks[i * this.blockColumns + n3];
            for (int j = 0; j < n8; ++j) {
                if (n7 >= dArray.length) {
                    dArray = blockRealMatrix.blocks[++n6];
                    n7 = 0;
                }
                dArray2[j * n5 + n4] = dArray[n7++];
            }
        }
    }

    @Override
    public RealVector getRowVector(int n) throws OutOfRangeException {
        MatrixUtils.checkRowIndex(this, n);
        double[] dArray = new double[this.columns];
        int n2 = n / 52;
        int n3 = n - n2 * 52;
        int n4 = 0;
        for (int i = 0; i < this.blockColumns; ++i) {
            int n5 = this.blockWidth(i);
            double[] dArray2 = this.blocks[n2 * this.blockColumns + i];
            System.arraycopy(dArray2, n3 * n5, dArray, n4, n5);
            n4 += n5;
        }
        return new ArrayRealVector(dArray, false);
    }

    @Override
    public void setRowVector(int n, RealVector realVector) throws OutOfRangeException, MatrixDimensionMismatchException {
        try {
            this.setRow(n, ((ArrayRealVector)realVector).getDataRef());
        }
        catch (ClassCastException classCastException) {
            super.setRowVector(n, realVector);
        }
    }

    @Override
    public RealVector getColumnVector(int n) throws OutOfRangeException {
        MatrixUtils.checkColumnIndex(this, n);
        double[] dArray = new double[this.rows];
        int n2 = n / 52;
        int n3 = n - n2 * 52;
        int n4 = this.blockWidth(n2);
        int n5 = 0;
        for (int i = 0; i < this.blockRows; ++i) {
            int n6 = this.blockHeight(i);
            double[] dArray2 = this.blocks[i * this.blockColumns + n2];
            for (int j = 0; j < n6; ++j) {
                dArray[n5++] = dArray2[j * n4 + n3];
            }
        }
        return new ArrayRealVector(dArray, false);
    }

    @Override
    public void setColumnVector(int n, RealVector realVector) throws OutOfRangeException, MatrixDimensionMismatchException {
        try {
            this.setColumn(n, ((ArrayRealVector)realVector).getDataRef());
        }
        catch (ClassCastException classCastException) {
            super.setColumnVector(n, realVector);
        }
    }

    @Override
    public double[] getRow(int n) throws OutOfRangeException {
        MatrixUtils.checkRowIndex(this, n);
        double[] dArray = new double[this.columns];
        int n2 = n / 52;
        int n3 = n - n2 * 52;
        int n4 = 0;
        for (int i = 0; i < this.blockColumns; ++i) {
            int n5 = this.blockWidth(i);
            double[] dArray2 = this.blocks[n2 * this.blockColumns + i];
            System.arraycopy(dArray2, n3 * n5, dArray, n4, n5);
            n4 += n5;
        }
        return dArray;
    }

    @Override
    public void setRow(int n, double[] dArray) throws OutOfRangeException, MatrixDimensionMismatchException {
        MatrixUtils.checkRowIndex(this, n);
        int n2 = this.getColumnDimension();
        if (dArray.length != n2) {
            throw new MatrixDimensionMismatchException(1, dArray.length, 1, n2);
        }
        int n3 = n / 52;
        int n4 = n - n3 * 52;
        int n5 = 0;
        for (int i = 0; i < this.blockColumns; ++i) {
            int n6 = this.blockWidth(i);
            double[] dArray2 = this.blocks[n3 * this.blockColumns + i];
            System.arraycopy(dArray, n5, dArray2, n4 * n6, n6);
            n5 += n6;
        }
    }

    @Override
    public double[] getColumn(int n) throws OutOfRangeException {
        MatrixUtils.checkColumnIndex(this, n);
        double[] dArray = new double[this.rows];
        int n2 = n / 52;
        int n3 = n - n2 * 52;
        int n4 = this.blockWidth(n2);
        int n5 = 0;
        for (int i = 0; i < this.blockRows; ++i) {
            int n6 = this.blockHeight(i);
            double[] dArray2 = this.blocks[i * this.blockColumns + n2];
            for (int j = 0; j < n6; ++j) {
                dArray[n5++] = dArray2[j * n4 + n3];
            }
        }
        return dArray;
    }

    @Override
    public void setColumn(int n, double[] dArray) throws OutOfRangeException, MatrixDimensionMismatchException {
        MatrixUtils.checkColumnIndex(this, n);
        int n2 = this.getRowDimension();
        if (dArray.length != n2) {
            throw new MatrixDimensionMismatchException(dArray.length, 1, n2, 1);
        }
        int n3 = n / 52;
        int n4 = n - n3 * 52;
        int n5 = this.blockWidth(n3);
        int n6 = 0;
        for (int i = 0; i < this.blockRows; ++i) {
            int n7 = this.blockHeight(i);
            double[] dArray2 = this.blocks[i * this.blockColumns + n3];
            for (int j = 0; j < n7; ++j) {
                dArray2[j * n5 + n4] = dArray[n6++];
            }
        }
    }

    @Override
    public double getEntry(int n, int n2) throws OutOfRangeException {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        int n3 = n / 52;
        int n4 = n2 / 52;
        int n5 = (n - n3 * 52) * this.blockWidth(n4) + (n2 - n4 * 52);
        return this.blocks[n3 * this.blockColumns + n4][n5];
    }

    @Override
    public void setEntry(int n, int n2, double d) throws OutOfRangeException {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        int n3 = n / 52;
        int n4 = n2 / 52;
        int n5 = (n - n3 * 52) * this.blockWidth(n4) + (n2 - n4 * 52);
        this.blocks[n3 * this.blockColumns + n4][n5] = d;
    }

    @Override
    public void addToEntry(int n, int n2, double d) throws OutOfRangeException {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        int n3 = n / 52;
        int n4 = n2 / 52;
        int n5 = (n - n3 * 52) * this.blockWidth(n4) + (n2 - n4 * 52);
        double[] dArray = this.blocks[n3 * this.blockColumns + n4];
        int n6 = n5;
        dArray[n6] = dArray[n6] + d;
    }

    @Override
    public void multiplyEntry(int n, int n2, double d) throws OutOfRangeException {
        MatrixUtils.checkMatrixIndex(this, n, n2);
        int n3 = n / 52;
        int n4 = n2 / 52;
        int n5 = (n - n3 * 52) * this.blockWidth(n4) + (n2 - n4 * 52);
        double[] dArray = this.blocks[n3 * this.blockColumns + n4];
        int n6 = n5;
        dArray[n6] = dArray[n6] * d;
    }

    @Override
    public BlockRealMatrix transpose() {
        int n = this.getRowDimension();
        int n2 = this.getColumnDimension();
        BlockRealMatrix blockRealMatrix = new BlockRealMatrix(n2, n);
        int n3 = 0;
        for (int i = 0; i < this.blockColumns; ++i) {
            for (int j = 0; j < this.blockRows; ++j) {
                double[] dArray = blockRealMatrix.blocks[n3];
                double[] dArray2 = this.blocks[j * this.blockColumns + i];
                int n4 = i * 52;
                int n5 = FastMath.min(n4 + 52, this.columns);
                int n6 = j * 52;
                int n7 = FastMath.min(n6 + 52, this.rows);
                int n8 = 0;
                for (int k = n4; k < n5; ++k) {
                    int n9 = n5 - n4;
                    int n10 = k - n4;
                    for (int i2 = n6; i2 < n7; ++i2) {
                        dArray[n8] = dArray2[n10];
                        ++n8;
                        n10 += n9;
                    }
                }
                ++n3;
            }
        }
        return blockRealMatrix;
    }

    @Override
    public int getRowDimension() {
        return this.rows;
    }

    @Override
    public int getColumnDimension() {
        return this.columns;
    }

    @Override
    public double[] operate(double[] dArray) throws DimensionMismatchException {
        if (dArray.length != this.columns) {
            throw new DimensionMismatchException(dArray.length, this.columns);
        }
        double[] dArray2 = new double[this.rows];
        for (int i = 0; i < this.blockRows; ++i) {
            int n = i * 52;
            int n2 = FastMath.min(n + 52, this.rows);
            for (int j = 0; j < this.blockColumns; ++j) {
                double[] dArray3 = this.blocks[i * this.blockColumns + j];
                int n3 = j * 52;
                int n4 = FastMath.min(n3 + 52, this.columns);
                int n5 = 0;
                int n6 = n;
                while (n6 < n2) {
                    int n7;
                    double d = 0.0;
                    for (n7 = n3; n7 < n4 - 3; n7 += 4) {
                        d += dArray3[n5] * dArray[n7] + dArray3[n5 + 1] * dArray[n7 + 1] + dArray3[n5 + 2] * dArray[n7 + 2] + dArray3[n5 + 3] * dArray[n7 + 3];
                        n5 += 4;
                    }
                    while (n7 < n4) {
                        d += dArray3[n5++] * dArray[n7++];
                    }
                    int n8 = n6++;
                    dArray2[n8] = dArray2[n8] + d;
                }
            }
        }
        return dArray2;
    }

    @Override
    public double[] preMultiply(double[] dArray) throws DimensionMismatchException {
        if (dArray.length != this.rows) {
            throw new DimensionMismatchException(dArray.length, this.rows);
        }
        double[] dArray2 = new double[this.columns];
        for (int i = 0; i < this.blockColumns; ++i) {
            int n = this.blockWidth(i);
            int n2 = n + n;
            int n3 = n2 + n;
            int n4 = n3 + n;
            int n5 = i * 52;
            int n6 = FastMath.min(n5 + 52, this.columns);
            for (int j = 0; j < this.blockRows; ++j) {
                double[] dArray3 = this.blocks[j * this.blockColumns + i];
                int n7 = j * 52;
                int n8 = FastMath.min(n7 + 52, this.rows);
                int n9 = n5;
                while (n9 < n6) {
                    int n10;
                    int n11 = n9 - n5;
                    double d = 0.0;
                    for (n10 = n7; n10 < n8 - 3; n10 += 4) {
                        d += dArray3[n11] * dArray[n10] + dArray3[n11 + n] * dArray[n10 + 1] + dArray3[n11 + n2] * dArray[n10 + 2] + dArray3[n11 + n3] * dArray[n10 + 3];
                        n11 += n4;
                    }
                    while (n10 < n8) {
                        d += dArray3[n11] * dArray[n10++];
                        n11 += n;
                    }
                    int n12 = n9++;
                    dArray2[n12] = dArray2[n12] + d;
                }
            }
        }
        return dArray2;
    }

    @Override
    public double walkInRowOrder(RealMatrixChangingVisitor realMatrixChangingVisitor) {
        realMatrixChangingVisitor.start(this.rows, this.columns, 0, this.rows - 1, 0, this.columns - 1);
        for (int i = 0; i < this.blockRows; ++i) {
            int n = i * 52;
            int n2 = FastMath.min(n + 52, this.rows);
            for (int j = n; j < n2; ++j) {
                for (int k = 0; k < this.blockColumns; ++k) {
                    int n3 = this.blockWidth(k);
                    int n4 = k * 52;
                    int n5 = FastMath.min(n4 + 52, this.columns);
                    double[] dArray = this.blocks[i * this.blockColumns + k];
                    int n6 = (j - n) * n3;
                    for (int i2 = n4; i2 < n5; ++i2) {
                        dArray[n6] = realMatrixChangingVisitor.visit(j, i2, dArray[n6]);
                        ++n6;
                    }
                }
            }
        }
        return realMatrixChangingVisitor.end();
    }

    @Override
    public double walkInRowOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor) {
        realMatrixPreservingVisitor.start(this.rows, this.columns, 0, this.rows - 1, 0, this.columns - 1);
        for (int i = 0; i < this.blockRows; ++i) {
            int n = i * 52;
            int n2 = FastMath.min(n + 52, this.rows);
            for (int j = n; j < n2; ++j) {
                for (int k = 0; k < this.blockColumns; ++k) {
                    int n3 = this.blockWidth(k);
                    int n4 = k * 52;
                    int n5 = FastMath.min(n4 + 52, this.columns);
                    double[] dArray = this.blocks[i * this.blockColumns + k];
                    int n6 = (j - n) * n3;
                    for (int i2 = n4; i2 < n5; ++i2) {
                        realMatrixPreservingVisitor.visit(j, i2, dArray[n6]);
                        ++n6;
                    }
                }
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    @Override
    public double walkInRowOrder(RealMatrixChangingVisitor realMatrixChangingVisitor, int n, int n2, int n3, int n4) throws OutOfRangeException, NumberIsTooSmallException {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixChangingVisitor.start(this.rows, this.columns, n, n2, n3, n4);
        for (int i = n / 52; i < 1 + n2 / 52; ++i) {
            int n5 = i * 52;
            int n6 = FastMath.max(n, n5);
            int n7 = FastMath.min((i + 1) * 52, 1 + n2);
            for (int j = n6; j < n7; ++j) {
                for (int k = n3 / 52; k < 1 + n4 / 52; ++k) {
                    int n8 = this.blockWidth(k);
                    int n9 = k * 52;
                    int n10 = FastMath.max(n3, n9);
                    int n11 = FastMath.min((k + 1) * 52, 1 + n4);
                    double[] dArray = this.blocks[i * this.blockColumns + k];
                    int n12 = (j - n5) * n8 + n10 - n9;
                    for (int i2 = n10; i2 < n11; ++i2) {
                        dArray[n12] = realMatrixChangingVisitor.visit(j, i2, dArray[n12]);
                        ++n12;
                    }
                }
            }
        }
        return realMatrixChangingVisitor.end();
    }

    @Override
    public double walkInRowOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor, int n, int n2, int n3, int n4) throws OutOfRangeException, NumberIsTooSmallException {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixPreservingVisitor.start(this.rows, this.columns, n, n2, n3, n4);
        for (int i = n / 52; i < 1 + n2 / 52; ++i) {
            int n5 = i * 52;
            int n6 = FastMath.max(n, n5);
            int n7 = FastMath.min((i + 1) * 52, 1 + n2);
            for (int j = n6; j < n7; ++j) {
                for (int k = n3 / 52; k < 1 + n4 / 52; ++k) {
                    int n8 = this.blockWidth(k);
                    int n9 = k * 52;
                    int n10 = FastMath.max(n3, n9);
                    int n11 = FastMath.min((k + 1) * 52, 1 + n4);
                    double[] dArray = this.blocks[i * this.blockColumns + k];
                    int n12 = (j - n5) * n8 + n10 - n9;
                    for (int i2 = n10; i2 < n11; ++i2) {
                        realMatrixPreservingVisitor.visit(j, i2, dArray[n12]);
                        ++n12;
                    }
                }
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    @Override
    public double walkInOptimizedOrder(RealMatrixChangingVisitor realMatrixChangingVisitor) {
        realMatrixChangingVisitor.start(this.rows, this.columns, 0, this.rows - 1, 0, this.columns - 1);
        int n = 0;
        for (int i = 0; i < this.blockRows; ++i) {
            int n2 = i * 52;
            int n3 = FastMath.min(n2 + 52, this.rows);
            for (int j = 0; j < this.blockColumns; ++j) {
                int n4 = j * 52;
                int n5 = FastMath.min(n4 + 52, this.columns);
                double[] dArray = this.blocks[n];
                int n6 = 0;
                for (int k = n2; k < n3; ++k) {
                    for (int i2 = n4; i2 < n5; ++i2) {
                        dArray[n6] = realMatrixChangingVisitor.visit(k, i2, dArray[n6]);
                        ++n6;
                    }
                }
                ++n;
            }
        }
        return realMatrixChangingVisitor.end();
    }

    @Override
    public double walkInOptimizedOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor) {
        realMatrixPreservingVisitor.start(this.rows, this.columns, 0, this.rows - 1, 0, this.columns - 1);
        int n = 0;
        for (int i = 0; i < this.blockRows; ++i) {
            int n2 = i * 52;
            int n3 = FastMath.min(n2 + 52, this.rows);
            for (int j = 0; j < this.blockColumns; ++j) {
                int n4 = j * 52;
                int n5 = FastMath.min(n4 + 52, this.columns);
                double[] dArray = this.blocks[n];
                int n6 = 0;
                for (int k = n2; k < n3; ++k) {
                    for (int i2 = n4; i2 < n5; ++i2) {
                        realMatrixPreservingVisitor.visit(k, i2, dArray[n6]);
                        ++n6;
                    }
                }
                ++n;
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    @Override
    public double walkInOptimizedOrder(RealMatrixChangingVisitor realMatrixChangingVisitor, int n, int n2, int n3, int n4) throws OutOfRangeException, NumberIsTooSmallException {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixChangingVisitor.start(this.rows, this.columns, n, n2, n3, n4);
        for (int i = n / 52; i < 1 + n2 / 52; ++i) {
            int n5 = i * 52;
            int n6 = FastMath.max(n, n5);
            int n7 = FastMath.min((i + 1) * 52, 1 + n2);
            for (int j = n3 / 52; j < 1 + n4 / 52; ++j) {
                int n8 = this.blockWidth(j);
                int n9 = j * 52;
                int n10 = FastMath.max(n3, n9);
                int n11 = FastMath.min((j + 1) * 52, 1 + n4);
                double[] dArray = this.blocks[i * this.blockColumns + j];
                for (int k = n6; k < n7; ++k) {
                    int n12 = (k - n5) * n8 + n10 - n9;
                    for (int i2 = n10; i2 < n11; ++i2) {
                        dArray[n12] = realMatrixChangingVisitor.visit(k, i2, dArray[n12]);
                        ++n12;
                    }
                }
            }
        }
        return realMatrixChangingVisitor.end();
    }

    @Override
    public double walkInOptimizedOrder(RealMatrixPreservingVisitor realMatrixPreservingVisitor, int n, int n2, int n3, int n4) throws OutOfRangeException, NumberIsTooSmallException {
        MatrixUtils.checkSubMatrixIndex(this, n, n2, n3, n4);
        realMatrixPreservingVisitor.start(this.rows, this.columns, n, n2, n3, n4);
        for (int i = n / 52; i < 1 + n2 / 52; ++i) {
            int n5 = i * 52;
            int n6 = FastMath.max(n, n5);
            int n7 = FastMath.min((i + 1) * 52, 1 + n2);
            for (int j = n3 / 52; j < 1 + n4 / 52; ++j) {
                int n8 = this.blockWidth(j);
                int n9 = j * 52;
                int n10 = FastMath.max(n3, n9);
                int n11 = FastMath.min((j + 1) * 52, 1 + n4);
                double[] dArray = this.blocks[i * this.blockColumns + j];
                for (int k = n6; k < n7; ++k) {
                    int n12 = (k - n5) * n8 + n10 - n9;
                    for (int i2 = n10; i2 < n11; ++i2) {
                        realMatrixPreservingVisitor.visit(k, i2, dArray[n12]);
                        ++n12;
                    }
                }
            }
        }
        return realMatrixPreservingVisitor.end();
    }

    private int blockHeight(int n) {
        return n == this.blockRows - 1 ? this.rows - n * 52 : 52;
    }

    private int blockWidth(int n) {
        return n == this.blockColumns - 1 ? this.columns - n * 52 : 52;
    }
}

