/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.util;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.math4.exception.MaxCountExceededException;
import org.apache.commons.math4.util.Incrementor;
import org.apache.commons.math4.util.IterationEvent;
import org.apache.commons.math4.util.IterationListener;

public class IterationManager {
    private final Incrementor iterations;
    private final Collection<IterationListener> listeners;

    public IterationManager(int n) {
        this.iterations = new Incrementor(n);
        this.listeners = new CopyOnWriteArrayList<IterationListener>();
    }

    public IterationManager(int n, Incrementor.MaxCountExceededCallback maxCountExceededCallback) {
        this.iterations = new Incrementor(n, maxCountExceededCallback);
        this.listeners = new CopyOnWriteArrayList<IterationListener>();
    }

    public void addIterationListener(IterationListener iterationListener) {
        this.listeners.add(iterationListener);
    }

    public void fireInitializationEvent(IterationEvent iterationEvent) {
        for (IterationListener iterationListener : this.listeners) {
            iterationListener.initializationPerformed(iterationEvent);
        }
    }

    public void fireIterationPerformedEvent(IterationEvent iterationEvent) {
        for (IterationListener iterationListener : this.listeners) {
            iterationListener.iterationPerformed(iterationEvent);
        }
    }

    public void fireIterationStartedEvent(IterationEvent iterationEvent) {
        for (IterationListener iterationListener : this.listeners) {
            iterationListener.iterationStarted(iterationEvent);
        }
    }

    public void fireTerminationEvent(IterationEvent iterationEvent) {
        for (IterationListener iterationListener : this.listeners) {
            iterationListener.terminationPerformed(iterationEvent);
        }
    }

    public int getIterations() {
        return this.iterations.getCount();
    }

    public int getMaxIterations() {
        return this.iterations.getMaximalCount();
    }

    public void incrementIterationCount() throws MaxCountExceededException {
        this.iterations.incrementCount();
    }

    public void removeIterationListener(IterationListener iterationListener) {
        this.listeners.remove(iterationListener);
    }

    public void resetIterationCount() {
        this.iterations.resetCount();
    }
}

