/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

import org.apache.commons.numbers.gamma.GammaException;
import org.apache.commons.numbers.gamma.LogGamma1p;

class LogGammaSum {
    LogGammaSum() {
    }

    static double value(double d, double d2) {
        if (d < 1.0 || d > 2.0) {
            throw new GammaException("Number {0} is out of range [{1}, {2}]", d, 1, 2);
        }
        if (d2 < 1.0 || d2 > 2.0) {
            throw new GammaException("Number {0} is out of range [{1}, {2}]", d2, 1, 2);
        }
        double d3 = d - 1.0 + (d2 - 1.0);
        if (d3 <= 0.5) {
            return LogGamma1p.value(1.0 + d3);
        }
        if (d3 <= 1.5) {
            return LogGamma1p.value(d3) + Math.log1p(d3);
        }
        return LogGamma1p.value(d3 - 1.0) + Math.log(d3 * (1.0 + d3));
    }
}

