/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.SubsetSamplerUtils;

public class PermutationSampler {
    private final int[] domain;
    private final int size;
    private final UniformRandomProvider rng;

    public PermutationSampler(UniformRandomProvider uniformRandomProvider, int n, int n2) {
        SubsetSamplerUtils.checkSubset(n, n2);
        this.domain = PermutationSampler.natural(n);
        this.size = n2;
        this.rng = uniformRandomProvider;
    }

    public int[] sample() {
        return SubsetSamplerUtils.partialSample(this.domain, this.size, this.rng, true);
    }

    public static void shuffle(UniformRandomProvider uniformRandomProvider, int[] nArray) {
        PermutationSampler.shuffle(uniformRandomProvider, nArray, nArray.length - 1, true);
    }

    public static void shuffle(UniformRandomProvider uniformRandomProvider, int[] nArray, int n, boolean bl) {
        if (bl) {
            for (int i = n; i > 0; --i) {
                SubsetSamplerUtils.swap(nArray, i, uniformRandomProvider.nextInt(i + 1));
            }
        } else {
            for (int i = nArray.length - 1; i > n; --i) {
                SubsetSamplerUtils.swap(nArray, i, uniformRandomProvider.nextInt(i - n + 1) + n);
            }
        }
    }

    public static int[] natural(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }
}

