/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import org.apache.commons.rng.UniformRandomProvider;

final class SubsetSamplerUtils {
    private SubsetSamplerUtils() {
    }

    static void checkSubset(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0 : n=" + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("k <= 0 : k=" + n2);
        }
        if (n2 > n) {
            throw new IllegalArgumentException("k > n : k=" + n2 + ", n=" + n);
        }
    }

    static int[] partialSample(int[] nArray, int n, UniformRandomProvider uniformRandomProvider, boolean bl) {
        int n2;
        int n3 = nArray.length - 1;
        for (n2 = 0; n3 > 0 && n2 < n; --n3, ++n2) {
            SubsetSamplerUtils.swap(nArray, n3, uniformRandomProvider.nextInt(n3 + 1));
        }
        n3 = bl ? n : nArray.length - n;
        n2 = bl ? nArray.length - n : 0;
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, n2, nArray2, 0, n3);
        return nArray2;
    }

    static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }
}

