/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.SamplerBase;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;

public class AhrensDieterMarsagliaTsangGammaSampler
extends SamplerBase
implements ContinuousSampler {
    private final ContinuousSampler delegate;

    public AhrensDieterMarsagliaTsangGammaSampler(UniformRandomProvider uniformRandomProvider, double d, double d2) {
        super(null);
        this.delegate = d2 < 1.0 ? new SmallThetaAhrensDieterMarsagliaTsangGammaSampler(uniformRandomProvider, d, d2) : new LargeThetaAhrensDieterMarsagliaTsangGammaSampler(uniformRandomProvider, d, d2);
    }

    @Override
    public double sample() {
        return this.delegate.sample();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private static class LargeThetaAhrensDieterMarsagliaTsangGammaSampler
    extends BaseAhrensDieterMarsagliaTsangGammaSampler {
        private static final double ONE_THIRD = 0.3333333333333333;
        private final double dOptim;
        private final double cOptim;
        private final NormalizedGaussianSampler gaussian;

        LargeThetaAhrensDieterMarsagliaTsangGammaSampler(UniformRandomProvider uniformRandomProvider, double d, double d2) {
            super(uniformRandomProvider, d, d2);
            this.gaussian = new ZigguratNormalizedGaussianSampler(uniformRandomProvider);
            this.dOptim = d2 - 0.3333333333333333;
            this.cOptim = 0.3333333333333333 / Math.sqrt(this.dOptim);
        }

        @Override
        public double sample() {
            double d;
            while (true) {
                double d2;
                double d3;
                if ((d = (d3 = 1.0 + this.cOptim * (d2 = this.gaussian.sample())) * d3 * d3) <= 0.0) {
                    continue;
                }
                double d4 = d2 * d2;
                double d5 = this.rng.nextDouble();
                if (d5 < 1.0 - 0.0331 * d4 * d4) {
                    return this.alpha * this.dOptim * d;
                }
                if (Math.log(d5) < 0.5 * d4 + this.dOptim * (1.0 - d + Math.log(d))) break;
            }
            return this.alpha * this.dOptim * d;
        }
    }

    private static class SmallThetaAhrensDieterMarsagliaTsangGammaSampler
    extends BaseAhrensDieterMarsagliaTsangGammaSampler {
        private final double oneOverTheta;
        private final double bGSOptim;

        SmallThetaAhrensDieterMarsagliaTsangGammaSampler(UniformRandomProvider uniformRandomProvider, double d, double d2) {
            super(uniformRandomProvider, d, d2);
            this.oneOverTheta = 1.0 / d2;
            this.bGSOptim = 1.0 + d2 / Math.E;
        }

        @Override
        public double sample() {
            double d;
            while (true) {
                double d2;
                double d3;
                double d4;
                if ((d4 = this.bGSOptim * (d3 = this.rng.nextDouble())) <= 1.0) {
                    d = Math.pow(d4, this.oneOverTheta);
                    d2 = this.rng.nextDouble();
                    if (d2 > Math.exp(-d)) continue;
                    return this.alpha * d;
                }
                d = -Math.log((this.bGSOptim - d4) * this.oneOverTheta);
                d2 = this.rng.nextDouble();
                if (!(d2 > Math.pow(d, this.theta - 1.0))) break;
            }
            return this.alpha * d;
        }
    }

    private static abstract class BaseAhrensDieterMarsagliaTsangGammaSampler
    implements ContinuousSampler {
        protected final UniformRandomProvider rng;
        protected final double theta;
        protected final double alpha;

        BaseAhrensDieterMarsagliaTsangGammaSampler(UniformRandomProvider uniformRandomProvider, double d, double d2) {
            if (d <= 0.0) {
                throw new IllegalArgumentException("alpha is not strictly positive: " + d);
            }
            if (d2 <= 0.0) {
                throw new IllegalArgumentException("theta is not strictly positive: " + d2);
            }
            this.rng = uniformRandomProvider;
            this.alpha = d;
            this.theta = d2;
        }

        public String toString() {
            return "Ahrens-Dieter-Marsaglia-Tsang Gamma deviate [" + this.rng.toString() + "]";
        }
    }
}

