/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.AhrensDieterExponentialSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.SmallMeanPoissonSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;

public class LargeMeanPoissonSampler
implements DiscreteSampler {
    private static final double MAX_MEAN = 1.0737418235E9;
    private static final InternalUtils.FactorialLog NO_CACHE_FACTORIAL_LOG;
    private static final DiscreteSampler NO_SMALL_MEAN_POISSON_SAMPLER;
    private final UniformRandomProvider rng;
    private final ContinuousSampler exponential;
    private final ContinuousSampler gaussian;
    private final InternalUtils.FactorialLog factorialLog;
    private final double lambda;
    private final double logLambda;
    private final double logLambdaFactorial;
    private final double delta;
    private final double halfDelta;
    private final double twolpd;
    private final double p1;
    private final double p2;
    private final double c1;
    private final DiscreteSampler smallMeanPoissonSampler;

    public LargeMeanPoissonSampler(UniformRandomProvider uniformRandomProvider, double d) {
        if (d < 1.0) {
            throw new IllegalArgumentException("mean is not >= 1: " + d);
        }
        if (d > 1.0737418235E9) {
            throw new IllegalArgumentException("mean " + d + " > 1.0737418235E9");
        }
        this.rng = uniformRandomProvider;
        this.gaussian = new ZigguratNormalizedGaussianSampler(uniformRandomProvider);
        this.exponential = new AhrensDieterExponentialSampler(uniformRandomProvider, 1.0);
        this.factorialLog = NO_CACHE_FACTORIAL_LOG;
        this.lambda = Math.floor(d);
        this.logLambda = Math.log(this.lambda);
        this.logLambdaFactorial = this.factorialLog((int)this.lambda);
        this.delta = Math.sqrt(this.lambda * Math.log(32.0 * this.lambda / Math.PI + 1.0));
        this.halfDelta = this.delta / 2.0;
        this.twolpd = 2.0 * this.lambda + this.delta;
        this.c1 = 1.0 / (8.0 * this.lambda);
        double d2 = Math.sqrt(Math.PI * this.twolpd) * Math.exp(this.c1);
        double d3 = this.twolpd / this.delta * Math.exp(-this.delta * (1.0 + this.delta) / this.twolpd);
        double d4 = d2 + d3 + 1.0;
        this.p1 = d2 / d4;
        this.p2 = d3 / d4;
        double d5 = d - this.lambda;
        this.smallMeanPoissonSampler = d5 < Double.MIN_VALUE ? NO_SMALL_MEAN_POISSON_SAMPLER : new SmallMeanPoissonSampler(uniformRandomProvider, d5);
    }

    LargeMeanPoissonSampler(UniformRandomProvider uniformRandomProvider, LargeMeanPoissonSamplerState largeMeanPoissonSamplerState, double d) {
        if (d < 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("lambdaFractional must be in the range 0 (inclusive) to 1 (exclusive): " + d);
        }
        this.rng = uniformRandomProvider;
        this.gaussian = new ZigguratNormalizedGaussianSampler(uniformRandomProvider);
        this.exponential = new AhrensDieterExponentialSampler(uniformRandomProvider, 1.0);
        this.factorialLog = NO_CACHE_FACTORIAL_LOG;
        this.lambda = largeMeanPoissonSamplerState.getLambdaRaw();
        this.logLambda = largeMeanPoissonSamplerState.getLogLambda();
        this.logLambdaFactorial = largeMeanPoissonSamplerState.getLogLambdaFactorial();
        this.delta = largeMeanPoissonSamplerState.getDelta();
        this.halfDelta = largeMeanPoissonSamplerState.getHalfDelta();
        this.twolpd = largeMeanPoissonSamplerState.getTwolpd();
        this.p1 = largeMeanPoissonSamplerState.getP1();
        this.p2 = largeMeanPoissonSamplerState.getP2();
        this.c1 = largeMeanPoissonSamplerState.getC1();
        this.smallMeanPoissonSampler = d < Double.MIN_VALUE ? NO_SMALL_MEAN_POISSON_SAMPLER : new SmallMeanPoissonSampler(uniformRandomProvider, d);
    }

    @Override
    public int sample() {
        double d;
        int n;
        block6: {
            int n2 = n = this.smallMeanPoissonSampler == null ? 0 : this.smallMeanPoissonSampler.sample();
            while (true) {
                double d2;
                double d3;
                double d4;
                if ((d4 = this.rng.nextDouble()) <= this.p1) {
                    double d5 = this.gaussian.sample();
                    d3 = d5 * Math.sqrt(this.lambda + this.halfDelta) - 0.5;
                    if (d3 > this.delta || d3 < -this.lambda) continue;
                    d = d3 < 0.0 ? Math.floor(d3) : Math.ceil(d3);
                    double d6 = this.exponential.sample();
                    d2 = -d6 - 0.5 * d5 * d5 + this.c1;
                } else {
                    if (d4 > this.p1 + this.p2) {
                        d = this.lambda;
                        break block6;
                    }
                    d3 = this.delta + this.twolpd / this.delta * this.exponential.sample();
                    d = Math.ceil(d3);
                    d2 = -this.exponential.sample() - this.delta * (d3 + 1.0) / this.twolpd;
                }
                boolean bl = d3 < 0.0;
                double d7 = d * (d + 1.0) / (2.0 * this.lambda);
                if (d2 < -d7 && !bl) {
                    d = this.lambda + d;
                    break block6;
                }
                double d8 = d7 * ((2.0 * d + 1.0) / (6.0 * this.lambda) - 1.0);
                double d9 = d8 - d7 * d7 / (3.0 * (this.lambda + (double)bl * (d + 1.0)));
                if (d2 < d9) {
                    d = this.lambda + d;
                    break block6;
                }
                if (!(d2 > d8) && d2 < d * this.logLambda - this.factorialLog((int)(d + this.lambda)) + this.logLambdaFactorial) break;
            }
            d = this.lambda + d;
        }
        return (int)Math.min((long)n + (long)d, Integer.MAX_VALUE);
    }

    private double factorialLog(int n) {
        return this.factorialLog.value(n);
    }

    public String toString() {
        return "Large Mean Poisson deviate [" + this.rng.toString() + "]";
    }

    LargeMeanPoissonSamplerState getState() {
        return new LargeMeanPoissonSamplerState(this.lambda, this.logLambda, this.logLambdaFactorial, this.delta, this.halfDelta, this.twolpd, this.p1, this.p2, this.c1);
    }

    static {
        NO_SMALL_MEAN_POISSON_SAMPLER = null;
        NO_CACHE_FACTORIAL_LOG = InternalUtils.FactorialLog.create();
    }

    static final class LargeMeanPoissonSamplerState {
        private final double lambda;
        private final double logLambda;
        private final double logLambdaFactorial;
        private final double delta;
        private final double halfDelta;
        private final double twolpd;
        private final double p1;
        private final double p2;
        private final double c1;

        private LargeMeanPoissonSamplerState(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
            this.lambda = d;
            this.logLambda = d2;
            this.logLambdaFactorial = d3;
            this.delta = d4;
            this.halfDelta = d5;
            this.twolpd = d6;
            this.p1 = d7;
            this.p2 = d8;
            this.c1 = d9;
        }

        int getLambda() {
            return (int)this.getLambdaRaw();
        }

        double getLambdaRaw() {
            return this.lambda;
        }

        double getLogLambda() {
            return this.logLambda;
        }

        double getLogLambdaFactorial() {
            return this.logLambdaFactorial;
        }

        double getDelta() {
            return this.delta;
        }

        double getHalfDelta() {
            return this.halfDelta;
        }

        double getTwolpd() {
            return this.twolpd;
        }

        double getP1() {
            return this.p1;
        }

        double getP2() {
            return this.p2;
        }

        double getC1() {
            return this.c1;
        }
    }
}

